/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SkuChangePriceBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.bo.UccDealUmcMessageReqBO;
import com.tydic.commodity.zone.ability.bo.UccDealUmcMessageRspBO;
import com.tydic.commodity.zone.ability.bo.UccUpdateSaleNumBo;
import com.tydic.commodity.zone.ability.bo.UccUpdateSalesVolumeBO;
import com.tydic.commodity.zone.busi.api.UccDealUmcMessageService;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealUmcMessageServiceImpl
implements UccDealUmcMessageService {
    private static final Logger log = LoggerFactory.getLogger(UccDealUmcMessageServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccDealUmcMessageServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired(required=true)
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;

    @Override
    public UccDealUmcMessageRspBO dealUmcMessage(UccDealUmcMessageReqBO reqBO) {
        UccDealUmcMessageRspBO rspBO = new UccDealUmcMessageRspBO();
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6570\u636e\uff1a" + JSON.toJSONString((Object)reqBO));
        if (reqBO.getCommiditySkuStatus() != null) {
            this.uccSkuMapper.modifySkuByAgreement(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds(), reqBO.getCommiditySkuStatus());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List skuChangePriceBOS = reqBO.getSkuChangePriceBOs();
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            for (SkuChangePriceBO skuChangePriceBO : skuChangePriceBOS) {
                List uccSkuPos;
                if (skuChangePriceBO.getCommiditySkuStatus() != null) {
                    this.uccSkuMapper.modifySkuByAgreement((List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementId()}), (List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementSkuId()}), skuChangePriceBO.getCommiditySkuStatus());
                    continue;
                }
                Long agreementId = null;
                String agreementDetailId = null;
                if (skuChangePriceBO.getAgreementId() != null) {
                    agreementId = skuChangePriceBO.getAgreementId();
                }
                if (skuChangePriceBO.getAgreementSkuId() != null) {
                    agreementDetailId = String.valueOf(skuChangePriceBO.getAgreementSkuId());
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailId(agreementId, Long.valueOf(agreementDetailId))))) continue;
                if (skuChangePriceBO.getBuyNumber() != null) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(skuChangePriceBO.getBuyNumber().longValue()));
                    smcsdkStockNumInfoBO.setSkuId(((UccSkuPo)uccSkuPos.get(0)).getSkuId().toString());
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    try {
                        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
                        uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        uccSkuPricePo.setSalePrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                        uccSkuPricePo.setAgreementPrice(Long.valueOf(skuChangePriceBO.getBuyPrice().longValue()));
                        this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new BusinessException("8888", "\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
                    }
                    try {
                        UccSkuPo uccSkuPo1 = new UccSkuPo();
                        uccSkuPo1.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPo1.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        if (skuChangePriceBO.getSalePrice() != null) {
                            uccSkuPo1.setSkuPrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                        }
                        this.uccSkuMapper.updateSku(uccSkuPo1);
                        BigDecimal salePrice = skuChangePriceBO.getSalePrice();
                        this.updateLadderPrice(uccSkuPo.getSkuId(), uccSkuPo.getSupplierShopId(), salePrice);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new BusinessException("8888", "\u4fee\u6539\u4ef7\u683c\u4fe1\u606f\u5931\u8d25");
                    }
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(smcsdkStockNumInfoBOS)) {
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                smcsdkOperateStockNumReqBO.setOperateType("10");
                if (((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId() == null) {
                    smcsdkOperateStockNumReqBO.setObjectId("111111");
                } else {
                    smcsdkOperateStockNumReqBO.setObjectId(((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId().toString());
                }
                smcsdkOperateStockNumReqBO.setObjectType("20");
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                    }
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        this.dealSkuSyncEs(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u5904\u7406\u6210\u529f");
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6210\u529f");
        return rspBO;
    }

    private void dealSkuSyncEs(UccDealUmcMessageReqBO reqBO) {
        List uccSkuPos;
        Map<Object, Object> groupBySupplier = new HashMap();
        if ((org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementIds()) || org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementSkuIds())) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds())))) {
            groupBySupplier = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List agreementDetailIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementSkuId).collect(Collectors.toList());
            List agreementIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementId).collect(Collectors.toList());
            List uccSkuPos2 = this.uccSkuMapper.selectByAgreementDetailIds(agreementIds, agreementDetailIds);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccSkuPos2)) {
                groupBySupplier = uccSkuPos2.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            }
        }
        for (Map.Entry entry : groupBySupplier.entrySet()) {
            List skuIds = ((List)entry.getValue()).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId((Long)entry.getKey());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                LOGGER.error("\u540c\u6b65\u5546\u54c1\u72b6\u6001\u548c\u4ef7\u683c\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
    }

    private void updateLadderPrice(Long skuId, Long supplierShopId, BigDecimal salePrice) {
        List uccLadderPriceList = this.uccLadderPriceMapper.selectBySkuId(skuId, supplierShopId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccLadderPriceList)) {
            for (UccLadderPricePO uccLadderPrice : uccLadderPriceList) {
                UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
                BigDecimal discount = uccLadderPrice.getDiscount();
                if (discount == null) continue;
                BigDecimal price = discount.multiply(salePrice);
                uccLadderPricePO.setPrice(Long.valueOf(price.longValue()));
                uccLadderPricePO.setId(uccLadderPrice.getId());
                this.uccLadderPriceMapper.updateByExampleSelective(uccLadderPricePO);
            }
        }
    }

    private void dealStock(UccUpdateSalesVolumeBO uccUpdateSaleNumBo) {
        if (uccUpdateSaleNumBo == null) {
            return;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccUpdateSaleNumBo.getSaleNumBos())) {
            return;
        }
        Map<Integer, List<UccUpdateSaleNumBo>> map = uccUpdateSaleNumBo.getSaleNumBos().stream().filter(a -> a.getIncOrDec() != null).collect(Collectors.groupingBy(UccUpdateSaleNumBo::getIncOrDec));
        if (!CollectionUtils.isEmpty(map)) {
            for (Map.Entry<Integer, List<UccUpdateSaleNumBo>> each : map.entrySet()) {
                List<UccUpdateSaleNumBo> uccUpdateSaleNumBos = each.getValue();
                ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
                for (UccUpdateSaleNumBo uccUpdateSaleNumBo1 : uccUpdateSaleNumBos) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setSkuId(uccUpdateSaleNumBo1.getSkuId().toString());
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(uccUpdateSaleNumBo1.getSoldNumber().longValue()));
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                if (each.getKey() == 1) {
                    smcsdkOperateStockNumReqBO.setOperateType("40");
                } else if (each.getKey() == 0) {
                    smcsdkOperateStockNumReqBO.setOperateType("10");
                }
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if ("0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                        continue;
                    }
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }
}

