/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.comb.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.base.bo.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.UccAgrAppScopeBo;
import com.tydic.commodity.busibase.atom.bo.UccAgrSkuMinimalismCreateSupAtomBo;
import com.tydic.commodity.busibase.atom.bo.UccAgrSkuMinimalismInfoBo;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiReqBo;
import com.tydic.commodity.busibase.comb.api.UccSkuBatchAddRecordCombService;
import com.tydic.commodity.busibase.comb.bo.UccSkuBatchAddRecordCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuBatchAddRecordCombRspBO;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.busi.api.UccAgrMinimalismCreateSkuImportBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrMinimalismCreateSkuImportBusiReqBo;
import com.tydic.commodity.zone.busi.bo.UccAgrMinimalismCreateSkuImportBusiRspBo;
import com.tydic.commodity.zone.comb.api.UccAgrMinimalismCreateSkuImportCombService;
import com.tydic.commodity.zone.comb.bo.UccAgrMinimalismCreateSkuImportCombReqBo;
import com.tydic.commodity.zone.comb.bo.UccAgrMinimalismCreateSkuImportCombRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAgrMinimalismCreateSkuImportCombServiceImpl
implements UccAgrMinimalismCreateSkuImportCombService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrMinimalismCreateSkuImportCombServiceImpl.class);
    @Autowired
    private UccAgrMinimalismCreateSkuImportBusiService uccAgrMinimalismCreateSkuImportBusiService;
    @Autowired
    private UccSkuBatchAddRecordCombService uccSkuBatchAddRecordCombService;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccOrgAgrWhiteRestrictionBusiService uccOrgAgrWhiteRestrictionBusiService;

    @Override
    public UccAgrMinimalismCreateSkuImportCombRspBo minimalismImportSku(UccAgrMinimalismCreateSkuImportCombReqBo reqBo) {
        List<UccAgrSkuMinimalismInfoBo> skuMinimalismInfoBoList = reqBo.getSkuMinimalismInfoBoList();
        UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo = this.minimalismCreateSku(skuMinimalismInfoBoList, reqBo);
        this.insertAgrWhiteList(skuMinimalismInfoBoList, busiRspBo);
        if (reqBo.isSubmitEnable()) {
            this.syncEs(busiRspBo);
            this.addRecord(reqBo, busiRspBo);
        }
        this.syncAgrSenter(reqBo);
        UccAgrMinimalismCreateSkuImportCombRspBo combRspBo = new UccAgrMinimalismCreateSkuImportCombRspBo();
        combRspBo.setUccAgrSkuMinimalismCreateSupAtomBos(busiRspBo.getUccAgrSkuMinimalismCreateSupAtomBos());
        combRspBo.setRespCode("0000");
        combRspBo.setRespDesc("\u6210\u529f");
        return combRspBo;
    }

    private void insertAgrWhiteList(List<UccAgrSkuMinimalismInfoBo> skuMinimalismInfoBoList, UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo) {
        Map<Long, List<UccAgrSkuMinimalismInfoBo>> appScopes = skuMinimalismInfoBoList.stream().collect(Collectors.groupingBy(a -> a.getAgreementId()));
        HashSet<UccOrgSkuWhiteRestrictionBo> set = new HashSet<UccOrgSkuWhiteRestrictionBo>();
        for (UccAgrSkuMinimalismCreateSupAtomBo uccAgrSkuMinimalismInfoBo : busiRspBo.getUccAgrSkuMinimalismCreateSupAtomBos()) {
            if (!appScopes.containsKey(uccAgrSkuMinimalismInfoBo.getAgreementId()) || CollectionUtils.isEmpty((Collection)appScopes.get(uccAgrSkuMinimalismInfoBo.getAgreementId()).get(0).getUccAppScopeBoList())) continue;
            for (UccAgrAppScopeBo each : appScopes.get(uccAgrSkuMinimalismInfoBo.getAgreementId()).get(0).getUccAppScopeBoList()) {
                UccOrgSkuWhiteRestrictionBo uccOrgSkuWhiteRestrictionPo = new UccOrgSkuWhiteRestrictionBo();
                uccOrgSkuWhiteRestrictionPo.setAgreementId(uccAgrSkuMinimalismInfoBo.getAgreementId());
                uccOrgSkuWhiteRestrictionPo.setSupplierShopId(uccAgrSkuMinimalismInfoBo.getSupplierShopId());
                uccOrgSkuWhiteRestrictionPo.setSkuSource(3);
                uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(this.sequence.nextId()));
                if ("1".equals(each.getScopeCode()) || "0".equals(each.getScopeCode())) {
                    uccOrgSkuWhiteRestrictionPo.setOrgId(Long.valueOf(-1L));
                } else {
                    uccOrgSkuWhiteRestrictionPo.setOrgId(Convert.toLong((Object)each.getScopeCode()));
                }
                uccOrgSkuWhiteRestrictionPo.setOrgTreePath(each.getScopeOrgPath());
                uccOrgSkuWhiteRestrictionPo.setStatus(1);
                uccOrgSkuWhiteRestrictionPo.setCommodityId(uccAgrSkuMinimalismInfoBo.getCommodityId());
                set.add(uccOrgSkuWhiteRestrictionPo);
            }
        }
        if (!CollectionUtils.isEmpty(set)) {
            ArrayList uccOrgSkuWhiteRestrictionBos = new ArrayList(set);
            UccOrgSkuWhiteRestrictionBusiReqBo uccOrgSkuWhiteRestrictionBusiReqBo = new UccOrgSkuWhiteRestrictionBusiReqBo();
            uccOrgSkuWhiteRestrictionBusiReqBo.setWhites(uccOrgSkuWhiteRestrictionBos);
            try {
                this.uccOrgAgrWhiteRestrictionBusiService.dealWhite(uccOrgSkuWhiteRestrictionBusiReqBo);
            }
            catch (Exception e) {
                log.error("\u534f\u8bae\u53d1\u5e03\u8303\u56f4\u65b0\u589e\u5931\u8d25", (Throwable)e);
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
    }

    private void syncEs(UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo) {
        ConcurrentMap<Long, List<UccAgrSkuMinimalismCreateSupAtomBo>> supMap = busiRspBo.getUccAgrSkuMinimalismCreateSupAtomBos().stream().collect(Collectors.groupingByConcurrent(UccAgrSkuMinimalismCreateSupAtomBo::getSupplierShopId));
        if (null != supMap) {
            supMap.forEach((supId, uccAgrSkuMinimalismCreateSupAtomBos) -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(uccAgrSkuMinimalismCreateSupAtomBos.stream().map(UccAgrSkuMinimalismCreateSupAtomBo::getCommodityId).collect(Collectors.toList()));
                syncSceneCommodityToEsReqBO.setSupplierId(supId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
            });
        }
    }

    private void syncAgrSenter(UccAgrMinimalismCreateSkuImportCombReqBo reqBo) {
        if (UccConstants.MinimalismCreateType.HAVE_DETAILS.equals(reqBo.getCreateType())) {
            try {
                ConcurrentMap<Long, List<UccAgrSkuMinimalismInfoBo>> agrMap = reqBo.getSkuMinimalismInfoBoList().stream().collect(Collectors.groupingByConcurrent(UccAgrSkuMinimalismInfoBo::getAgreementId));
                agrMap.forEach((agrId, uccAgrSkuMinimalismInfoBos) -> {
                    UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
                    notifyMessageBO.setAuditStatus("0");
                    notifyMessageBO.setStationCode("0");
                    notifyMessageBO.setAgreementId(Convert.toStr((Object)agrId));
                    notifyMessageBO.setAgreementSkuIds(uccAgrSkuMinimalismInfoBos.stream().map(e -> Convert.toStr((Object)e.getAgreementDetailsId())).collect(Collectors.toList()));
                    notifyMessageBO.setAgreementSkuStatus("0");
                    notifyMessageBO.setMemIdIn(reqBo.getUserId());
                    notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_UP_SHELF.code());
                    log.info("\u521b\u5efa\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
                    this.zoneGoodsAuditMQ.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TOPIC"), PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
                });
            }
            catch (Exception var16) {
                log.error("\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
            }
        }
    }

    private void addRecord(UccAgrMinimalismCreateSkuImportCombReqBo reqBo, UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo) {
        UccSkuBatchAddRecordCombReqBO uccSkuBatchAddRecordCombReqBO = new UccSkuBatchAddRecordCombReqBO();
        uccSkuBatchAddRecordCombReqBO.setObjType(UccConstants.BatchObjType.SKU);
        uccSkuBatchAddRecordCombReqBO.setDealType(UccConstants.BatchDealType.SKU_EDIT_SUBMIT_DRAFT);
        uccSkuBatchAddRecordCombReqBO.setSource(UccConstants.Source.AGR);
        uccSkuBatchAddRecordCombReqBO.setUserId(reqBo.getUserId());
        uccSkuBatchAddRecordCombReqBO.setName(reqBo.getName());
        uccSkuBatchAddRecordCombReqBO.setOrgId(reqBo.getOrgId());
        uccSkuBatchAddRecordCombReqBO.setOrgName(reqBo.getOrgName());
        uccSkuBatchAddRecordCombReqBO.setCompanyId(reqBo.getCompanyId());
        uccSkuBatchAddRecordCombReqBO.setCompanyName(reqBo.getCompanyName());
        uccSkuBatchAddRecordCombReqBO.setBatchObjList(busiRspBo.getUccAgrSkuMinimalismCreateSupAtomBos().stream().map(uccAgrSkuMinimalismCreateSupAtomBo -> {
            UccSkuBatchAddRecordBO uccSkuBatchAddRecordBO = new UccSkuBatchAddRecordBO();
            uccSkuBatchAddRecordBO.setObjId(uccAgrSkuMinimalismCreateSupAtomBo.getSkuId());
            return uccSkuBatchAddRecordBO;
        }).collect(Collectors.toList()));
        UccSkuBatchAddRecordCombRspBO uccSkuBatchAddRecordCombRspBO = this.uccSkuBatchAddRecordCombService.addRecrod(uccSkuBatchAddRecordCombReqBO);
        if (!"0000".equals(uccSkuBatchAddRecordCombRspBO.getRespCode())) {
            throw new BusinessException("8888", uccSkuBatchAddRecordCombRspBO.getRespDesc());
        }
    }

    private UccAgrMinimalismCreateSkuImportBusiRspBo minimalismCreateSku(List<UccAgrSkuMinimalismInfoBo> subList, UccAgrMinimalismCreateSkuImportCombReqBo reqBo) {
        UccAgrMinimalismCreateSkuImportBusiReqBo busiReqBo = new UccAgrMinimalismCreateSkuImportBusiReqBo();
        busiReqBo.setUsername(reqBo.getUsername());
        busiReqBo.setUserId(reqBo.getUserId());
        busiReqBo.setName(reqBo.getName());
        busiReqBo.setOperLogEnable(reqBo.isOperLogEnable());
        busiReqBo.setSkuMinimalismInfoBoList(subList);
        UccAgrMinimalismCreateSkuImportBusiRspBo busiRspBo = this.uccAgrMinimalismCreateSkuImportBusiService.minimalismImportSku(busiReqBo);
        if (!"0000".equals(busiRspBo.getRespCode())) {
            throw new BusinessException("8888", busiRspBo.getRespDesc());
        }
        return busiRspBo;
    }
}

