/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.onecode.onecode.common.bo.enums;

import java.util.HashMap;

public enum PriceTypeEnum {
    MARKET("market", "\u5e02\u573a\u4ef7"),
    SALES("sales", "\u9500\u552e\u4ef7"),
    STRIKE("strike", "\u6210\u4ea4\u4ef7"),
    ORDER("order", "\u8ba2\u5355\u4ef7"),
    CNEPTP("cneptp", "\u4e2d\u8d44\u4ef7"),
    PURCHASE("purchase", "\u91c7\u8d2d\u4ef7");

    private String type;
    private String name;

    private PriceTypeEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean checkValidType(String type) {
        return this.type.equals(type);
    }

    public static String getNameByCode(String type) {
        for (PriceTypeEnum field : PriceTypeEnum.values()) {
            if (!field.type.equals(type)) continue;
            return field.name;
        }
        return type;
    }

    public static class Map {
        public static final java.util.Map<String, String> priceTypesMap = new HashMap<String, String>(){
            {
                this.put("marketPrice", "market");
                this.put("salesPrice", "sales");
                this.put("strikePrice", "strike");
                this.put("orderPrice", "order");
                this.put("purchasePrice", "purchase");
            }
        };

        public static Boolean checkPriceType(String priceType) {
            return priceTypesMap.containsKey(priceType);
        }
    }
}

