/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.onecode.onecode.common.bo.enums.commdity;

import com.tydic.onecode.onecode.common.bo.enums.commdity.CommonEnum;
import com.tydic.onecode.onecode.common.bo.enums.commdity.categroy19090201.Enum19090201;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EnumUtils {
    public static <T extends CommonEnum> String getEnumByName(String code, Class<T> enumClass) {
        String result = null;
        for (CommonEnum each : (CommonEnum[])enumClass.getEnumConstants()) {
            if (!each.getCode().equals(code)) continue;
            result = each.getCode().toString();
        }
        if (result == null) {
            Float aFloat;
            HashMap<CommonEnum, Float> map = new HashMap<CommonEnum, Float>();
            for (CommonEnum value : (CommonEnum[])enumClass.getEnumConstants()) {
                map.put(value, Float.valueOf(EnumUtils.levenshteinByEnum(value.getCode().toString(), code)));
            }
            ArrayList list = new ArrayList(map.entrySet());
            Collections.sort(list, (o1, o2) -> (int)((((Float)o2.getValue()).floatValue() - ((Float)o1.getValue()).floatValue()) * 10000.0f));
            if (list.size() > 0 && (double)(aFloat = (Float)((Map.Entry)list.get(0)).getValue()).floatValue() > 0.7) {
                return ((CommonEnum)((Map.Entry)list.get(0)).getKey()).getCode().toString();
            }
        }
        return "";
    }

    public static void main(String[] args) {
        System.out.println(EnumUtils.getEnumByName("\u4ea4\u8054\u7535\u529b\u7535", Enum19090201.class));
        System.out.println(EnumUtils.levenshteinByEnum("\u4ea4\u8054\u7535\u529b\u7535\u7f06", "\u8fdc\u4e1c \u963b\u71c3C\u7c7b\u4ea4\u8054\u805a\u4e59\u70ef\u7edd\u7f18\u805a\u6c2f\u4e59\u70ef\u62a4\u5957\u7535\u529b\u7535\u7f06\uff0cZC-YJV-0.6/1kV-1*400\uff0c100\u7c73\u8d77\u8ba2"));
    }

    public static float levenshtein(String str1, String str2) {
        int a;
        int len1 = str1.length();
        int len2 = str2.length();
        int[][] dif = new int[len1 + 1][len2 + 1];
        for (a = 0; a <= len1; ++a) {
            dif[a][0] = a;
        }
        for (a = 0; a <= len2; ++a) {
            dif[0][a] = a;
        }
        for (int i = 1; i <= len1; ++i) {
            for (int j = 1; j <= len2; ++j) {
                int temp = str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1;
                dif[i][j] = EnumUtils.min(dif[i - 1][j - 1] + temp, dif[i][j - 1] + 1, dif[i - 1][j] + 1);
            }
        }
        float similarity = 1.0f - (float)dif[len1][len2] / (float)Math.max(str1.length(), str2.length());
        return similarity;
    }

    private static int min(int ... is) {
        int min = Integer.MAX_VALUE;
        for (int i : is) {
            if (min <= i) continue;
            min = i;
        }
        return min;
    }

    public static float levenshteinByEnum(String str1, String str2) {
        int a;
        int len1 = str1.length();
        int len2 = str2.length();
        int[][] dif = new int[len1 + 1][len2 + 1];
        for (a = 0; a <= len1; ++a) {
            dif[a][0] = a;
        }
        for (a = 0; a <= len2; ++a) {
            dif[0][a] = a;
        }
        float temp = 0.0f;
        block2: for (int i = 1; i <= len1; ++i) {
            for (int j = 1; j <= len2; ++j) {
                if (str1.charAt(i - 1) != str2.charAt(j - 1)) continue;
                temp += 1.0f;
                if (i >= len1 || j >= len2 || str1.charAt(i) != str2.charAt(j)) continue block2;
                temp = (float)((double)temp + 0.1);
                continue block2;
            }
        }
        float similarity = temp / (float)len1;
        return similarity;
    }
}

