/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.onecode.onecode.common.bo.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtil {
    private static final Logger log = LoggerFactory.getLogger(CookieUtil.class);

    public static String getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static void setCookie(HttpServletResponse response, String cookieName, String value, int cookieMaxAge) {
        Cookie cookie = new Cookie(cookieName, value);
        cookie.setPath("/");
        cookie.setMaxAge(cookieMaxAge);
        response.addCookie(cookie);
        log.info("write cookieName:{},cookieValue:{}", (Object)cookie.getName(), (Object)cookie.getValue());
    }

    public static void deleteCookie(HttpServletResponse response, String cookieName) {
        CookieUtil.setCookie(response, cookieName, null, 0);
    }
}

