/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.onecode.onecode.common.bo.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class CountModelUtils {
    public static String quartileCalculator(List<BigDecimal> priceRange) {
        String result = "";
        if (CollectionUtils.isEmpty(priceRange) || priceRange.size() < 4) {
            return result;
        }
        int size = priceRange.size();
        if (size % 2 == 0) {
            int firstDigit = (int)Math.round((double)size * 0.25);
            int secondDigit = (int)Math.round((double)size * 0.25) + 1;
            result = priceRange.get(firstDigit - 1).add(priceRange.get(secondDigit - 1)).divide(new BigDecimal(20000), 2, 1).toString();
        } else {
            int secondDigit = (int)Math.round((double)(size + 1) * 0.25);
            result = priceRange.get(secondDigit - 1).divide(new BigDecimal(10000), 2, 1).toString();
        }
        return result;
    }

    public static String averageCalculator(List<BigDecimal> priceRange) {
        BigDecimal median;
        String result = "";
        if (CollectionUtils.isEmpty(priceRange) || priceRange.size() < 3) {
            return result;
        }
        int size = priceRange.size();
        if (size % 2 == 0) {
            int position = size / 2;
            BigDecimal divide = priceRange.get(position).subtract(priceRange.get(position - 1)).divide(priceRange.get(position - 1), 2, 1);
            if (divide.compareTo(new BigDecimal(5)) == 1) {
                priceRange.remove(size - 1);
                median = priceRange.get(position - 1);
            } else {
                median = priceRange.get(position - 1).add(priceRange.get(position)).divide(new BigDecimal(2));
            }
        } else {
            double a = (double)size / 2.0;
            int position = (int)Math.round(a);
            median = priceRange.get(position - 1);
        }
        BigDecimal max = median.multiply(new BigDecimal(1.5));
        BigDecimal min = median.multiply(new BigDecimal(0.5));
        List collect = priceRange.stream().filter(item -> item.compareTo(min) > -1 && item.compareTo(max) < 1).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            result = collect.stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(new BigDecimal(collect.size() * 10000), 2, 1).toString();
        }
        return result;
    }

    public static String minimumCalculator(List<BigDecimal> priceRange) {
        BigDecimal median;
        String result = "";
        if (CollectionUtils.isEmpty(priceRange) || priceRange.size() < 3) {
            return result;
        }
        int size = priceRange.size();
        if (size % 2 == 0) {
            int firstDigit = size / 2;
            median = priceRange.get(firstDigit - 1).add(priceRange.get(firstDigit)).divide(new BigDecimal(2));
        } else {
            double a = (double)size / 2.0;
            int firstDigit = (int)Math.round(a);
            median = priceRange.get(firstDigit - 1);
        }
        BigDecimal max = median.multiply(new BigDecimal(1.5));
        BigDecimal min = median.multiply(new BigDecimal(0.5));
        List collect = priceRange.stream().filter(item -> item.compareTo(min) > -1 && item.compareTo(max) < 1).collect(Collectors.toList());
        Collections.sort(collect);
        if (!CollectionUtils.isEmpty(collect)) {
            result = ((BigDecimal)collect.get(0)).divide(new BigDecimal(10000), 2, 1).toString();
        }
        return result;
    }

    public static String guidePrice(List<BigDecimal> salesList) {
        String guidePrice = "";
        BigDecimal sum = new BigDecimal("0");
        for (BigDecimal sales1 : salesList) {
            sum = sum.add(sales1);
        }
        guidePrice = sum.divide(new BigDecimal("10000")).divide(new BigDecimal(salesList.size()), 2, 1).toString();
        return guidePrice;
    }

    public static void main(String[] args) {
        ArrayList<BigDecimal> bigDecimalList = new ArrayList<BigDecimal>();
        bigDecimalList.add(new BigDecimal("2300000"));
        bigDecimalList.add(new BigDecimal("2000000"));
        bigDecimalList.add(new BigDecimal("300000"));
        bigDecimalList.add(new BigDecimal("200000"));
        Collections.sort(bigDecimalList);
        String s = CountModelUtils.quartileCalculator(bigDecimalList);
        String avarge = CountModelUtils.averageCalculator(bigDecimalList);
        String min = CountModelUtils.minimumCalculator(bigDecimalList);
        System.out.println("\u7ed3\u679c\u503c1: " + avarge);
        System.out.println("\u7ed3\u679c\u503c2: " + min);
    }
}

