/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.onecode.onecode.common.bo.utils;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;

public final class DateFormatter {
    public static final String PATTERN_yyyyMMdd = "yyyyMMdd";
    public static final String yyyyMMdd = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String PATTERN_yyyy_MM_dd = "yyyy-MM-dd";
    public static final String PATTERN_HHmmss = "HHmmss";
    public static final String PATTERN_HH_mm_ss = "HH:mm:ss";
    public static final String PATTERN_yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String PATTERN_yyyyMMddHHmmsssss = "yyyyMMddHHmmsssss";
    public static final String PATTERN_yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_yyyy_MM_dd_HH_mm = "yyyy-MM-dd HH:mm";
    public static final String PATTERN_HH_mm = "HH:mm";
    public static final String PATTERN_HHmmssSSS = "HHmmssSSS";
    public static final String PATTERN_DATEPATH = "yyyy-MM/dd";
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int DAYS_PER_WEEK = 7;

    private DateFormatter() {
    }

    public static String format(String pattern, Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime((Object)date).toString(pattern);
    }

    public static String format(String pattern, Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return new DateTime((Object)calendar).toString(pattern);
    }

    public static Date parse(String pattern, String date) {
        if (date == null) {
            return null;
        }
        return DateTimeFormat.forPattern((String)pattern).parseDateTime(date).toDate();
    }

    public static String format(String pattern) {
        return DateFormatter.format(pattern, DateFormatter.now());
    }

    public static String yyyyMMdd(Date date) {
        return DateFormatter.format(PATTERN_yyyyMMdd, date);
    }

    public static String yyyyMMdd2(Date date) {
        return DateFormatter.format(yyyyMMdd, date);
    }

    public static String yyyyMMdd(Calendar calendar) {
        return DateFormatter.format(PATTERN_yyyyMMdd, calendar);
    }

    public static String yyyyMMdd() {
        return DateFormatter.format(PATTERN_yyyyMMdd, DateFormatter.now());
    }

    public static Date yyyyMMdd(String date) {
        return DateFormatter.parse(PATTERN_yyyyMMdd, date);
    }

    public static String HHmmss(Date date) {
        return DateFormatter.format(PATTERN_HHmmss, date);
    }

    public static String HHmmss(Calendar calendar) {
        return DateFormatter.format(PATTERN_HHmmss, calendar);
    }

    public static String HHmmss() {
        return DateFormatter.format(PATTERN_HHmmss, DateFormatter.now());
    }

    public static Date HHmmss(String date) {
        return DateFormatter.parse(PATTERN_HHmmss, date);
    }

    public static String yyyy_MM_dd(Date date) {
        return DateFormatter.format(PATTERN_yyyy_MM_dd, date);
    }

    public static String yyyy_MM_dd(Calendar calendar) {
        return DateFormatter.format(PATTERN_yyyy_MM_dd, calendar);
    }

    public static String yyyy_MM_dd() {
        return DateFormatter.format(PATTERN_yyyy_MM_dd, DateFormatter.now());
    }

    public static Date yyyy_MM_dd(String date) {
        return DateFormatter.parse(PATTERN_yyyy_MM_dd, date);
    }

    public static String HH_mm_ss(Date date) {
        return DateFormatter.format(PATTERN_HH_mm_ss, date);
    }

    public static String HH_mm_ss(Calendar calendar) {
        return DateFormatter.format(PATTERN_HH_mm_ss, calendar);
    }

    public static String HH_mm_ss() {
        return DateFormatter.format(PATTERN_HH_mm_ss, DateFormatter.now());
    }

    public static Date HH_mm_ss(String date) {
        return DateFormatter.parse(PATTERN_HH_mm_ss, date);
    }

    public static String yyyyMMddHHmmss(Date date) {
        return DateFormatter.format(PATTERN_yyyyMMddHHmmss, date);
    }

    public static String yyyyMMddHHmmss(Calendar calendar) {
        return DateFormatter.format(PATTERN_yyyyMMddHHmmss, calendar);
    }

    public static String yyyyMMddHHmmss() {
        return DateFormatter.format(PATTERN_yyyyMMddHHmmss, DateFormatter.now());
    }

    public static String yyyyMMddHHmmsssss() {
        return DateFormatter.format(PATTERN_yyyyMMddHHmmsssss, DateFormatter.now());
    }

    public static Date yyyyMMddHHmmss(String date) {
        return DateFormatter.parse(PATTERN_yyyyMMddHHmmss, date);
    }

    public static String yyyy_MM_dd_HH_mm_ss(Date date) {
        return DateFormatter.format(PATTERN_yyyy_MM_dd_HH_mm_ss, date);
    }

    public static String yyyy_MM_dd_HH_mm_ss(Calendar calendar) {
        return DateFormatter.format(PATTERN_yyyy_MM_dd_HH_mm_ss, calendar);
    }

    public static String yyyy_MM_dd_HH_mm_ss() {
        return DateFormatter.format(PATTERN_yyyy_MM_dd_HH_mm_ss, DateFormatter.now());
    }

    public static Date yyyy_MM_dd_HH_mm_ss(String date) {
        return DateFormatter.parse(PATTERN_yyyy_MM_dd_HH_mm_ss, date);
    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis());
    }

    public static String yyyy_MM_dd_HH_mm(Date date) {
        return DateFormatter.format(PATTERN_yyyy_MM_dd_HH_mm, date);
    }

    public static String yyyy_MM_dd_HH_mm(Calendar calendar) {
        return DateFormatter.format(PATTERN_yyyy_MM_dd_HH_mm, calendar);
    }

    public static String yyyy_MM_dd_HH_mm() {
        return DateFormatter.format(PATTERN_yyyy_MM_dd_HH_mm, DateFormatter.now());
    }

    public static Date yyyy_MM_dd_HH_mm(String date) {
        return DateFormatter.parse(PATTERN_yyyy_MM_dd_HH_mm, date);
    }

    public static String HH_mm(Date date) {
        return DateFormatter.format(PATTERN_HH_mm, date);
    }

    public static String HH_mm(Calendar calendar) {
        return DateFormatter.format(PATTERN_HH_mm, calendar);
    }

    public static String HH_mm() {
        return DateFormatter.format(PATTERN_HH_mm, DateFormatter.now());
    }

    public static Date HH_mm(String date) {
        return DateFormatter.parse(PATTERN_HH_mm, date);
    }

    public static String HHmmssSSS(Date date) {
        return DateFormatter.format(PATTERN_HHmmssSSS, date);
    }

    public static String HHmmssSSS(Calendar date) {
        return DateFormatter.format(PATTERN_HHmmssSSS, date);
    }

    public static String HHmmssSSS() {
        return DateFormatter.format(PATTERN_HHmmssSSS, DateFormatter.now());
    }

    public static Date HHmmssSSS(String date) {
        return DateFormatter.parse(PATTERN_HHmmssSSS, date);
    }

    public static Date now() {
        return DateTime.now().toDate();
    }

    public static Calendar calendar() {
        return DateTime.now().toCalendar(Locale.getDefault());
    }

    public static long millis() {
        return System.currentTimeMillis();
    }

    public static Date startOfDay() {
        return DateFormatter.startOfDay(DateFormatter.now());
    }

    public static Date endOfDay() {
        return DateFormatter.endOfDay(DateFormatter.now());
    }

    public static Date startOfDay(Date date) {
        return new DateTime(date.getTime()).withTimeAtStartOfDay().toDate();
    }

    public static Date endOfDay(Date date) {
        return new DateTime(date.getTime()).millisOfDay().withMaximumValue().toDate();
    }

    public static Date startOfMonth() {
        return DateFormatter.startOfMonth(DateFormatter.now());
    }

    public static Date startOfMonth(Date date) {
        return new DateTime(date.getTime()).dayOfMonth().withMinimumValue().withTimeAtStartOfDay().toDate();
    }

    public static Date endOfMonth() {
        return DateTime.now().dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue().toDate();
    }

    public static Date endOfMonth(Date date) {
        return new DateTime(date.getTime()).dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue().toDate();
    }

    public static Date startOfWeek() {
        return DateTime.now().dayOfWeek().withMinimumValue().withTimeAtStartOfDay().toDate();
    }

    public static Date startOfWeek(Date date) {
        return new DateTime(date.getTime()).dayOfWeek().withMinimumValue().withTimeAtStartOfDay().toDate();
    }

    public static Date endOfWeek() {
        return DateTime.now().dayOfWeek().withMaximumValue().millisOfDay().withMaximumValue().toDate();
    }

    public static Date endOfWeek(Date date) {
        return new DateTime((Object)date).dayOfWeek().withMaximumValue().millisOfDay().withMaximumValue().toDate();
    }

    public static boolean expiredSeconds(Date from, int seconds) {
        return DateFormatter.expiredSeconds(from, DateFormatter.now(), seconds);
    }

    public static boolean expiredSeconds(Date from, Date to, int seconds) {
        return new DateTime((Object)from).plusSeconds(seconds).isBefore(to.getTime());
    }

    public static boolean expiredMinutes(Date from, int minutes) {
        return DateFormatter.expiredMinutes(from, DateFormatter.now(), minutes);
    }

    public static boolean expiredMinutes(Date from, Date to, int minutes) {
        return new DateTime((Object)from).plusMinutes(minutes).isBefore(to.getTime());
    }

    public static boolean expiredHours(Date from, int hours) {
        return DateFormatter.expiredHours(from, DateFormatter.now(), hours);
    }

    public static boolean expiredHours(Date from, Date to, int hours) {
        return new DateTime((Object)from).plusHours(hours).isBefore(to.getTime());
    }

    public static boolean expiredDays(Date from, int days) {
        return DateFormatter.expiredDays(from, DateFormatter.now(), days);
    }

    public static boolean expiredDays(Date from, Date to, int days) {
        return new DateTime((Object)from).plusDays(days).isBefore(to.getTime());
    }

    public static boolean expiredMonth(Date from, int month) {
        return DateFormatter.expiredMonth(from, DateFormatter.now(), month);
    }

    public static boolean expiredMonth(Date from, Date to, int months) {
        return new DateTime((Object)from).plusMonths(months).isBefore(to.getTime());
    }

    public static boolean sameDay(Date from) {
        return DateFormatter.sameDay(from, DateFormatter.now());
    }

    public static boolean sameDay(Date from, Date to) {
        return DateFormatter.startOfDay(from).equals(DateFormatter.startOfDay(to));
    }

    public static boolean sameWeek(Date from) {
        return DateFormatter.sameWeek(from, DateFormatter.now());
    }

    public static boolean sameWeek(Date from, Date to) {
        return DateFormatter.startOfWeek(from).equals(DateFormatter.startOfWeek(to));
    }

    public static int days(Date from, Date to) {
        from = DateFormatter.startOfDay(from);
        to = DateFormatter.startOfDay(to);
        return (int)((to.getTime() - from.getTime()) / 86400000L);
    }

    public static String datePath() {
        return DateFormatter.format(PATTERN_DATEPATH);
    }

    public static String datePath(Date date) {
        return DateFormatter.format(PATTERN_DATEPATH, date);
    }

    public static java.sql.Date sqlDate(Date date) {
        return new java.sql.Date(date.getTime());
    }

    public static java.sql.Date sqlDate() {
        return DateFormatter.sqlDate(DateFormatter.now());
    }

    public static Time sqlTime(Date date) {
        return new Time(date.getTime());
    }

    public static Time sqlTime() {
        return DateFormatter.sqlTime(DateFormatter.now());
    }

    public static Timestamp sqlTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp sqlTimestamp() {
        return DateFormatter.sqlTimestamp(DateFormatter.now());
    }

    public static Date nextYear(Date from) {
        return DateFormatter.nextYear(from, 1);
    }

    public static Date previousYear(Date from) {
        return DateFormatter.nextYear(from, -1);
    }

    public static Date nextDay(Date from) {
        return DateFormatter.nextDay(from, 1);
    }

    public static Date previousDay(Date from) {
        return DateFormatter.nextDay(from, -1);
    }

    public static Date nextWeek(Date from) {
        return DateFormatter.nextWeek(from, 1);
    }

    public static Date previousWeek(Date from) {
        return DateFormatter.nextDay(from, -1);
    }

    public static Date nextMonth(Date from) {
        return DateFormatter.nextMonth(from, 1);
    }

    public static Date previousMonth(Date from) {
        return DateFormatter.nextMonth(from, -1);
    }

    public static Date nextHour(Date from) {
        return DateFormatter.nextHour(from, 1);
    }

    public static Date previousHour(Date from) {
        return DateFormatter.nextHour(from, -1);
    }

    public static Date nextYear(Date from, int years) {
        return new DateTime((Object)from).plusYears(years).toDate();
    }

    public static Date nextDay(Date from, int days) {
        return new DateTime((Object)from).plusDays(days).toDate();
    }

    public static Date nextSecond(Date from) {
        return DateFormatter.nextSecond(from, 1);
    }

    public static Date nextSecond(Date from, int seconds) {
        return new DateTime((Object)from).plusSeconds(seconds).toDate();
    }

    public static Date nextWeek(Date from, int weeks) {
        return new DateTime((Object)from).plusWeeks(weeks).toDate();
    }

    public static Date nextMonth(Date from, int months) {
        return new DateTime((Object)from).plusMonths(months).toDate();
    }

    public static Date nextHour(Date from, int hours) {
        return new DateTime((Object)from).plusHours(hours).toDate();
    }

    public static Date next(Date from, Period period) {
        return new DateTime((Object)from).plus((ReadablePeriod)period).toDate();
    }

    public static Date next(Period period) {
        return DateTime.now().plus((ReadablePeriod)period).toDate();
    }

    public static int months(Date from, Date to) {
        return to.getMonth() - from.getMonth() + (to.getYear() - from.getYear()) * 12;
    }

    public static String d8to10(String yyyyMMdd) {
        return DateFormatter.yyyy_MM_dd(DateFormatter.yyyyMMdd(yyyyMMdd));
    }

    public static String d8to10(String yyyyMMdd, int days) {
        return DateFormatter.yyyy_MM_dd(DateFormatter.nextDay(DateFormatter.yyyyMMdd(yyyyMMdd), days));
    }

    public static String d8(String yyyyMMdd, int days) {
        return DateFormatter.yyyyMMdd(DateFormatter.nextDay(DateFormatter.yyyyMMdd(yyyyMMdd), days));
    }

    public static String d10(String yyyy_MM_dd, int days) {
        return DateFormatter.yyyy_MM_dd(DateFormatter.nextDay(DateFormatter.yyyy_MM_dd(yyyy_MM_dd), days));
    }

    public static String d10to8(String yyyy_MM_dd) {
        return DateFormatter.yyyyMMdd(DateFormatter.yyyy_MM_dd(yyyy_MM_dd));
    }

    public static String d10to8(String yyyy_MM_dd, int days) {
        return DateFormatter.yyyyMMdd(DateFormatter.nextDay(DateFormatter.yyyy_MM_dd(yyyy_MM_dd), days));
    }
}

