/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.onecode.onecode.common.bo.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private static final String XLS = "xls";
    private static final String XLSX = "xlsx";
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static void generateExcelFile(List<String> headers, List<String> keyList, File outputWay, List<Object> data2) throws IOException {
        File parentFile = outputWay.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        ExcelUtil.writeDataToTemplateOutputStream(outputWay, headers, keyList, data2, new FileOutputStream(outputWay));
    }

    public static void generateExcelFile(File outputWay, JSONArray dataArr) throws IOException {
        ExcelUtil.writeDataToTemplateOutputStream(outputWay, dataArr, new FileOutputStream(outputWay));
    }

    public static void generateExcelFileMultiSheet(List<List<String>> headers, List<List<String>> keyList, File outputWay, List<List<Object>> data2) throws IOException {
        ExcelUtil.writeDataToTemplateOutputStream(outputWay, headers, keyList, data2);
    }

    public static void writeDataToTemplateOutputStream(File excelTemplate, List<String> title, List<String> keyList, List<Object> data2, OutputStream outputStream) throws IOException {
        Workbook book = ExcelUtil.getWorkbookFromExcel(excelTemplate);
        ArrayList<List<String>> titles = new ArrayList<List<String>>();
        ArrayList<List<String>> keyLists = new ArrayList<List<String>>();
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
        titles.add(title);
        keyLists.add(keyList);
        datas.add(data2);
        ExcelUtil.writeDataToWorkbook(titles, keyLists, datas, book);
        ExcelUtil.writeWorkbookToOutputStream(book, outputStream);
    }

    public static void writeDataToTemplateOutputStream(File excelTemplate, JSONArray dataArr, OutputStream outputStream) throws IOException {
        Workbook book = ExcelUtil.getWorkbookFromExcel(excelTemplate);
        ExcelUtil.writeDataToWorkbook(dataArr, book);
        ExcelUtil.writeWorkbookToOutputStream(book, outputStream);
    }

    public static void writeDataToTemplateOutputStream(File excelTemplate, List<List<String>> titles, List<List<String>> keyLists, List<List<Object>> datas) throws IOException {
        Workbook book = ExcelUtil.getWorkbookFromExcel(excelTemplate);
        ExcelUtil.writeDataToWorkbook(titles, keyLists, datas, book);
        ExcelUtil.writeWorkbookToOutputStream(book, new FileOutputStream(excelTemplate));
    }

    public static Workbook getWorkbookFromExcel(File excelFile) throws IOException {
        if (excelFile.getName().endsWith(XLS)) {
            ExcelUtil.resetCellMaxTextLength(XLS);
            return new HSSFWorkbook();
        }
        if (excelFile.getName().endsWith(XLSX)) {
            ExcelUtil.resetCellMaxTextLength(XLSX);
            return new XSSFWorkbook();
        }
        throw new IOException("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
    }

    public static void resetCellMaxTextLength(String XL) {
        SpreadsheetVersion excel2007 = XL.equals(XLS) ? SpreadsheetVersion.EXCEL97 : SpreadsheetVersion.EXCEL2007;
        if (Integer.MAX_VALUE != excel2007.getMaxTextLength()) {
            try {
                Field field = excel2007.getClass().getDeclaredField("_maxTextLength");
                field.setAccessible(true);
                field.set(excel2007, Integer.MAX_VALUE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeWorkbookToFile(Workbook book, File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            ExcelUtil.writeWorkbookToOutputStream(book, outputStream);
        }
    }

    public static void writeWorkbookToOutputStream(Workbook book, OutputStream outputStream) throws IOException {
        book.write(outputStream);
    }

    public static void writeDataToWorkbook(List<List<String>> titles, List<List<String>> keyLists, List<List<Object>> datas, Workbook book) {
        for (int ii = 0; ii < titles.size(); ++ii) {
            int i;
            Cell cell;
            Row row;
            List<String> title = titles.get(ii);
            List<String> keyList = keyLists.get(ii);
            List<Object> data2 = datas.get(ii);
            Sheet sheet = book.createSheet();
            CellStyle cellStyle1 = book.createCellStyle();
            cellStyle1.setBorderBottom(BorderStyle.THIN);
            cellStyle1.setBorderLeft(BorderStyle.THIN);
            cellStyle1.setBorderTop(BorderStyle.THIN);
            cellStyle1.setBorderRight(BorderStyle.THIN);
            cellStyle1.setAlignment(HorizontalAlignment.CENTER);
            cellStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle1.setWrapText(true);
            cellStyle1.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellStyle1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            CellStyle cellStyle = book.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setWrapText(true);
            HashMap<Integer, Integer> maxWidth = new HashMap<Integer, Integer>();
            if (null != title && !title.isEmpty()) {
                row = sheet.getRow(0);
                if (null == row) {
                    row = sheet.createRow(0);
                }
                for (int i2 = 0; i2 < title.size(); ++i2) {
                    cell = row.getCell(i2);
                    if (null == cell) {
                        cell = row.createCell(i2);
                    }
                    cell.setCellValue(title.get(i2));
                    cell.setCellStyle(cellStyle1);
                    int length = cell.getStringCellValue().getBytes().length * 256 + 512;
                    if (length > 15000) {
                        length = 15000;
                    }
                    maxWidth.put(i2, Math.max(length, maxWidth.get(i2) == null ? 0 : (Integer)maxWidth.get(i2)));
                }
            }
            Object rowData = null;
            for (i = 0; i < data2.size(); ++i) {
                row = sheet.getRow(i + 1);
                if (null == row) {
                    row = sheet.createRow(i + 1);
                }
                if (null == (rowData = data2.get(i))) continue;
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)data2.get(i)));
                for (int j = 0; j < keyList.size(); ++j) {
                    cell = row.getCell(j);
                    if (null == cell) {
                        cell = row.createCell(j);
                    }
                    ExcelUtil.setValue(cell, jsonObject.getString(keyList.get(j)));
                    cell.setCellStyle(cellStyle);
                    int length = cell.getStringCellValue().getBytes().length * 256 + 512;
                    if (length > 15000) {
                        length = 15000;
                    }
                    maxWidth.put(j, Math.max(length, maxWidth.get(j) == null ? 0 : (Integer)maxWidth.get(j)));
                }
            }
            for (i = 0; i < maxWidth.size(); ++i) {
                sheet.setColumnWidth(i, ((Integer)maxWidth.get(i)).intValue());
            }
        }
    }

    public static void writeDataToWorkbook(JSONArray jsonArray, Workbook book) throws IOException {
        int maxKeyNum = 0;
        if (jsonArray != null && jsonArray.size() > 0) {
            Cell cell;
            Row row;
            int i;
            CellStyle cellStyle = book.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setWrapText(true);
            Sheet sheet = book.createSheet();
            sheet.createRow(0);
            HashMap<Integer, Integer> maxWidth = new HashMap<Integer, Integer>();
            for (i = 0; i < jsonArray.size(); ++i) {
                ArrayList strings;
                JSONObject data2 = (JSONObject)jsonArray.get(i);
                row = sheet.getRow(i + 1);
                if (null == row) {
                    row = sheet.createRow(i + 1);
                }
                if ((strings = new ArrayList(data2.keySet())).size() > maxKeyNum) {
                    maxKeyNum = strings.size();
                }
                for (int j = 0; j < strings.size(); ++j) {
                    cell = row.getCell(j);
                    if (null == cell) {
                        cell = row.createCell(j);
                    }
                    ExcelUtil.setValue(cell, data2.get(strings.get(j)));
                    cell.setCellStyle(cellStyle);
                    int length = cell.getStringCellValue().getBytes().length * 256 + 512;
                    if (length > 15000) {
                        length = 15000;
                    }
                    maxWidth.put(j, Math.max(length, maxWidth.get(j) == null ? 0 : (Integer)maxWidth.get(j)));
                }
            }
            for (i = 0; i < maxWidth.size(); ++i) {
                sheet.setColumnWidth(i, ((Integer)maxWidth.get(i)).intValue());
            }
            if (maxKeyNum > 0) {
                int i2;
                HashMap<Integer, Integer> maxWidth1 = new HashMap<Integer, Integer>();
                int j = 1;
                CellStyle cellStyle1 = book.createCellStyle();
                cellStyle1.setBorderBottom(BorderStyle.THIN);
                cellStyle1.setBorderLeft(BorderStyle.THIN);
                cellStyle1.setBorderTop(BorderStyle.THIN);
                cellStyle1.setBorderRight(BorderStyle.THIN);
                cellStyle1.setAlignment(HorizontalAlignment.CENTER);
                cellStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
                cellStyle1.setWrapText(true);
                cellStyle1.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
                cellStyle1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                ArrayList<String> chnList = new ArrayList<String>(Arrays.asList("\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"));
                row = sheet.getRow(0);
                if (null == row) {
                    row = sheet.createRow(0);
                }
                for (i2 = 1; i2 <= maxKeyNum; i2 += 2) {
                    Cell cell1;
                    cell = row.getCell(i2 - 1);
                    if (cell == null) {
                        cell = row.createCell(i2 - 1);
                    }
                    if ((cell1 = row.createCell(i2)) == null) {
                        cell1 = row.createCell(i2);
                    }
                    ExcelUtil.setValue(cell, (String)chnList.get(j - 1) + "\u7ea7\u5206\u7c7bid");
                    cell.setCellStyle(cellStyle1);
                    int length = cell.getStringCellValue().getBytes().length * 256 + 512;
                    if (length > 15000) {
                        length = 15000;
                    }
                    maxWidth1.put(i2 - 1, Math.max(length, maxWidth1.get(i2 - 1) == null ? 0 : (Integer)maxWidth1.get(i2 - 1)));
                    ExcelUtil.setValue(cell1, (String)chnList.get(j - 1) + "\u7ea7\u5206\u7c7b\u540d\u79f0");
                    cell1.setCellStyle(cellStyle1);
                    int length1 = cell1.getStringCellValue().getBytes().length * 256 + 512;
                    if (length1 > 15000) {
                        length1 = 15000;
                    }
                    maxWidth1.put(i2, Math.max(length1, maxWidth1.get(i2) == null ? 0 : (Integer)maxWidth1.get(i2)));
                    ++j;
                }
                for (i2 = 0; i2 < maxWidth1.size(); ++i2) {
                    sheet.setColumnWidth(i2, ((Integer)maxWidth1.get(i2)).intValue());
                }
            }
        }
    }

    public static List<List<Object>> readExcelFirstSheet(String pathname) throws IOException {
        File file = new File(pathname);
        return ExcelUtil.readExcelFirstSheet(file);
    }

    public static List<List<Object>> readExcelFirstSheet(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            if (file.getName().endsWith(XLS)) {
                List<List<Object>> list = ExcelUtil.readXlsFirstSheet(inputStream);
                return list;
            }
            if (file.getName().endsWith(XLSX)) {
                List<List<Object>> list = ExcelUtil.readXlsxFirstSheet(inputStream);
                return list;
            }
            throw new IOException("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
        }
    }

    public static List<List<Object>> readXlsFirstSheet(InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(inputStream);
        return ExcelUtil.readExcelFirstSheet((Workbook)workbook);
    }

    public static List<List<Object>> readXlsxFirstSheet(InputStream inputStream) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        return ExcelUtil.readExcelFirstSheet((Workbook)workbook);
    }

    public static List<List<Object>> readExcelFirstSheet(Workbook book) {
        return ExcelUtil.readExcel(book, 0);
    }

    public static List<List<Object>> readExcel(Workbook book, int page) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        Sheet sheet = book.getSheetAt(page);
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (null == row) continue;
            ArrayList<Object> columns = new ArrayList<Object>();
            for (int j = 0; j < sheet.getRow(0).getLastCellNum(); ++j) {
                Cell cell = row.getCell(j);
                columns.add(ExcelUtil.getValue(cell));
            }
            list.add(columns);
        }
        return list;
    }

    private static Object getValue(Cell cell) {
        if (null == cell) {
            return null;
        }
        String value = null;
        switch (cell.getCellType()) {
            default: 
        }
        value = cell.toString();
        return value;
    }

    private static void setValue(Cell cell, Object value) {
        if (null == cell) {
            return;
        }
        cell.setCellType(CellType.STRING);
        if (null == value) {
            cell.setCellValue((String)null);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Date) {
            cell.setCellValue(FORMAT.format((Date)value));
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else {
            cell.setCellValue(value.toString());
        }
    }
}

