/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.onecode.onecode.common.bo.utils;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class UnitConversion {
    public static BigDecimal conversion(BigDecimal value, UnitsEnum original, UnitsEnum need, int scale) {
        if (original == UnitsEnum.UN_KNOWN || need == UnitsEnum.UN_KNOWN) {
            throw new IllegalArgumentException("\u5b58\u5728\u4e0d\u652f\u6301\u7684\u5355\u4f4d\u53c2\u6570");
        }
        if (original.category != need.category) {
            throw new IllegalArgumentException("\u8f6c\u6362\u5355\u4f4d\u4e0d\u7edf\u4e00!" + original.category.name + "\u4e0d\u80fd\u8f6c\u6362\u4e3a" + need.category.name);
        }
        return value == null ? new BigDecimal(0) : value.multiply(need.rate).divide(original.rate, scale, 4);
    }

    public static BigDecimal conversion(BigDecimal value, String original, String need, int scale) {
        return UnitConversion.conversion(value, UnitConversion.getUnitEnum(original), UnitConversion.getUnitEnum(need), scale);
    }

    public static void main(String[] args) {
        System.out.println(UnitConversion.conversion(new BigDecimal("100"), "mm", "cm", 0));
    }

    public static UnitsEnum getUnitEnum(String unit) {
        if (StringUtils.isNotEmpty((CharSequence)unit)) {
            for (UnitsEnum unitEnum : UnitsEnum.values()) {
                for (String possibleName : unitEnum.possibleNames) {
                    if (!possibleName.equals(unit.toLowerCase())) continue;
                    return unitEnum;
                }
            }
        }
        return UnitsEnum.UN_KNOWN;
    }

    public static enum UnitsEnum {
        LG_KM(CategoryEnum.LENGTH, "km", new String[]{"km", "\u5343\u7c73"}, new BigDecimal("0.001"), "\u5343\u7c73"),
        LG_M(CategoryEnum.LENGTH, "m", new String[]{"m", "\u7c73"}, new BigDecimal("1"), "\u7c73"),
        LG_Dm(CategoryEnum.LENGTH, "dm", new String[]{"dm", "\u5206\u7c73"}, new BigDecimal("10"), "\u5206\u7c73"),
        LG_CM(CategoryEnum.LENGTH, "cm", new String[]{"cm", "\u5398\u7c73", "\u516c\u5206"}, new BigDecimal("100"), "\u5398\u7c73"),
        LG_MM(CategoryEnum.LENGTH, "mm", new String[]{"mm", "\u6beb\u7c73"}, new BigDecimal("1000"), "\u6beb\u7c73"),
        LG_UM(CategoryEnum.LENGTH, "um", new String[]{"um", "\u5fae\u7c73"}, new BigDecimal("1000000"), "\u5fae\u7c73"),
        LG_NM(CategoryEnum.LENGTH, "nm", new String[]{"nm", "\u7eb3\u7c73"}, new BigDecimal("1000000000"), "\u7eb3\u7c73"),
        LG_INCH(CategoryEnum.LENGTH, "inch", new String[]{"in", "inch", "\u82f1\u5bf8"}, new BigDecimal("39.3700787"), "\u82f1\u5bf8"),
        EG_T(CategoryEnum.WEIGHT, "t", new String[]{"t", "\u5428"}, new BigDecimal("0.001"), "\u5428"),
        EG_KG(CategoryEnum.WEIGHT, "kg", new String[]{"kg", "\u5343\u514b", "\u516c\u65a4"}, new BigDecimal("1"), "\u5343\u514b"),
        EG_JIN(CategoryEnum.WEIGHT, "\u65a4", new String[]{"\u65a4"}, new BigDecimal("2"), "\u65a4"),
        EG_G(CategoryEnum.WEIGHT, "g", new String[]{"g", "\u514b"}, new BigDecimal("1000"), "\u514b"),
        EG_MG(CategoryEnum.WEIGHT, "mg", new String[]{"mg", "\u6beb\u514b"}, new BigDecimal("1000000"), "\u6beb\u514b"),
        EG_UG(CategoryEnum.WEIGHT, "\u03bcg", new String[]{"\u03bcg", "ug", "\u5fae\u514b"}, new BigDecimal("1000000000"), "\u5fae\u514b"),
        EG_LB(CategoryEnum.WEIGHT, "lb", new String[]{"lb", "lbs", "\u78c5"}, new BigDecimal("2.2046226"), "\u78c5"),
        EG_OZ(CategoryEnum.WEIGHT, "oz", new String[]{"oz", "\u76ce\u53f8"}, new BigDecimal("35.2739619"), "\u76ce\u53f8"),
        EG_CT(CategoryEnum.WEIGHT, "ct", new String[]{"ct", "\u514b\u62c9"}, new BigDecimal("5000"), "\u514b\u62c9"),
        V_L(CategoryEnum.WEIGHT, "l", new String[]{"l", "\u5347"}, new BigDecimal("1"), "\u5347"),
        V_ML(CategoryEnum.WEIGHT, "ml", new String[]{"ml", "\u6beb\u5347"}, new BigDecimal("1000"), "\u6beb\u5347"),
        UN_KNOWN(null, "\u672a\u77e5", new String[0], null, "\u672a\u77e5");

        private CategoryEnum category;
        private String units;
        private String[] possibleNames;
        private BigDecimal rate;
        private String description;

        private UnitsEnum(CategoryEnum category, String units, String[] possibleNames, BigDecimal rate, String description) {
            this.category = category;
            this.units = units;
            this.possibleNames = possibleNames;
            this.rate = rate;
            this.description = description;
        }

        public CategoryEnum getCategory() {
            return this.category;
        }

        public String getUnits() {
            return this.units;
        }

        public String[] getPossibleNames() {
            return this.possibleNames;
        }

        public BigDecimal getRate() {
            return this.rate;
        }

        public String getDescription() {
            return this.description;
        }

        private static enum CategoryEnum {
            LENGTH("length", LG_M, "\u957f\u5ea6"),
            WEIGHT("weight", EG_KG, "\u91cd\u91cf"),
            VOLUME("volume", V_L, "\u5bb9\u79ef");

            private String name;
            private UnitsEnum base;
            private String description;

            private CategoryEnum(String name, UnitsEnum base, String description) {
                this.name = name;
                this.base = base;
                this.description = description;
            }

            public String getName() {
                return this.name;
            }

            public UnitsEnum getBase() {
                return this.base;
            }

            public String getDescription() {
                return this.description;
            }
        }
    }
}

