/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform;

import com.asiainfo.openplatform.isb.http.HttpRequestHelper;
import com.asiainfo.openplatform.isb.https.HttpsRequestHelper;
import com.asiainfo.openplatform.isb.remote.RemoteRequestHelper;
import com.asiainfo.openplatform.isb.socket.SocketRequestHelper;
import com.asiainfo.openplatform.isb.ws.WsRequestHelper;
import com.asiainfo.openplatform.utils.AIESBConfig;
import com.asiainfo.openplatform.utils.AppkeyUtil;
import com.asiainfo.openplatform.utils.ParseUtil;
import com.asiainfo.openplatform.utils.SignUtil;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AIESBClient {
    private static transient Log log = LogFactory.getLog(AIESBClient.class);

    public static String execute(Map<String, String> sysParams, String busiParams, String protocol) throws Exception {
        return AIESBClient.execute(sysParams, busiParams, protocol, 0);
    }

    private static String execute(Map<String, String> sysParams, String busiParams, String protocol, int retryNum) throws Exception {
        String respCode;
        String appKey = AppkeyUtil.getAppkey();
        String sign = SignUtil.generateSign(sysParams, busiParams);
        sysParams.put("sign", sign);
        String response = null;
        if ("http".equalsIgnoreCase(protocol)) {
            response = HttpRequestHelper.request(sysParams, busiParams);
        } else if ("https".equalsIgnoreCase(protocol)) {
            response = HttpsRequestHelper.request(sysParams, busiParams);
        } else if ("webservice".equalsIgnoreCase(protocol)) {
            response = WsRequestHelper.request(sysParams, busiParams);
        } else if ("remote".equalsIgnoreCase(protocol)) {
            response = RemoteRequestHelper.request(sysParams, busiParams);
        } else if ("socket".equalsIgnoreCase(protocol)) {
            response = SocketRequestHelper.request(sysParams, busiParams);
        } else {
            throw new Exception("\u6682\u4e0d\u652f\u6301\u6b64\u534f\u8bae\uff01");
        }
        if (StringUtils.isNotBlank((String)response) && "20221".equals(respCode = ParseUtil.parseRespCode(response, sysParams.get("format"))) && "SHA".equals(AIESBConfig.getSignMethod()) && retryNum < 3) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SHA\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e14\u91cd\u8bd5\u6b21\u6570\u672a\u8fbe\u52303\u6b21\uff08\u5f53\u524d" + retryNum + "\u6b21\uff09\uff0c\u83b7\u53d6\u6700\u65b0\u7684appkey\u91cd\u65b0\u53d1\u8d77\u8c03\u7528\uff01"));
            }
            AppkeyUtil.syncAppkey(appKey);
            return AIESBClient.execute(sysParams, busiParams, protocol, retryNum + 1);
        }
        return response;
    }
}

