/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.isb.http;

import com.asiainfo.openplatform.utils.AIESBConfig;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpRequestHelper {
    private static transient Log log = LogFactory.getLog(HttpRequestHelper.class);
    private static HttpClient httpClient = null;

    static {
        httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(Integer.valueOf(AIESBConfig.getHttpConnectTimeout()).intValue());
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(Integer.valueOf(AIESBConfig.getHttpReadTimeout()).intValue());
    }

    public static String request(Map<String, String> sysParams, String busiParams) throws Exception {
        String httpUrl = AIESBConfig.getHttpConnectUrl();
        log.error((Object)("httpUrl:" + httpUrl));
        StringBuilder urlBuf = new StringBuilder(httpUrl).append("?");
        String[] paramKeys = sysParams.keySet().toArray(new String[sysParams.size()]);
        int i = 0;
        while (i < paramKeys.length) {
            urlBuf.append(paramKeys[i]).append("=").append(URLEncoder.encode(sysParams.get(paramKeys[i]), "UTF-8"));
            if (i != paramKeys.length - 1) {
                urlBuf.append("&");
            }
            ++i;
        }
        PostMethod postMethod = new PostMethod(urlBuf.toString());
        StringRequestEntity entity = null;
        String response = null;
        try {
            String format = sysParams.get("format");
            if ("json".equalsIgnoreCase(format)) {
                postMethod.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                entity = new StringRequestEntity(busiParams, "application/json", "UTF-8");
            } else if ("xml".equalsIgnoreCase(format)) {
                postMethod.setRequestHeader("Content-type", "text/xml; charset=UTF-8");
                entity = new StringRequestEntity(busiParams, "text/xml", "UTF-8");
            }
            postMethod.setRequestEntity(entity);
            httpClient.executeMethod((HttpMethod)postMethod);
            byte[] result = postMethod.getResponseBody();
            response = new String(result, "UTF-8");
        }
        finally {
            postMethod.releaseConnection();
        }
        return response;
    }
}

