/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.isb.https;

import com.asiainfo.openplatform.isb.https.DefaultX509TrustManager;
import com.asiainfo.openplatform.utils.AIESBConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;

public class HttpsRequestHelper {
    private static final String REQUEST_METHOD = "POST";
    private static final HostnameVerifier hostnameVerifier = new TrustAnyHostnameVerifier();

    public static String request(Map<String, String> sysParams, String busiParams) {
        StringBuffer buffer = new StringBuffer();
        HttpURLConnection httpUrlConn = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            TrustManager[] tm = new TrustManager[]{new DefaultX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            StringBuilder urlBuff = new StringBuilder();
            urlBuff.append(AIESBConfig.getHttpsConnectUrl()).append("?");
            String[] paramKeys = sysParams.keySet().toArray(new String[sysParams.size()]);
            int i = 0;
            while (i < paramKeys.length) {
                urlBuff.append(paramKeys[i]).append("=").append(URLEncoder.encode(sysParams.get(paramKeys[i]), "UTF-8"));
                if (i != paramKeys.length - 1) {
                    urlBuff.append("&");
                }
                ++i;
            }
            URL url = new URL(urlBuff.toString());
            httpUrlConn = (HttpsURLConnection)url.openConnection();
            ((HttpsURLConnection)httpUrlConn).setSSLSocketFactory(ssf);
            ((HttpsURLConnection)httpUrlConn).setHostnameVerifier(hostnameVerifier);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setConnectTimeout(Integer.valueOf(AIESBConfig.getHttpsConnectTimeout()));
            httpUrlConn.setReadTimeout(Integer.valueOf(AIESBConfig.getHttpsReadTimeout()));
            httpUrlConn.setRequestMethod(REQUEST_METHOD);
            if (StringUtils.isNotBlank((String)busiParams)) {
                outputStream = httpUrlConn.getOutputStream();
                outputStream.write(busiParams.getBytes("UTF-8"));
                outputStream.close();
            }
            inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            String string = buffer.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpUrlConn != null) {
                httpUrlConn.disconnect();
            }
        }
        return null;
    }

    static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

