/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.isb.socket;

import com.asiainfo.openplatform.isb.socket.SyncSocketProxyFactory;
import com.asiainfo.openplatform.isb.socket.pool.CommonSocketPool;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class SocketConnectionManager {
    private static final String SOCKET_START = "socket://";
    private static final String SOCKET_SPLIT = "?";
    private static final String SOCKET_IP_PORT_SPLIT = ":";
    private static final String SOCKET_PARAM_SPLIT = "&";
    private static final String SOCKET_KV_SPLIT = "=";
    private static ConcurrentHashMap<String, SyncSocketProxyFactory> factoryMap = new ConcurrentHashMap();

    private static SyncSocketProxyFactory getFactory(String connCode, String connUrl) throws Exception {
        SyncSocketProxyFactory factory = factoryMap.get(connCode);
        if (factory == null) {
            SyncSocketProxyFactory fa = null;
            fa = SocketConnectionManager.getNewFactory(connCode, connUrl);
            factory = factoryMap.putIfAbsent(connCode, fa);
            if (factory == null) {
                factory = fa;
            }
        }
        return factory;
    }

    public static Socket getConnection(String connCode, String connUrl) throws Exception {
        if (connUrl == null) {
            throw new Exception("socket \u8fde\u63a5 URL[" + connUrl + "]\u51fa\u9519!");
        }
        SyncSocketProxyFactory factory = SocketConnectionManager.getFactory(connCode, connUrl);
        return factory.getSocket();
    }

    public static void destroySocket(String connCode, String connUrl, Socket socket) throws Exception {
        SyncSocketProxyFactory factory = SocketConnectionManager.getFactory(connCode, connUrl);
        factory.destroySocket(socket);
    }

    private static SyncSocketProxyFactory getNewFactory(String connCode, String connUr) throws Exception {
        if (connUr == null) {
            throw new Exception("socket \u8fde\u63a5 URL[" + connUr + "]\u51fa\u9519!");
        }
        String param = StringUtils.substringAfter((String)connUr, (String)SOCKET_SPLIT);
        String[] params = StringUtils.split((String)param, (String)SOCKET_PARAM_SPLIT);
        String ipPort = StringUtils.substringBetween((String)connUr, (String)SOCKET_START, (String)SOCKET_SPLIT);
        String[] ipPorts = StringUtils.split((String)ipPort, (String)SOCKET_IP_PORT_SPLIT);
        String host = ipPorts[0];
        String port = ipPorts[1];
        boolean isKeepAlive = false;
        CommonSocketPool pool = null;
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        SyncSocketProxyFactory factory = new SyncSocketProxyFactory();
        factory.setHost(host);
        factory.setPort(Integer.parseInt(port));
        int i = 0;
        while (i < params.length) {
            String[] paramis = StringUtils.split((String)params[i], (String)SOCKET_KV_SPLIT);
            if ("connectTimeout".equals(paramis[0])) {
                factory.setConnectTimeout(Integer.parseInt(paramis[1]));
            } else if ("tcpNoDelay".equals(paramis[0])) {
                factory.setTcpNoDelay(Boolean.parseBoolean(paramis[1]));
            } else if ("reuseAddress".equals(paramis[0])) {
                factory.setReuseAddress(Boolean.parseBoolean(paramis[1]));
            } else if ("soLinger".equals(paramis[0])) {
                factory.setSoLinger(Integer.parseInt(paramis[1]));
            } else if ("sendBufferSize".equals(paramis[0])) {
                factory.setSendBufferSize(Integer.parseInt(paramis[1]));
            } else if ("receiveBufferSize".equals(paramis[0])) {
                factory.setReceiveBufferSize(Integer.parseInt(paramis[1]));
            } else if ("readTimeout".equals(paramis[0])) {
                factory.setReadTimeout(Integer.parseInt(paramis[1]));
            } else if ("keepAlive".equals(paramis[0])) {
                isKeepAlive = Boolean.parseBoolean(paramis[1]);
            } else if ("maxActive".equals(paramis[0])) {
                config.maxActive = Integer.parseInt(paramis[1]);
            } else if ("maxIdle".equals(paramis[0])) {
                config.maxIdle = Integer.parseInt(paramis[1]);
            } else if ("maxWait".equals(paramis[0])) {
                config.maxWait = Integer.parseInt(paramis[1]);
            } else if ("testOnBorrow ".equals(paramis[0])) {
                config.testOnBorrow = Boolean.parseBoolean(paramis[1]);
            } else if ("minIdle ".equals(paramis[0])) {
                config.minIdle = Integer.parseInt(paramis[1]);
            }
            ++i;
        }
        if (isKeepAlive) {
            pool = new CommonSocketPool(factory, config);
            factory.setSocketPool(pool);
        }
        return factory;
    }

    public static void main(String[] args) throws Exception {
        String url = "socket://183.56.147.1:80?connectTimeout=3000&tcpNoDelay=false&reuseAddress=false&keepAlive=true&maxActive=20&maxIdle=2&maxWait=3000&testOnBorrow=true";
        Socket s = SocketConnectionManager.getConnection("test", url);
        OutputStream os = s.getOutputStream();
        os.write(new byte[]{127, 127, 127, 127, 127});
        SocketConnectionManager.destroySocket("test", url, s);
        System.out.println();
    }
}

