/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.isb.socket;

import com.asiainfo.openplatform.isb.socket.SocketConnectionManager;
import com.asiainfo.openplatform.utils.AIESBConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Map;

public class SocketRequestHelper {
    private static final String CONN_CODE = "AIESB_SOCKET";

    public static String request(Map<String, String> sysParams, String busiParams) throws Exception {
        String socketUrl = AIESBConfig.getSocketConnectUrl();
        Socket socket = SocketConnectionManager.getConnection(CONN_CODE, socketUrl);
        OutputStream out = socket.getOutputStream();
        InputStream in = socket.getInputStream();
        String response = null;
        try {
            try {
                String params = SocketRequestHelper.transferParamsToString(sysParams, busiParams);
                byte[] data = params.getBytes("UTF-8");
                byte[] headBytes = SocketRequestHelper.int2Bytes(data.length + 12);
                byte[] bytes = new byte[data.length + 12];
                System.arraycopy(headBytes, 0, bytes, 0, 4);
                System.arraycopy(data, 0, bytes, 12, data.length);
                out.write(bytes);
                out.flush();
                byte[] headData = new byte[12];
                int length2 = 0;
                if (in.read(headData, 0, headData.length) == -1) {
                    throw new RuntimeException();
                }
                ByteBuffer headBuffer = ByteBuffer.wrap(headData);
                length2 = headBuffer.getInt() - 12;
                int offsize = 0;
                byte[] retData = new byte[length2];
                while (offsize < length2) {
                    int len = in.read(headData, 0, headData.length);
                    if (len <= 0) break;
                    System.arraycopy(headData, 0, retData, offsize, len);
                    offsize += len;
                }
                response = new String(retData, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                SocketConnectionManager.destroySocket(CONN_CODE, socketUrl, socket);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            SocketConnectionManager.destroySocket(CONN_CODE, socketUrl, socket);
        }
        return response;
    }

    private static String transferParamsToString(Map<String, String> sysParams, String busiParams) {
        StringBuilder buff = new StringBuilder();
        for (String key : sysParams.keySet()) {
            buff.append(key).append("=").append(sysParams.get(key)).append("&");
        }
        buff.append("content").append("=").append(busiParams);
        return buff.toString();
    }

    private static byte[] int2Bytes(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        buffer.flip();
        return buffer.array();
    }
}

