/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.isb.socket;

import com.asiainfo.openplatform.isb.socket.pool.SocketPool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SyncSocketProxyFactory {
    private String host;
    private int port;
    private int connectTimeout = 10;
    private boolean tcpNoDelay = true;
    private boolean reuseAddress = true;
    private int soLinger = -1;
    private int sendBufferSize = 256;
    private int receiveBufferSize = 1024;
    private int readTimeout = 20;
    private boolean connectionKeepAlive = false;
    private SocketPool socketPool;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSocketPool(SocketPool socketPool) {
        this.socketPool = socketPool;
        this.connectionKeepAlive = true;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public Socket getSocket() throws Exception {
        if (this.connectionKeepAlive) {
            return this.socketPool.getSocket(this.host, this.port);
        }
        return this.createSocket(this.host, this.port);
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket conn = new Socket();
        conn.setSoTimeout(this.getReadTimeout() * 1000);
        conn.setTcpNoDelay(this.isTcpNoDelay());
        conn.setReuseAddress(this.isReuseAddress());
        conn.setSoLinger(this.getSoLinger() > 0, this.getSoLinger());
        conn.setSendBufferSize(this.getSendBufferSize());
        conn.setReceiveBufferSize(this.getReceiveBufferSize());
        conn.connect(new InetSocketAddress(host, port), this.getConnectTimeout() * 1000);
        return conn;
    }

    public void destroySocket(Socket socket) throws Exception {
        if (this.connectionKeepAlive) {
            this.socketPool.returnSocket(this.host, this.port, socket);
        } else {
            socket.close();
        }
    }
}

