/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.sign;

import com.asiainfo.openplatform.sign.ISignEngine;
import com.asiainfo.openplatform.sign.impl.RSASignEngineImpl;
import com.asiainfo.openplatform.sign.impl.SHASignEngineImpl;
import com.asiainfo.openplatform.utils.AIESBConfig;
import java.util.HashMap;
import java.util.Map;

public class SignEngineFactory {
    private static Map<String, ISignEngine> signEngineMap = new HashMap<String, ISignEngine>();

    public static ISignEngine getSignEngine() {
        String signMethod = AIESBConfig.getSignMethod();
        ISignEngine signEngine = signEngineMap.get(signMethod);
        if (signEngine != null) {
            return signEngine;
        }
        if ("RSA".equalsIgnoreCase(signMethod)) {
            signEngine = RSASignEngineImpl.getSingleton();
        } else if ("SHA".equalsIgnoreCase(signMethod)) {
            signEngine = SHASignEngineImpl.getSingleton();
        }
        signEngineMap.put(signMethod, signEngine);
        return signEngine;
    }
}

