/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.sign.impl;

import com.asiainfo.openplatform.sign.ISignEngine;
import com.asiainfo.openplatform.utils.AIESBConfig;
import com.asiainfo.openplatform.utils.MD5Util;
import com.asiainfo.openplatform.utils.RSAUtils;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RSASignEngineImpl
implements ISignEngine {
    private static RSASignEngineImpl instance;

    private RSASignEngineImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RSASignEngineImpl getSingleton() {
        if (instance != null) return instance;
        Class<RSASignEngineImpl> clazz = RSASignEngineImpl.class;
        synchronized (RSASignEngineImpl.class) {
            if (instance != null) return instance;
            instance = new RSASignEngineImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String generateSign(Map<String, String> paramsMap) throws Exception {
        String signSecret = AIESBConfig.getRsaPublicKey();
        String md5Str = RSASignEngineImpl.getMD5Str(paramsMap);
        return RSAUtils.encryptByPublicKey(md5Str, signSecret);
    }

    private static String getMD5Str(Map<String, String> paramMap) throws Exception {
        Object[] paramArr = paramMap.keySet().toArray(new String[paramMap.size()]);
        Arrays.sort(paramArr);
        StringBuilder keyBuf = new StringBuilder();
        StringBuilder buf = new StringBuilder();
        Object[] objectArray = paramArr;
        int n = paramArr.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            Object param = objectArray[n2];
            if (!"sign".equals(param) && StringUtils.isNotBlank((String)(value = paramMap.get(((String)param).trim())))) {
                keyBuf.append((String)param).append("|");
                buf.append(value.trim());
            }
            ++n2;
        }
        String md5Str = "";
        if (buf.length() > 0) {
            md5Str = MD5Util.MD5(buf.toString());
        }
        return md5Str;
    }
}

