/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.sign.impl;

import com.asiainfo.openplatform.sign.ISignEngine;
import com.asiainfo.openplatform.utils.AppkeyUtil;
import com.asiainfo.openplatform.utils.SecurityUtils;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SHASignEngineImpl
implements ISignEngine {
    private static SHASignEngineImpl instance;

    private SHASignEngineImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SHASignEngineImpl getSingleton() {
        if (instance != null) return instance;
        Class<SHASignEngineImpl> clazz = SHASignEngineImpl.class;
        synchronized (SHASignEngineImpl.class) {
            if (instance != null) return instance;
            instance = new SHASignEngineImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String generateSign(Map<String, String> paramsMap) throws Exception {
        String appKey = AppkeyUtil.getAppkey();
        Object[] paramArr = paramsMap.keySet().toArray(new String[paramsMap.size()]);
        Arrays.sort(paramArr);
        StringBuilder keyBuf = new StringBuilder();
        StringBuilder buf = new StringBuilder();
        buf.append(appKey);
        Object[] objectArray = paramArr;
        int n = paramArr.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            Object param = objectArray[n2];
            if (!"sign".equals(param) && StringUtils.isNotBlank((String)(value = paramsMap.get(((String)param).trim())))) {
                keyBuf.append((String)param).append("|");
                buf.append((String)param).append(value.trim());
            }
            ++n2;
        }
        buf.append(appKey);
        String signStr = "";
        if (buf.length() > 0) {
            signStr = SecurityUtils.encodeHmacSHA256HexUpper(buf.toString(), SecurityUtils.decodeHexUpper(appKey));
        }
        return signStr;
    }
}

