/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.utils;

import java.io.IOException;
import java.util.Properties;

public class AIESBConfig {
    private static Properties props = new Properties();

    static {
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("aiesb.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getValue(String key) {
        return props.getProperty(key);
    }

    public static String getProtocol() {
        return props.getProperty("request_protocol");
    }

    public static String getSignMethod() {
        return props.getProperty("sign_method");
    }

    public static String getAppKey() {
        return props.getProperty("app_key");
    }

    public static String getRsaPublicKey() {
        return props.getProperty("rsa_publickey");
    }

    public static String getHttpConnectUrl() {
        return props.getProperty("http_connect_url");
    }

    public static String getHttpsConnectUrl() {
        return props.getProperty("https_connect_url");
    }

    public static String getSocketConnectUrl() {
        return props.getProperty("socket_connect_url");
    }

    public static String getRemoteConnectUrl() {
        return props.getProperty("remote_connect_url");
    }

    public static String getWsConnectUrl() {
        return props.getProperty("ws_connect_url");
    }

    public static String getRespCodeKey() {
        return props.getProperty("resp_code_key");
    }

    public static String getAppkeyUrl() {
        return props.getProperty("appkey_url");
    }

    public static String getAppId() {
        return props.getProperty("app_id");
    }

    public static String getHttpsConnectTimeout() {
        return props.getProperty("https_connect_timeout", "10000");
    }

    public static String getHttpsReadTimeout() {
        return props.getProperty("https_read_timeout", "10000");
    }

    public static String getHttpConnectTimeout() {
        return props.getProperty("http_connect_timeout", "3000");
    }

    public static String getHttpReadTimeout() {
        return props.getProperty("http_read_timeout", "3000");
    }

    public static String getWsConnectTimeout() {
        return props.getProperty("ws_connect_timeout", "10000");
    }

    public static void main(String[] args) {
        System.out.println(AIESBConfig.getValue("http_connect_url"));
    }
}

