/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.utils;

import com.asiainfo.openplatform.utils.AIESBConfig;
import com.asiainfo.openplatform.utils.RSAUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppkeyUtil {
    private static transient Log log = LogFactory.getLog(AppkeyUtil.class);
    private static String appkey = null;

    static {
        AppkeyUtil.initAppkey();
    }

    private static void initAppkey() {
        HttpClient httpClient = new HttpClient();
        String url = String.valueOf(AIESBConfig.getAppkeyUrl()) + AIESBConfig.getAppId();
        GetMethod method = new GetMethod(url);
        try {
            try {
                String s;
                httpClient.executeMethod((HttpMethod)method);
                if (200 == method.getStatusCode() && StringUtils.isNotBlank((String)(s = new String(method.getResponseBody(), "UTF-8")))) {
                    appkey = RSAUtils.decryptByPublicKey(s, AIESBConfig.getRsaPublicKey());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u83b7\u53d6\u5230\u6700\u65b0\u7684app_key\uff1a" + appkey));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                method.releaseConnection();
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public static String getAppkey() {
        if (appkey == null) {
            AppkeyUtil.initAppkey();
        }
        return appkey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void syncAppkey(String oldAppkey) {
        if (oldAppkey != appkey) return;
        Class<AppkeyUtil> clazz = AppkeyUtil.class;
        synchronized (AppkeyUtil.class) {
            if (oldAppkey != appkey) return;
            AppkeyUtil.initAppkey();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

