/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.utils;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SecurityUtils {
    public static final String ENCODE = "UTF-8";
    public static final String CIPHER_ALGORITHM = "AES/ECB/PKCS7Padding";

    private SecurityUtils() {
    }

    public static byte[] initAES256Key() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    public static byte[] initHmacSHA256Key() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("HmacSHA256");
        keyGenerator.init(256);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    public static byte[] encodeHmacSHA256(byte[] data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA256");
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        return mac.doFinal(data);
    }

    public static String encodeHmacSHA256HexUpper(String data, byte[] key) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        return SecurityUtils.bytesToHexString(SecurityUtils.encodeHmacSHA256(data.getBytes(ENCODE), key)).toUpperCase(Locale.US);
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, new SecretKeySpec(key, "AES"));
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, new SecretKeySpec(key, "AES"));
        return cipher.doFinal(data);
    }

    public static String encodeHexUpper(byte[] data) throws UnsupportedEncodingException {
        return SecurityUtils.bytesToHexString(data).toUpperCase(Locale.US);
    }

    public static byte[] decodeHexUpper(String str) throws UnsupportedEncodingException {
        return Hex.decode((String)str.toLowerCase(Locale.US));
    }

    public static String decodeHexUpper(String str, String charsetName) throws UnsupportedEncodingException {
        return new String(Hex.decode((String)str.toLowerCase(Locale.US)), charsetName);
    }

    public static String encodeAES256HexUpper(String data, byte[] key) throws UnsupportedEncodingException, IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        return SecurityUtils.encodeHexUpper(SecurityUtils.encrypt(data.getBytes(ENCODE), key));
    }

    public static String decodeAES256HexUpper(String data, byte[] key) throws IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        return new String(SecurityUtils.decrypt(Hex.decode((String)data.toLowerCase(Locale.US)), key), ENCODE);
    }

    public static String bytesToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String s = "130AA05875E3A0644DE1A11B103284B4";
        s = SecurityUtils.decodeAES256HexUpper(s, SecurityUtils.decodeHexUpper("eafbbb3d23b1ec7f0269301dd06fb635"));
        System.out.println(s);
    }
}

