/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.ability.impl.lm.order;

import com.tydic.order.third.intf.ability.lm.order.LmIntfRenderOrderAbilityService;
import com.tydic.order.third.intf.bo.lm.order.OrderSkuReqBO;
import com.tydic.order.third.intf.bo.lm.order.RenderOrderReqBO;
import com.tydic.order.third.intf.bo.lm.order.RenderOrderRspBO;
import com.tydic.order.third.intf.busi.lm.order.LmIntfRenderOrderBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="lmIntfRenderOrderAbilityService")
public class LmIntfRenderOrderAbilityServiceImpl
implements LmIntfRenderOrderAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfRenderOrderAbilityServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private LmIntfRenderOrderBusiService lmIntfRenderOrderBusiService;

    @Autowired
    public LmIntfRenderOrderAbilityServiceImpl(LmIntfRenderOrderBusiService lmIntfRenderOrderBusiService) {
        this.lmIntfRenderOrderBusiService = lmIntfRenderOrderBusiService;
    }

    public RenderOrderRspBO renderOrder(RenderOrderReqBO renderOrderReqBO) {
        this.validateParams(renderOrderReqBO);
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("LinkedMall\u5546\u57ce\u8ba2\u5355\u6e32\u670d\u52a1\u5165\u53c2:" + renderOrderReqBO.toString());
        }
        return this.lmIntfRenderOrderBusiService.renderOrder(renderOrderReqBO);
    }

    private void validateParams(RenderOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u5165\u53c2BO\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getItemList() == null || reqBO.getItemList().isEmpty()) {
            throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u5546\u54c1\u5217\u8868[itemList]\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (OrderSkuReqBO renderOrderSkuReqBO : reqBO.getItemList()) {
            if (renderOrderSkuReqBO.getItemId() == null || renderOrderSkuReqBO.getItemId() == 0L) {
                throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u5546\u54c1\u5217\u8868\u4e2d\u5546\u54c1ID[itemId]\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (renderOrderSkuReqBO.getSkuId() == null || renderOrderSkuReqBO.getSkuId() == 0L) {
                throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u5546\u54c1\u5217\u8868\u4e2dSKUID[skuId]\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (renderOrderSkuReqBO.getQuantity() != null) continue;
            throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u5546\u54c1\u5217\u8868\u4e2d\u8d2d\u4e70\u5546\u54c1\u6570\u91cf[number]\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getDeliveryAddress() == null) {
            throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u6536\u8d27\u5730\u5740[deliveryAddress]\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getDeliveryAddress().getDivisionCode())) {
            throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u6536\u8d27\u5730\u5740\u7684\u8857\u9053\u4e0a\u7ea7\u7f16\u7801[divisionCode]\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getDeliveryAddress().getFullName())) {
            throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u6536\u8d27\u5730\u5740\u7684\u6536\u8d27\u4eba\u59d3\u540d[fullName]\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getDeliveryAddress().getMobile())) {
            throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u6536\u8d27\u5730\u5740\u7684\u6536\u8d27\u4eba\u7535\u8bdd[mobile]\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getDeliveryAddress().getAddressDetail())) {
            throw new BusinessException("7777", "\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u6536\u8d27\u5730\u5740\u7684\u6536\u8d27\u4eba\u5730\u5740[addressDetail]\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

