/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.esb.afs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.esb.afs.ComponentExport;
import com.tydic.order.third.intf.bo.esb.afs.QryWareReturnJdCompReqBO;
import com.tydic.order.third.intf.bo.esb.afs.QryWareReturnJdCompRspBO;
import com.tydic.order.third.intf.busi.esb.afs.PebIntfQryWareReturnJdCompBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.ESBParamUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfQryWareReturnJdCompBusiService")
public class PebIntfQryWareReturnJdCompBusiServiceImpl
implements PebIntfQryWareReturnJdCompBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfQryWareReturnJdCompBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public QryWareReturnJdCompRspBO wareReturnJdComp(QryWareReturnJdCompReqBO qryWareReturnJdCompReqBO) {
        QryWareReturnJdCompRspBO rspBO;
        try {
            String reqStr = this.initPostStr(qryWareReturnJdCompReqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("ESB_WARERETURN_JD_COMP_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528ESB\u83b7\u53d6\u552e\u540e\u8fd4\u56de\u7535\u5546\u65b9\u5f0f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_WARERETURN_JD_COMP_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528ESB\u83b7\u53d6\u552e\u540e\u8fd4\u56de\u7535\u5546\u65b9\u5f0f\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528ESB\u83b7\u53d6\u552e\u540e\u8fd4\u56de\u7535\u5546\u65b9\u5f0f\u63a5\u53e3\u5f02\u5e38" + e);
            throw new BusinessException("6000", "\u8c03\u7528ESB\u83b7\u53d6\u552e\u540e\u8fd4\u56de\u7535\u5546\u65b9\u5f0f\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(QryWareReturnJdCompReqBO qryWareReturnJdCompReqBO) {
        String hsn = PropertiesUtil.getProperty("SUPPLIER_ID_" + qryWareReturnJdCompReqBO.getSupplierId());
        String esbReqParam = ESBParamUtil.getEsbReqParam(qryWareReturnJdCompReqBO, hsn, "BUSINESS_ORDER");
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528ESB\u83b7\u53d6\u552e\u540e\u8fd4\u56de\u7535\u5546\u65b9\u5f0f\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private QryWareReturnJdCompRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u83b7\u53d6\u552e\u540e\u8fd4\u56de\u7535\u5546\u65b9\u5f0fESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        QryWareReturnJdCompRspBO rspBO = new QryWareReturnJdCompRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (((Boolean)rspJsonObject.get((Object)"success")).booleanValue()) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            if (rspJsonObject.get((Object)"result") != null) {
                Object object = rspJsonObject.get((Object)"result");
                List parseArray = JSON.parseArray((String)object.toString(), ComponentExport.class);
                rspBO.setResult(parseArray);
            }
        } else {
            rspBO.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
        }
        rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
        return rspBO;
    }
}

