/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.esb.delivery;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.esb.delivery.ArrivalConfirmCheckReqBO;
import com.tydic.order.third.intf.bo.esb.delivery.ArrivalConfirmCheckRspBO;
import com.tydic.order.third.intf.busi.esb.delivery.PebIntfArrivalConfirmCheckBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.ESBParamUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfArrivalConfirmCheckBusiService")
public class PebIntfArrivalConfirmCheckBusiServiceImpl
implements PebIntfArrivalConfirmCheckBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfArrivalConfirmCheckBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public ArrivalConfirmCheckRspBO confirmGoods(ArrivalConfirmCheckReqBO confirmCheckReqBO) {
        ArrivalConfirmCheckRspBO rspBO;
        try {
            String reqStr = this.initPostStr(confirmCheckReqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("ESB_ARRIVAL_ACCEPTANCE_PUSH_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_ARRIVAL_ACCEPTANCE_PUSH_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528ESB\u786e\u8ba4\u6536\u8d27\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528ESB\u5230\u786e\u8ba4\u6536\u8d27\u670d\u52a1\u63a5\u53e3\u5f02\u5e38!" + e);
            throw new BusinessException("6000", "\u8c03\u7528ESB\u786e\u8ba4\u6536\u8d27\u670d\u52a1\u63a5\u53e3\u5f02\u5e38!");
        }
        return rspBO;
    }

    private String initPostStr(ArrivalConfirmCheckReqBO confirmCheckReqBO) {
        String hsn = PropertiesUtil.getProperty("SUPPLIER_ID_" + confirmCheckReqBO.getSupplierId());
        String reqStr = ESBParamUtil.getEsbReqParam(confirmCheckReqBO, hsn, "BUSINESS_ORDER");
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u786e\u8ba4\u6536\u8d27ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + reqStr);
        }
        return reqStr;
    }

    private ArrivalConfirmCheckRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u786e\u8ba4\u6536\u8d27ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        ArrivalConfirmCheckRspBO rspBO = new ArrivalConfirmCheckRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

