/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.esb.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.esb.order.QryCheckRefuseOrderItemRspBO;
import com.tydic.order.third.intf.bo.esb.order.QryCheckRefuseOrderReqBO;
import com.tydic.order.third.intf.bo.esb.order.QryCheckRefuseOrderRspBO;
import com.tydic.order.third.intf.busi.esb.order.PebIntfQryCheckRefuseOrderBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.ESBParamUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pebIntfQryCheckRefuseOrderBusiService")
public class PebIntfQryCheckRefuseOrderBusiServiceImpl
implements PebIntfQryCheckRefuseOrderBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfQryCheckRefuseOrderBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public QryCheckRefuseOrderRspBO qryCheckRefuseOrder(QryCheckRefuseOrderReqBO qryCheckRefuseOrderReq) {
        QryCheckRefuseOrderRspBO qryCheckRefuseOrderRsp = new QryCheckRefuseOrderRspBO();
        try {
            Integer totalPage;
            String hsn = PropertiesUtil.getProperty("SUPPLIER_ID_" + qryCheckRefuseOrderReq.getSupplierId());
            qryCheckRefuseOrderRsp = this.requestData(qryCheckRefuseOrderReq, hsn, 1);
            if (qryCheckRefuseOrderRsp != null && null != (totalPage = qryCheckRefuseOrderRsp.getTotalPage()) && totalPage > 1) {
                List qryCheckRefuseOrderItemList = qryCheckRefuseOrderRsp.getOrders();
                for (int i = 2; i <= totalPage; ++i) {
                    List qryCheckRefuseOrderItemNextList;
                    QryCheckRefuseOrderRspBO qryCheckRefuseOrderNext = this.requestData(qryCheckRefuseOrderReq, hsn, i);
                    if (qryCheckRefuseOrderNext == null || (qryCheckRefuseOrderItemNextList = qryCheckRefuseOrderNext.getOrders()) == null || qryCheckRefuseOrderItemNextList.size() <= 0) continue;
                    for (QryCheckRefuseOrderItemRspBO qryCheckRefuseOrderItemNext : qryCheckRefuseOrderItemNextList) {
                        qryCheckRefuseOrderItemList.add(qryCheckRefuseOrderItemNext);
                    }
                }
                qryCheckRefuseOrderRsp.setOrders(qryCheckRefuseOrderItemList);
            }
        }
        catch (Exception e) {
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u62d2\u6536\u6d88\u606f\u670d\u52a1\u8c03\u7528\u5931\u8d25" + e);
            }
            qryCheckRefuseOrderRsp.setRespCode("8888");
            qryCheckRefuseOrderRsp.setRespDesc("\u8c03\u7528\u5931\u8d25");
            qryCheckRefuseOrderRsp.setSuccess(Boolean.valueOf(false));
        }
        return qryCheckRefuseOrderRsp;
    }

    private QryCheckRefuseOrderRspBO requestData(QryCheckRefuseOrderReqBO qryCheckRefuseOrderReq, String hsn, Integer page) {
        try {
            String returnString;
            qryCheckRefuseOrderReq.setPage(page);
            String reqStr = ESBParamUtil.getEsbReqParam(qryCheckRefuseOrderReq, hsn, "BUSINESS_ORDER");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("ESB_CHECK_REFUSE_ORDER_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.toString().getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u83b7\u53d6\u83b7\u53d6\u62d2\u6536\u6d88\u606f\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "],[http_url=" + PropertiesUtil.getProperty("ESB_CHECK_REFUSE_ORDER_URL") + "]");
            }
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u62d2\u6536\u6d88\u606f\u670d\u52a1\u670d\u52a1\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            }
            if (StringUtils.isEmpty((CharSequence)(returnString = httpRetBean.getStr()))) {
                throw new RuntimeException("\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u62d2\u6536\u6d88\u606f\u670d\u52a1\u4e3a\u7a7a\uff01");
            }
            return this.resolveRsp(returnString);
        }
        catch (Exception e) {
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u62d2\u6536\u6d88\u606f\u670d\u52a1\u8c03\u7528\u5931\u8d25" + e);
            }
            throw new BusinessException("8888", "\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
        }
    }

    private QryCheckRefuseOrderRspBO resolveRsp(String returnString) {
        QryCheckRefuseOrderRspBO qryCheckRefuseOrderRsp = new QryCheckRefuseOrderRspBO();
        try {
            JSONObject object = JSONObject.parseObject((String)returnString);
            if (null != object) {
                JSONObject result;
                Boolean success = (Boolean)object.get((Object)"success");
                qryCheckRefuseOrderRsp.setSuccess(success);
                if (success.booleanValue() && null != (result = (JSONObject)object.get((Object)"result"))) {
                    JSONArray orders = result.getJSONArray("orders");
                    if (null != orders && orders.size() > 0) {
                        ArrayList<QryCheckRefuseOrderItemRspBO> qryCheckRefuseOrderItemList = new ArrayList<QryCheckRefuseOrderItemRspBO>();
                        for (int i = 0; i < orders.size(); ++i) {
                            JSONObject order = (JSONObject)orders.get(i);
                            if (!order.isEmpty()) {
                                LOGGER.debug("\u5f00\u59cb\u89e3\u6790\u62a5\u6587" + order);
                            }
                            String orderId = order.getString("orderId");
                            if (this.IS_DEBUG_ENABLED) {
                                LOGGER.debug("\u8ba2\u5355\u7f16\u53f7orderId:" + orderId);
                            }
                            Integer state = order.getInteger("state");
                            if (this.IS_DEBUG_ENABLED) {
                                LOGGER.debug("\u8ba2\u5355\u72b6\u6001state:" + state);
                            }
                            Integer hangUpState = order.getInteger("hangUpState");
                            if (this.IS_DEBUG_ENABLED) {
                                LOGGER.debug("\u662f\u5426\u6302\u8d77hangUpState:" + hangUpState);
                            }
                            Integer invoiceState = order.getInteger("invoiceState");
                            if (this.IS_DEBUG_ENABLED) {
                                LOGGER.debug("\u5f00\u7968\u65b9\u5f0finvoiceState:" + invoiceState);
                            }
                            Double orderPrice = order.getDouble("orderPrice");
                            if (this.IS_DEBUG_ENABLED) {
                                LOGGER.debug("\u8ba2\u5355\u91d1\u989dorderPrice:" + orderPrice);
                            }
                            String time = order.getString("time");
                            if (this.IS_DEBUG_ENABLED) {
                                LOGGER.debug("\u65f6\u95f4time:" + time);
                            }
                            QryCheckRefuseOrderItemRspBO qryCheckRefuseOrderItemRsp = new QryCheckRefuseOrderItemRspBO();
                            qryCheckRefuseOrderItemRsp.setOrderId(orderId);
                            qryCheckRefuseOrderItemRsp.setState(state);
                            qryCheckRefuseOrderItemRsp.setHangUpState(hangUpState);
                            qryCheckRefuseOrderItemRsp.setInvoiceState(invoiceState);
                            qryCheckRefuseOrderItemRsp.setOrderPrice(orderPrice);
                            qryCheckRefuseOrderItemList.add(qryCheckRefuseOrderItemRsp);
                        }
                        qryCheckRefuseOrderRsp.setOrders(qryCheckRefuseOrderItemList);
                    } else {
                        success = false;
                    }
                    Long total = result.getLong("total");
                    if (this.IS_DEBUG_ENABLED) {
                        LOGGER.debug("\u8ba2\u5355\u603b\u6570total:" + total);
                    }
                    Integer totalPage = result.getInteger("totalPage");
                    if (this.IS_DEBUG_ENABLED) {
                        LOGGER.debug("\u8ba2\u5355\u603b\u6570totalPage:" + totalPage);
                    }
                    Integer curPage = result.getInteger("curPage");
                    if (this.IS_DEBUG_ENABLED) {
                        LOGGER.debug("\u5f53\u524d\u9875\u7801curPage:" + curPage);
                    }
                    qryCheckRefuseOrderRsp.setTotalNum(total);
                    qryCheckRefuseOrderRsp.setTotalPage(totalPage);
                    qryCheckRefuseOrderRsp.setCurPage(curPage);
                    if (success.booleanValue()) {
                        qryCheckRefuseOrderRsp.setRespCode("0000");
                        qryCheckRefuseOrderRsp.setRespDesc("\u6210\u529f");
                        qryCheckRefuseOrderRsp.setSuccess(Boolean.valueOf(true));
                        return qryCheckRefuseOrderRsp;
                    }
                }
            }
            qryCheckRefuseOrderRsp.setRespCode("8888");
            qryCheckRefuseOrderRsp.setRespDesc("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u6570\u636e");
            qryCheckRefuseOrderRsp.setSuccess(Boolean.valueOf(false));
        }
        catch (Exception e) {
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u62d2\u6536\u6d88\u606f\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
            }
            qryCheckRefuseOrderRsp.setRespCode("8888");
            qryCheckRefuseOrderRsp.setRespDesc("\u8c03\u7528\u5931\u8d25");
            qryCheckRefuseOrderRsp.setSuccess(Boolean.valueOf(false));
        }
        return qryCheckRefuseOrderRsp;
    }
}

