/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.esb.other;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.ohaotian.plugin.common.util.JsonUtils;
import com.tydic.order.third.intf.bo.esb.other.BusiQrySKUYanbaoRspVO;
import com.tydic.order.third.intf.bo.esb.other.QrySkuYanbaoReqBO;
import com.tydic.order.third.intf.bo.esb.other.QrySkuYanbaoRspBO;
import com.tydic.order.third.intf.bo.esb.other.SKUYanbaoRspVO;
import com.tydic.order.third.intf.bo.esb.other.YanBaoDeatilRspVO;
import com.tydic.order.third.intf.busi.esb.other.PebIntfQrySkuYanbaoFromBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.ESBParamUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfQrySkuYanbaoFromBusiService")
public class PebIntfQrySkuYanbaoFromBusiServiceImpl
implements PebIntfQrySkuYanbaoFromBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfQrySkuYanbaoFromBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public QrySkuYanbaoRspBO qrySKUYanbao(QrySkuYanbaoReqBO qrySkuYanbaoReqBO) {
        QrySkuYanbaoRspBO rspBO;
        try {
            String reqStr = this.initPostStr(qrySkuYanbaoReqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_YANBAO_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_YANBAO_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528ESB\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(qrySkuYanbaoReqBO, returnString);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5ef6\u4fdd\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528ESB\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new BusinessException("6000", "\u8c03\u7528ESB\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(QrySkuYanbaoReqBO qrySkuYanbaoReqBO) {
        List extSkuIds = qrySkuYanbaoReqBO.getSkuIds();
        ArrayList<String> reqSkuIds = new ArrayList<String>();
        for (String extSkuId : extSkuIds) {
            reqSkuIds.add('\"' + extSkuId + '\"');
        }
        String reqStr = "{\"skuIds\":" + JSON.toJSONString(reqSkuIds) + ",\"province\":" + qrySkuYanbaoReqBO.getProvince() + ",\"city\":" + qrySkuYanbaoReqBO.getCity() + ",\"county\":" + qrySkuYanbaoReqBO.getCounty() + ",\"town\":" + qrySkuYanbaoReqBO.getTown() + "}";
        String hsn = PropertiesUtil.getProperty("SUPPLIER_ID_" + qrySkuYanbaoReqBO.getSupplierId());
        String esbReqParam = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_ORDER");
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606fESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private QrySkuYanbaoRspBO resolveRsp(QrySkuYanbaoReqBO reqBO, String returnString) {
        LOGGER.debug("\u8c03\u7528\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606fESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        List resultList = (List)jsonObject.get((Object)"result");
        ArrayList resultBusiQrySKUYanbaoRspVOs = new ArrayList();
        QrySkuYanbaoRspBO busiQrySKUYanbaoRspBO = new QrySkuYanbaoRspBO();
        Long supplierId = reqBO.getSupplierId();
        List extSkuIds = reqBO.getSkuIds();
        List notExistYanBaoInfoSkuIds = reqBO.getSkuIds();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && resultList != null && !resultList.isEmpty()) {
            BusiQrySKUYanbaoRspVO[] busiQrySKUYanbaoRspVOArr = (BusiQrySKUYanbaoRspVO[])JsonUtils.jsonStringToJavaBean((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), BusiQrySKUYanbaoRspVO[].class);
            List<BusiQrySKUYanbaoRspVO> busiQrySKUYanbaoRspVOs = Arrays.asList(busiQrySKUYanbaoRspVOArr);
            ArrayList<BusiQrySKUYanbaoRspVO> busiQrySKUYanbaoRsps = new ArrayList<BusiQrySKUYanbaoRspVO>();
            for (BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO : busiQrySKUYanbaoRspVOs) {
                BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRsp = new BusiQrySKUYanbaoRspVO();
                this.calcYanbaoPrice(busiQrySKUYanbaoRspVO.getYanBao(), supplierId);
                busiQrySKUYanbaoRsp.setSkuId(busiQrySKUYanbaoRspVO.getSkuId());
                busiQrySKUYanbaoRsp.setYanBao(busiQrySKUYanbaoRspVO.getYanBao());
                for (String extSkuId : extSkuIds) {
                    if (!extSkuId.equals(busiQrySKUYanbaoRspVO.getSkuId())) continue;
                    busiQrySKUYanbaoRsp.setInnerSkuId((String)reqBO.getExtAndInSkuIdRelation().get(extSkuId));
                }
                busiQrySKUYanbaoRsps.add(busiQrySKUYanbaoRsp);
            }
            resultBusiQrySKUYanbaoRspVOs.addAll(busiQrySKUYanbaoRsps);
            for (BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO : busiQrySKUYanbaoRspVOs) {
                notExistYanBaoInfoSkuIds.remove(busiQrySKUYanbaoRspVO.getSkuId());
            }
            for (String skuId : notExistYanBaoInfoSkuIds) {
                BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO = new BusiQrySKUYanbaoRspVO();
                busiQrySKUYanbaoRspVO.setSkuId(skuId);
                busiQrySKUYanbaoRspVO.setYanBao(null);
                for (String extSkuId : extSkuIds) {
                    if (!extSkuId.equals(skuId)) continue;
                    busiQrySKUYanbaoRspVO.setInnerSkuId((String)reqBO.getExtAndInSkuIdRelation().get(extSkuId));
                }
                resultBusiQrySKUYanbaoRspVOs.add(busiQrySKUYanbaoRspVO);
            }
            busiQrySKUYanbaoRspBO.setSkuYanbaos(resultBusiQrySKUYanbaoRspVOs);
            return busiQrySKUYanbaoRspBO;
        }
        for (String skuId : extSkuIds) {
            BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO = new BusiQrySKUYanbaoRspVO();
            busiQrySKUYanbaoRspVO.setSkuId(skuId);
            busiQrySKUYanbaoRspVO.setYanBao(null);
            busiQrySKUYanbaoRspVO.setInnerSkuId((String)reqBO.getExtAndInSkuIdRelation().get(skuId));
            resultBusiQrySKUYanbaoRspVOs.add(busiQrySKUYanbaoRspVO);
        }
        busiQrySKUYanbaoRspBO.setSkuYanbaos(resultBusiQrySKUYanbaoRspVOs);
        return busiQrySKUYanbaoRspBO;
    }

    private void calcYanbaoPrice(List<SKUYanbaoRspVO> yanBao, Long supplierId) {
        for (SKUYanbaoRspVO sKUYanbaoRspVO : yanBao) {
            List yanBaoDeatilList = sKUYanbaoRspVO.getFuwuSkuDetailList();
            for (YanBaoDeatilRspVO yanBaoDeatilRspVO : yanBaoDeatilList) {
                yanBaoDeatilRspVO.setSalePrice(yanBaoDeatilRspVO.getPrice());
                yanBaoDeatilRspVO.setPrice((yanBaoDeatilRspVO.getPrice() == null ? new BigDecimal(BigInteger.ZERO) : yanBaoDeatilRspVO.getPrice()).multiply(new BigDecimal(1.04)).setScale(2, 1));
                LOGGER.error("\u83b7\u53d6\u5ef6\u4fdd\u52a0\u4ef7\u540e\u7684\u91d1\u989d" + yanBaoDeatilRspVO.getPrice());
            }
        }
    }
}

