/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.afs;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.ContactConsumerReqBO;
import com.tydic.order.third.intf.bo.lm.ContactConsumerRspBO;
import com.tydic.order.third.intf.busi.lm.afs.LmIntfContactConsumerBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="contactConsumerBusiService")
public class LmIntfContactConsumerBusiServiceImpl
implements LmIntfContactConsumerBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfContactConsumerBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public ContactConsumerRspBO contactConsumer(ContactConsumerReqBO contactConsumerReqBO) {
        ContactConsumerRspBO rspBO = new ContactConsumerRspBO();
        String requestJsonStr = this.initRequestJsonStr(contactConsumerReqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_CONTACT_CONSUMER_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528LinkedMall\u8054\u7cfb\u5ba2\u6237\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("LINKED_MALL_CONTACT_CONSUMER_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528LinkedMall\u8054\u7cfb\u5ba2\u6237\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528LM\u8054\u7cfb\u5ba2\u670d\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528LM\u8054\u7cfb\u5ba2\u670d\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8054\u7cfb\u5ba2\u670d\u67e5\u8be2\u6210\u529f!");
        return rspBO;
    }

    private String initRequestJsonStr(ContactConsumerReqBO contactConsumerReqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = new HashMap<String, String>(3);
        mapParamas.put("appKey", appKey);
        if (StringUtils.isNotBlank((CharSequence)contactConsumerReqBO.getSellerId())) {
            mapParamas.put("sellerId", contactConsumerReqBO.getSellerId());
        } else {
            mapParamas.put("sellerId", "test");
        }
        mapParamas.put("cuid", String.valueOf(contactConsumerReqBO.getCuid()));
        mapParamas.put("nick", String.valueOf(contactConsumerReqBO.getNick()));
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8c03\u7528\u8054\u7cfb\u5ba2\u6237\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        if (StringUtils.isNotBlank((CharSequence)contactConsumerReqBO.getSellerId())) {
            jsonObject.put("sellerId", (Object)contactConsumerReqBO.getSellerId());
        } else {
            jsonObject.put("sellerId", (Object)"test");
        }
        jsonObject.put("cuid", (Object)String.valueOf(contactConsumerReqBO.getCuid()));
        jsonObject.put("nick", (Object)String.valueOf(contactConsumerReqBO.getNick()));
        String jsonStr = jsonObject.toJSONString();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8054\u7cfb\u5ba2\u670d\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonStr);
        }
        return jsonStr;
    }

    private ContactConsumerRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8054\u7cfb\u5ba2\u670d\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        ContactConsumerRspBO rspBO = new ContactConsumerRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u8054\u7cfb\u5ba2\u670d\u67e5\u8be2\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        JSONObject jsonData = (JSONObject)jsonObjectReturn.get((Object)"data");
        if (jsonData == null) {
            rspBO.setRespCode("2004");
            rspBO.setRespDesc("LinkedMall\u8054\u7cfb\u5ba2\u670d\u67e5\u8be2\u5931\u8d25:\u672a\u8fd4\u56dedata\u6570\u636e");
            return rspBO;
        }
        rspBO.setReturnUrl(jsonData.getString("urlData"));
        rspBO.setRespCode(jsonObjectReturn.getString("code"));
        rspBO.setRespDesc("LinkedMall\u8054\u7cfb\u5ba2\u670d\u67e5\u8be2\u6210\u529f!");
        return rspBO;
    }
}

