/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.afs;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.lm.afs.RefundApplicationDataRspBO;
import com.tydic.order.third.intf.bo.lm.lm.afs.RefundApplyReqBO;
import com.tydic.order.third.intf.bo.lm.lm.afs.RefundApplyRspBO;
import com.tydic.order.third.intf.busi.lm.afs.LmIntfRefundApplyBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="lmIntfRefundApplyBusiService")
public class LmIntfRefundApplyBusiServiceImpl
implements LmIntfRefundApplyBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfRefundApplyBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public RefundApplyRspBO refundApply(RefundApplyReqBO refundApplyReqBO) {
        RefundApplyRspBO rspBO = new RefundApplyRspBO();
        String requestJsonStr = this.initRequestJsonStr(refundApplyReqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_APPLY_REFUND_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528LinkedMall\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("LINKED_MALL_APPLY_REFUND_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528LinkedMall\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString, requestJsonStr);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528LM\u552e\u540e\u7533\u8bf7\u8be6\u60c5\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528LM\u552e\u540e\u7533\u8bf7\u8be6\u60c5\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initRequestJsonStr(RefundApplyReqBO refundApplyReqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = new HashMap<String, String>();
        mapParamas.put("appKey", appKey);
        mapParamas.put("subLmOrderId", refundApplyReqBO.getSubLmOrderId());
        mapParamas.put("bizClaimType", String.valueOf(refundApplyReqBO.getBizClaimType()));
        mapParamas.put("applyRefundFee", String.valueOf(refundApplyReqBO.getApplyRefundFee()));
        mapParamas.put("applyReasonTextId", String.valueOf(refundApplyReqBO.getApplyReasonTextId()));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)refundApplyReqBO.getTbUserId())) {
            mapParamas.put("tbUserId", refundApplyReqBO.getTbUserId());
        }
        if (refundApplyReqBO.getApplyRefundCount() != null && refundApplyReqBO.getApplyRefundCount() != 0) {
            mapParamas.put("applyRefundCount", String.valueOf(refundApplyReqBO.getApplyRefundCount()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)refundApplyReqBO.getLeaveMessage())) {
            mapParamas.put("leaveMessage", refundApplyReqBO.getLeaveMessage());
        }
        if (refundApplyReqBO.getLeavePictureList() != null && !refundApplyReqBO.getLeavePictureList().isEmpty()) {
            mapParamas.put("leavePictureList", JSONObject.toJSONString((Object)refundApplyReqBO.getLeavePictureList()));
        }
        if (refundApplyReqBO.getGoodsStatus() != null && refundApplyReqBO.getGoodsStatus() != 0) {
            mapParamas.put("goodsStatus", String.valueOf(refundApplyReqBO.getGoodsStatus()));
        }
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        jsonObject.put("subLmOrderId", (Object)refundApplyReqBO.getSubLmOrderId());
        jsonObject.put("bizClaimType", (Object)refundApplyReqBO.getBizClaimType());
        jsonObject.put("applyRefundFee", (Object)refundApplyReqBO.getApplyRefundFee());
        jsonObject.put("applyReasonTextId", (Object)refundApplyReqBO.getApplyReasonTextId());
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)refundApplyReqBO.getTbUserId())) {
            jsonObject.put("tbUserId", (Object)refundApplyReqBO.getTbUserId());
        }
        if (refundApplyReqBO.getApplyRefundCount() != null && refundApplyReqBO.getApplyRefundCount() != 0) {
            jsonObject.put("applyRefundCount", (Object)refundApplyReqBO.getApplyRefundCount());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)refundApplyReqBO.getLeaveMessage())) {
            jsonObject.put("leaveMessage", (Object)refundApplyReqBO.getLeaveMessage());
        }
        if (refundApplyReqBO.getLeavePictureList() != null && !refundApplyReqBO.getLeavePictureList().isEmpty()) {
            jsonObject.put("leavePictureList", (Object)refundApplyReqBO.getLeavePictureList());
        }
        if (refundApplyReqBO.getGoodsStatus() != null && refundApplyReqBO.getGoodsStatus() != 0) {
            jsonObject.put("goodsStatus", (Object)refundApplyReqBO.getGoodsStatus());
        }
        String jsonStr = jsonObject.toJSONString();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonStr);
        }
        return jsonStr;
    }

    private RefundApplyRspBO resolveRsp(String returnString, String reqJson) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        RefundApplyRspBO rspBO = new RefundApplyRspBO();
        rspBO.setRequestJson(reqJson);
        rspBO.setResultJson(returnString);
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            if (jsonObjectReturn.getString("message").contains("\u539f\u56e0")) {
                String originMessag = jsonObjectReturn.getString("message");
                String errorMsg = originMessag.substring(originMessag.indexOf("\u539f\u56e0"), originMessag.length() - 1);
                rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u5931\u8d25!" + errorMsg);
            } else {
                rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            }
            return rspBO;
        }
        JSONObject jsonData = (JSONObject)jsonObjectReturn.get((Object)"data");
        if (jsonData == null) {
            rspBO.setRespCode("2003");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u5931\u8d25:\u672a\u8fd4\u56dedata\u6570\u636e!");
            return rspBO;
        }
        JSONObject jsonRefundApplicationData = (JSONObject)jsonData.get((Object)"RefundApplicationData");
        RefundApplicationDataRspBO refundApplicationDataRspBO = null;
        if (jsonRefundApplicationData == null) {
            rspBO.setRespCode("2003");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u5931\u8d25:\u672a\u8fd4\u56de\u9006\u5411\u7533\u8bf7\u4fe1\u606f");
        } else {
            refundApplicationDataRspBO = (RefundApplicationDataRspBO)JSONObject.parseObject((String)jsonRefundApplicationData.toJSONString(), RefundApplicationDataRspBO.class);
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u7533\u8bf7\u6210\u529f!");
        }
        rspBO.setRefundApplicationData(refundApplicationDataRspBO);
        return rspBO;
    }
}

