/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.logistics;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.logistics.ComfirmReceiptReqBO;
import com.tydic.order.third.intf.bo.lm.logistics.ComfirmReceiptRspBO;
import com.tydic.order.third.intf.busi.lm.logistics.LmIntfComfirmReceiptBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="lmIntfComfirmReceiptBusiService")
public class LmIntfComfirmReceiptBusiServiceImpl
implements LmIntfComfirmReceiptBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfComfirmReceiptBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Value(value="${isOpenLmTemp}")
    private Boolean isOpenLmTemp;

    public ComfirmReceiptRspBO comfirmReceipt(ComfirmReceiptReqBO comfirmReceiptReqBO) {
        ComfirmReceiptRspBO rspBO = new ComfirmReceiptRspBO();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("LinkedMall\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u670d\u52a1\u51fa\u53c2:" + comfirmReceiptReqBO.toString());
        }
        String requestJsonStr = this.initRequestJsonStr(comfirmReceiptReqBO);
        if (this.isOpenLmTemp.booleanValue()) {
            String returnString = "{\"code\":\"0000\",\"message\":\"\"}";
            rspBO = this.resolveRsp(returnString);
            return rspBO;
        }
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_CONFIRM_RECEIPT_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528LinkedMall\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("LINKED_MALL_CONFIRM_RECEIPT_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528LinkedMall\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528LM\u786e\u8ba4\u6536\u8d27\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528LM\u786e\u8ba4\u6536\u8d27\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    private String initRequestJsonStr(ComfirmReceiptReqBO comfirmReceiptReqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = new HashMap<String, String>();
        mapParamas.put("appKey", appKey);
        if (!StringUtils.isEmpty((Object)comfirmReceiptReqBO.getTbUserId())) {
            mapParamas.put("tbUserId", comfirmReceiptReqBO.getTbUserId());
        }
        mapParamas.put("lmOrderId", comfirmReceiptReqBO.getLmOrderId());
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8c03\u7528\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        if (!StringUtils.isEmpty((Object)comfirmReceiptReqBO.getTbUserId())) {
            jsonObject.put("tbUserId", (Object)comfirmReceiptReqBO.getTbUserId());
        }
        jsonObject.put("lmOrderId", (Object)comfirmReceiptReqBO.getLmOrderId());
        String jsonStr = jsonObject.toJSONString();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonStr);
        }
        return jsonStr;
    }

    private ComfirmReceiptRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        ComfirmReceiptRspBO rspBO = new ComfirmReceiptRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        rspBO.setRespCode(jsonObjectReturn.getString("code"));
        rspBO.setRespDesc("LinkedMall\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u6210\u529f!");
        return rspBO;
    }
}

