/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.logistics;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.logistics.LogisticRspBO;
import com.tydic.order.third.intf.bo.lm.logistics.QryLogisticsReqBO;
import com.tydic.order.third.intf.bo.lm.logistics.QryLogisticsRspBO;
import com.tydic.order.third.intf.busi.lm.logistics.LmIntfQryLogisticsBusiServcie;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="lmIntfQryLogisticsBusiServcie")
public class LmIntfQryLogisticsBusiServcieImpl
implements LmIntfQryLogisticsBusiServcie {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfQryLogisticsBusiServcieImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Value(value="${isOpenLmTemp}")
    private Boolean isOpenLmTemp;

    public QryLogisticsRspBO qryLogistics(QryLogisticsReqBO qryLogisticsReqBO) {
        QryLogisticsRspBO rspBO = new QryLogisticsRspBO();
        if (this.isOpenLmTemp.booleanValue()) {
            String mockString = this.buildLogisticsRspBO();
            rspBO = this.resolveRsp(mockString);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u6210\u529f!");
            return rspBO;
        }
        String requestJsonStr = this.initRequestJsonStr(qryLogisticsReqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_QRY_ORDER_LOGISTICS_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528LinkedMall\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("LINKED_MALL_QRY_ORDER_LOGISTICS_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528LinkedMall\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528LM\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528LM\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    private String initRequestJsonStr(QryLogisticsReqBO qryLogisticsReqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = new HashMap<String, String>();
        mapParamas.put("appKey", appKey);
        if (!StringUtils.isEmpty((Object)qryLogisticsReqBO.getTbUserId())) {
            mapParamas.put("tbUserId", qryLogisticsReqBO.getTbUserId());
        }
        mapParamas.put("lmOrderId", qryLogisticsReqBO.getLmOrderId());
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8c03\u7528\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        if (!StringUtils.isEmpty((Object)qryLogisticsReqBO.getTbUserId())) {
            jsonObject.put("tbUserId", (Object)qryLogisticsReqBO.getTbUserId());
        }
        jsonObject.put("lmOrderId", (Object)qryLogisticsReqBO.getLmOrderId());
        String jsonStr = jsonObject.toJSONString();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonStr);
        }
        return jsonStr;
    }

    private QryLogisticsRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u7269\u6d41\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        QryLogisticsRspBO rspBO = new QryLogisticsRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        JSONObject jsonData = (JSONObject)jsonObjectReturn.get((Object)"data");
        if (jsonData == null) {
            rspBO.setRespCode("2007");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:\u672a\u8fd4\u56deData\u6570\u636e!");
            return rspBO;
        }
        JSONArray jsonLogistics = (JSONArray)jsonData.get((Object)"orderLogistics");
        if (jsonLogistics == null) {
            rspBO.setRespCode("2007");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:\u672a\u8fd4\u56de\u7269\u6d41\u5177\u4f53\u6570\u636e!");
            return rspBO;
        }
        List logisticRspBOS = JSONArray.parseArray((String)jsonLogistics.toJSONString(), LogisticRspBO.class);
        rspBO.setOrderLogistics(logisticRspBOS);
        rspBO.setRespCode(jsonObjectReturn.getString("code"));
        rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u6210\u529f!");
        return rspBO;
    }

    private String buildLogisticsRspBO() {
        int judgeNumType = 2;
        Random random = new Random();
        int randomNum = random.nextInt(10000000);
        String logistics = randomNum % judgeNumType == 0 ? "{\"code\":\"0000\",\"data\":{\"orderLogistics\":[{\"dataProvider\":\"\u83dc\u9e1f\u88f9\u88f9\",\"dataProviderTitle\":\"\u672c\u6570\u636e\u7531\u83dc\u9e1f\u88f9\u88f9\u63d0\u4f9b\",\"fetcherAddress\":\"\",\"fetcherName\":\"\",\"fetcherPhoneNumber\":\"\",\"fetcherZipCode\":\"\",\"logisticsCompanyCode\":\"\",\"logisticsCompanyName\":\"\u7533\u901a\u5feb\u9012\",\"logisticsDetails\":[{\"ocurrTimeStr\":\"2020-02-25 11:13:48\",\"standerdDesc\":\"\u60a8\u7684\u5b9d\u8d1d\u5373\u5c06\u7531\u63fd\u4ef6\u5458\u3010\u798f\u5dde\u5bb6\u6e05\u5546\u8d38\u3011\u53d1\u51fa\u3002\u5982\u957f\u65f6\u95f4\u672a\u66f4\u65b0\u8bf7\u62e8\u6253\u8054\u7cfb\u7535\u8bdd\uff1a\u301095543\u3011\",\"statusIcon\":\"\"},{\"ocurrTimeStr\":\"2020-02-24 19:22:59\",\"standerdDesc\":\"\u5305\u88f9\u6b63\u5728\u7b49\u5f85\u63fd\u6536\",\"statusIcon\":\"\"},{\"ocurrTimeStr\":\"2020-02-24 08:53:06\",\"standerdDesc\":\"\u5546\u54c1\u5df2\u7ecf\u4e0b\u5355\",\"statusIcon\":\"\"}],\"mailNo\":\"" + randomNum + "\",\"orderCode\":\"\",\"receiverAddress\":\"\",\"receiverName\":\"\",\"receiverPhoneNumber\":\"\",\"receiverZipCode\":\"\",\"tradeId\":\"\"}]},\"message\":\"\u6210\u529f\",\"requestId\":\"06484FC4-3FE6-4A8E-ADD8-6AE5E4B85389\"}" : "{\"code\":\"0000\",\"data\":{\"orderLogistics\":[{\"dataProvider\":\"\u83dc\u9e1f\u88f9\u88f9\",\"dataProviderTitle\":\"\u672c\u6570\u636e\u7531\u83dc\u9e1f\u88f9\u88f9\u63d0\u4f9b\",\"fetcherAddress\":\"\",\"fetcherName\":\"\",\"fetcherPhoneNumber\":\"\",\"fetcherZipCode\":\"\",\"logisticsCompanyCode\":\"\",\"logisticsCompanyName\":\"\",\"logisticsDetails\":[{\"ocurrTimeStr\":\"2020-02-24 08:53:06\",\"standerdDesc\":\"\u5546\u54c1\u5df2\u7ecf\u4e0b\u5355\",\"statusIcon\":\"\"}],\"mailNo\":\"\",\"orderCode\":\"\",\"receiverAddress\":\"\",\"receiverName\":\"\",\"receiverPhoneNumber\":\"\",\"receiverZipCode\":\"\",\"tradeId\":\"\"}]},\"message\":\"\u6210\u529f\",\"requestId\":\"06484FC4-3FE6-4A8E-ADD8-6AE5E4B85389\"}";
        return logistics;
    }
}

