/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.order.CreateOrderReqBO;
import com.tydic.order.third.intf.bo.lm.order.CreateOrderRspBO;
import com.tydic.order.third.intf.busi.lm.order.LmIntfCreateOrderBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="lmIntfCreateOrderBusiService")
public class LmIntfCreateOrderBusiServiceImpl
implements LmIntfCreateOrderBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfCreateOrderBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Value(value="${isOpenLmTemp}")
    private Boolean isOpenLmTemp;

    public CreateOrderRspBO createOrder(CreateOrderReqBO createOrderReqBO) {
        CreateOrderRspBO rspBO = new CreateOrderRspBO();
        String requestJsonStr = this.initRequestJsonStr(createOrderReqBO);
        if (this.isOpenLmTemp.booleanValue()) {
            String returnString = "{\"code\":\"0000\",\"data\":{\"lmOrderList\":{\"lmOrderId\":[\"" + createOrderReqBO.getOutTradeId() + "\"]}},\"message\":\"\"}";
            rspBO = this.resolveRsp(returnString, requestJsonStr);
        } else {
            try {
                HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_CREATE_ORDER_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
                if (httpRetBean.getStatus() != 200) {
                    throw new RuntimeException("\u8c03\u7528LinkedMall\u8ba2\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("LINKED_MALL_CREATE_ORDER_URL") + "]");
                }
                String returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((Object)returnString)) {
                    throw new BusinessException("2001", "\u8c03\u7528LinkedMall\u8ba2\u5355\u521b\u5efa\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                rspBO = this.resolveRsp(returnString, requestJsonStr);
            }
            catch (Exception e) {
                LOGGER.error("\u8c03\u7528LM\u8ba2\u5355\u521b\u5efa\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8c03\u7528LM\u8ba2\u5355\u521b\u5efa\u63a5\u53e3\u5f02\u5e38");
                return rspBO;
            }
        }
        return rspBO;
    }

    private String initRequestJsonStr(CreateOrderReqBO createOrderReqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = StringUtils.isEmpty((Object)createOrderReqBO.getTbUserId()) ? new HashMap<String, String>(4) : new HashMap(5);
        mapParamas.put("appKey", appKey);
        if (!StringUtils.isEmpty((Object)createOrderReqBO.getTbUserId())) {
            mapParamas.put("tbUserId", createOrderReqBO.getTbUserId());
        }
        if (createOrderReqBO.getOrderExpireTime() != null) {
            mapParamas.put("orderExpireTime", String.valueOf(createOrderReqBO.getOrderExpireTime()));
        }
        mapParamas.put("outTradeId", String.valueOf(createOrderReqBO.getOutTradeId()));
        mapParamas.put("itemList", JSON.toJSONString((Object)createOrderReqBO.getItemList()));
        mapParamas.put("deliveryAddress", JSON.toJSONString((Object)createOrderReqBO.getDeliveryAddress()));
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u4e0b\u5355\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        if (!StringUtils.isEmpty((Object)createOrderReqBO.getTbUserId())) {
            jsonObject.put("tbUserId", (Object)createOrderReqBO.getTbUserId());
        }
        if (createOrderReqBO.getOrderExpireTime() != null) {
            jsonObject.put("orderExpireTime", (Object)String.valueOf(createOrderReqBO.getOrderExpireTime()));
        }
        jsonObject.put("outTradeId", (Object)String.valueOf(createOrderReqBO.getOutTradeId()));
        jsonObject.put("itemList", (Object)createOrderReqBO.getItemList());
        jsonObject.put("deliveryAddress", mapParamas.get("deliveryAddress"));
        String jsonStr = jsonObject.toJSONString();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u521b\u5efa\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonStr);
        }
        return jsonStr;
    }

    private CreateOrderRspBO resolveRsp(String returnString, String reqJson) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u521b\u5efa\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        CreateOrderRspBO rspBO = new CreateOrderRspBO();
        rspBO.setRequestJson(reqJson);
        rspBO.setResultJson(returnString);
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u521b\u5efa\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        JSONObject jsonData = (JSONObject)jsonObjectReturn.get((Object)"data");
        if (jsonData == null) {
            rspBO.setRespCode("2006");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u521b\u5efa\u5931\u8d25:\u672a\u8fd4\u56dedata\u6570\u636e!");
            return rspBO;
        }
        JSONObject jsonLmOrderList = (JSONObject)jsonData.get((Object)"lmOrderList");
        if (jsonLmOrderList == null) {
            rspBO.setRespCode("2006");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u521b\u5efa\u5931\u8d25:\u672a\u8fd4\u56de\u8ba2\u5355\u5217\u8868\u4fe1\u606f!");
            return rspBO;
        }
        JSONArray jsonLmOrder = (JSONArray)jsonLmOrderList.get((Object)"lmOrderId");
        if (jsonLmOrder == null) {
            rspBO.setRespCode("2006");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u521b\u5efa\u5931\u8d25:\u672a\u8fd4\u56de\u8ba2\u5355\u7f16\u53f7\u5217\u8868\u4fe1\u606f!");
            return rspBO;
        }
        List lmOrderList = JSONObject.parseArray((String)jsonLmOrder.toJSONString(), String.class);
        rspBO.setLmOrderList(lmOrderList);
        rspBO.setRespCode(jsonObjectReturn.getString("code"));
        rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u521b\u5efa\u6210\u529f!");
        return rspBO;
    }
}

