/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.order.QryOrderDetailRspBO;
import com.tydic.order.third.intf.bo.lm.order.QryOrderListReqBO;
import com.tydic.order.third.intf.bo.lm.order.QryOrderListRspBO;
import com.tydic.order.third.intf.busi.lm.order.LmIntfQryOrderListBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="lmIntfQryOrderListBusiService")
public class LmIntfQryOrderListBusiServiceImpl
implements LmIntfQryOrderListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfQryOrderListBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Value(value="${isOpenLmTemp}")
    private Boolean isOpenLmTemp;

    public QryOrderListRspBO qryOrderList(QryOrderListReqBO qryOrderListReqBO) {
        QryOrderListRspBO rspBO = new QryOrderListRspBO();
        if (qryOrderListReqBO.getFilterOption().getEnableStatus() == null) {
            qryOrderListReqBO.getFilterOption().setEnableStatus("-1");
        }
        if (this.isOpenLmTemp.booleanValue()) {
            String preMockString = "{\"code\":\"0000\",\"data\":{\"lmOrder\":{\"LmOrderList\":[";
            String afterMockString = "]},\"pageNo\":1,\"pageSize\":20},\"message\":\"\u6210\u529f\",\"requestId\":\"08E80B55-73F3-44CE-831E-74D03980ACE2\"}";
            StringBuilder middleMockString = new StringBuilder();
            int outOrderSize = qryOrderListReqBO.getFilterOption().getLmOrderList().size();
            for (int i = 0; i < outOrderSize; ++i) {
                String outOrderId = (String)qryOrderListReqBO.getFilterOption().getLmOrderList().get(i);
                if (outOrderSize > 1) {
                    if (outOrderSize == i + 1) {
                        middleMockString.append(this.buildMockReturnRspBO(outOrderId, i));
                        continue;
                    }
                    middleMockString.append(this.buildMockReturnRspBO(outOrderId, i));
                    middleMockString.append(",");
                    continue;
                }
                middleMockString.append(this.buildMockReturnRspBO(outOrderId, i));
            }
            String mockString = preMockString + middleMockString + afterMockString;
            rspBO = this.resolveRsp(mockString);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u5916\u90e8\u8ba2\u5355\u5217\u8868\u6210\u529f");
            return rspBO;
        }
        String requestJsonStr = this.initRequestJsonStr(qryOrderListReqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_QRY_ORDER_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528LinkedMall\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("LINKED_MALL_QRY_ORDER_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528LinkedMall\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
            if (!"0000".equals(rspBO.getRespCode())) {
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_QRY_ORDER_OLD_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
                if (httpRetBean.getStatus() != 200) {
                    throw new RuntimeException("\u8c03\u7528LinkedMall\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("LINKED_MALL_QRY_ORDER_URL") + "]");
                }
                returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((Object)returnString)) {
                    throw new BusinessException("2001", "\u8c03\u7528LinkedMall\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                rspBO = this.resolveRsp(returnString);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528LM\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528LM\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    private String initRequestJsonStr(QryOrderListReqBO qryOrderListReqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = new HashMap<String, String>();
        mapParamas.put("appKey", appKey);
        if (!StringUtils.isEmpty((Object)qryOrderListReqBO.getTbUserId())) {
            mapParamas.put("tbUserId", qryOrderListReqBO.getTbUserId());
        }
        if (qryOrderListReqBO.getFilterOption() != null) {
            mapParamas.put("filterOption", JSONObject.toJSONString((Object)qryOrderListReqBO.getFilterOption()));
        }
        mapParamas.put("pageNumber", String.valueOf(qryOrderListReqBO.getPageNumber()));
        mapParamas.put("pageSize", String.valueOf(qryOrderListReqBO.getPageSize()));
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        if (!StringUtils.isEmpty((Object)qryOrderListReqBO.getTbUserId())) {
            jsonObject.put("tbUserId", (Object)qryOrderListReqBO.getTbUserId());
        }
        if (qryOrderListReqBO.getFilterOption() != null) {
            jsonObject.put("filterOption", (Object)qryOrderListReqBO.getFilterOption());
        }
        jsonObject.put("pageNumber", (Object)qryOrderListReqBO.getPageNumber());
        jsonObject.put("pageSize", (Object)qryOrderListReqBO.getPageSize());
        String jsonStr = jsonObject.toJSONString();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonStr);
        }
        return jsonStr;
    }

    private QryOrderListRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        QryOrderListRspBO rspBO = new QryOrderListRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            rspBO.setPageNo(Integer.valueOf(0));
            rspBO.setPageSize(Integer.valueOf(0));
            return rspBO;
        }
        JSONObject jsonData = (JSONObject)jsonObjectReturn.get((Object)"data");
        if (jsonData == null) {
            rspBO.setRespCode("2004");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5931\u8d25:\u672a\u8fd4\u56dedata\u6570\u636e");
            rspBO.setPageNo(Integer.valueOf(0));
            rspBO.setPageSize(Integer.valueOf(0));
            return rspBO;
        }
        JSONObject jsonLmOrder = (JSONObject)jsonData.get((Object)"lmOrder");
        if (jsonLmOrder == null) {
            rspBO.setRespCode("2004");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5931\u8d25:\u672a\u8fd4\u56de\u8ba2\u5355\u4fe1\u606f");
            rspBO.setPageNo(Integer.valueOf(0));
            rspBO.setPageSize(Integer.valueOf(0));
            return rspBO;
        }
        JSONArray jsonLmOrderList = (JSONArray)jsonLmOrder.get((Object)"LmOrderList");
        if (jsonLmOrderList == null) {
            rspBO.setRespCode("2004");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5931\u8d25:\u672a\u8fd4\u56de\u8ba2\u5355\u5217\u8868\u4fe1\u606f");
            rspBO.setPageNo(Integer.valueOf(0));
            rspBO.setPageSize(Integer.valueOf(0));
            return rspBO;
        }
        List lmOrderList = JSONObject.parseArray((String)jsonLmOrderList.toJSONString(), QryOrderDetailRspBO.class);
        rspBO.setPageNo(jsonData.getInteger("pageNo"));
        rspBO.setPageSize(jsonData.getInteger("pageSize"));
        rspBO.setLmOrder(lmOrderList);
        rspBO.setRespCode(jsonObjectReturn.getString("code"));
        rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u6210\u529f!");
        return rspBO;
    }

    private String buildMockReturnRspBO(String outOrderId, int i) {
        int judgeNumType = 2;
        Random random = new Random();
        int randomNum = random.nextInt(10000000);
        int logisticsStatus = randomNum % judgeNumType == 0 ? 2 : 1;
        String skuId = "";
        String itemId = "";
        if (i == 0) {
            skuId = "-1";
            itemId = "601970651986";
        } else if (i == 1) {
            skuId = "-1";
            itemId = "598571362139";
        }
        return "{\"createDate\":\"2020-02-24 08:52:55\",\"extJson\":\"\",\"fundAmount\":0,\"fundAmountMoney\":1,\"fundType\":\"lmPointPay\",\"lmOrderId\":" + outOrderId + ",\"lmPaymentId\":\"" + randomNum + "\",\"logisticsStatus\":" + logisticsStatus + ",\"orderAmount\":1,\"orderListDetails\":[{\"fundAmount\":0,\"fundAmountMoney\":1,\"fundType\":\"lmPointPay\",\"itemId\":" + itemId + ",\"itemPic\":\"http://www.baidu.com\",\"itemTitle\":\"\u6d4b\u8bd5\u7528\u5546\u54c1\u540d\u79f0\",\"lmOrderId\":" + outOrderId + ",\"number\":1,\"skuId\":" + skuId + ",\"skuName\":\"\"}],\"orderStatus\":2,\"shopName\":\"\u597d\u98df\u671f\u7279\u60e0\u98df\u54c1\",\"tbOrderId\":" + randomNum + "}";
    }
}

