/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.notify.PebTheOrderRemindReqBO;
import com.tydic.order.third.intf.bo.notify.PebTheOrderRemindRspBO;
import com.tydic.order.third.intf.busi.notify.PebTheOrderRemindBusiService;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.order.third.intf.constant.CommonConstant;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pebTheOrderRemindBusiService")
public class PebTheOrderRemindBusiServiceImpl
implements PebTheOrderRemindBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebTheOrderRemindBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public PebTheOrderRemindRspBO dealPebTheOrderRemind(PebTheOrderRemindReqBO reqBO) {
        PebTheOrderRemindRspBO rspBO = new PebTheOrderRemindRspBO();
        if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_MESSAGE)) {
            String requestJsonStr = this.initRequestMessageJsonStr(reqBO);
            rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_INNER_SYSMESSAGE_URL");
        } else {
            String requestJsonStr = this.initRequestMobileOrEmailJsonStr(reqBO);
            rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_ONLY_MESSAGE_URL");
        }
        return rspBO;
    }

    private PebTheOrderRemindRspBO doUrlPostRequest(String requestJsonStr, String url) {
        PebTheOrderRemindRspBO rspBO = new PebTheOrderRemindRspBO();
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty(url)), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty(url) + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    private String initRequestMobileOrEmailJsonStr(PebTheOrderRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("phoneNum", (Object)reqBO.getMobile());
        jsonObject.put("mail", (Object)reqBO.getEmail());
        jsonObject.put("templateParam", (Object)JSON.toJSONString((Object)reqBO.getTemplateId()));
        jsonObject.put("sendPlatform", (Object)CommonConstant.SEND_PLAT_FROM);
        jsonObject.put("templateId", (Object)reqBO.getTemplateId());
        String jsonStr = jsonObject.toJSONString();
        return jsonStr;
    }

    private String initRequestMessageJsonStr(PebTheOrderRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sendid", (Object)reqBO.getUserId());
        jsonObject.put("recid", (Object)reqBO.getReceiveId());
        jsonObject.put("appid", (Object)PropertiesUtil.getProperty("APP_ID"));
        jsonObject.put("titel", (Object)reqBO.getTitel());
        jsonObject.put("templateId", (Object)reqBO.getTemplateId());
        jsonObject.put("templateParam", (Object)JSON.toJSONString((Object)reqBO.getTemplateParam()));
        return jsonObject.toJSONString();
    }

    private PebTheOrderRemindRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        PebTheOrderRemindRspBO rspBO = new PebTheOrderRemindRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0".equals(jsonObjectReturn.getString("respCode"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("respCode"));
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25!" + jsonObjectReturn.getString("respDesc"));
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u6210\u529f!");
        return rspBO;
    }
}

