/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.es.file;

import com.tydic.order.pec.ability.other.UocPebFileUploadAbilityService;
import com.tydic.order.uoc.bo.other.UocCoreFileBO;
import com.tydic.order.uoc.bo.other.UocCoreFileUploadReqBO;
import com.tydic.order.uoc.bo.other.UocCoreFileUploadRspBO;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"peb/order"})
public class UocPebFileUploadController {
    @Reference(interfaceClass=UocPebFileUploadAbilityService.class, version="1.0.0", group="UOC_GROUP")
    private UocPebFileUploadAbilityService uocPebFileUploadAbilityService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UocPebFileUploadController.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/fileUpload"})
    @ResponseBody
    public UocCoreFileUploadRspBO upload(@RequestParam(value="files") MultipartFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<UocCoreFileBO> list = new ArrayList<UocCoreFileBO>();
        for (MultipartFile file : files) {
            InputStream inputStream = null;
            try {
                inputStream = file.getInputStream();
                String fileName = file.getOriginalFilename();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                UocCoreFileBO uocPebFileBO = new UocCoreFileBO();
                uocPebFileBO.setFileName(fileName);
                uocPebFileBO.setFile(bytes);
                uocPebFileBO.setFileType(suffix);
                list.add(uocPebFileBO);
            }
            catch (Exception e) {
                UocCoreFileUploadRspBO rspBO = new UocCoreFileUploadRspBO();
                rspBO.setRespDesc("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
                rspBO.setRespCode("8888");
                UocCoreFileUploadRspBO uocCoreFileUploadRspBO = rspBO;
                return uocCoreFileUploadRspBO;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
                }
            }
        }
        UocCoreFileUploadReqBO reqBO = new UocCoreFileUploadReqBO();
        reqBO.setFiles(list);
        return this.uocPebFileUploadAbilityService.upload(reqBO);
    }
}

