/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.mall.afterservice;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.tydic.order.mall.ability.afterservice.LmFileUploadAbilityService;
import com.tydic.order.uoc.bo.other.UocCoreFileBO;
import com.tydic.order.uoc.bo.other.UocCoreFileUploadReqBO;
import com.tydic.order.uoc.bo.other.UocCoreFileUploadRspBO;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/peb/order"})
public class LmFileUpLoadController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmFileUpLoadController.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV")
    private LmFileUploadAbilityService lmFileUploadAbilityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/fileUpload"})
    public UocCoreFileUploadRspBO upload(@RequestParam(value="files") MultipartFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<UocCoreFileBO> list = new ArrayList<UocCoreFileBO>();
        for (MultipartFile file : files) {
            InputStream inputStream = null;
            try {
                inputStream = file.getInputStream();
                String fileName = file.getOriginalFilename();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                UocCoreFileBO uocPebFileBO = new UocCoreFileBO();
                uocPebFileBO.setFile(bytes);
                uocPebFileBO.setFileName(fileName);
                uocPebFileBO.setFileType(suffix);
                list.add(uocPebFileBO);
            }
            catch (Exception e) {
                UocCoreFileUploadRspBO rspBO = new UocCoreFileUploadRspBO();
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
                UocCoreFileUploadRspBO uocCoreFileUploadRspBO = rspBO;
                return uocCoreFileUploadRspBO;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
                }
            }
        }
        UocCoreFileUploadReqBO reqBO = new UocCoreFileUploadReqBO();
        reqBO.setFiles(list);
        return this.lmFileUploadAbilityService.upload(reqBO);
    }
}

