/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.ability.UocPebPreOrderSubmitAbilityService;
import com.tydic.order.pec.busi.es.order.UocPebPreOrderSubmitBsuiService;
import com.tydic.order.pec.busi.es.order.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.order.pec.busi.es.order.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UOC_GROUP", interfaceClass=UocPebPreOrderSubmitAbilityService.class)
public class UocPebPreOrderSubmitAbilityServiceImpl
implements UocPebPreOrderSubmitAbilityService {
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    private Logger logger = LoggerFactory.getLogger(UocPebPreOrderSubmitAbilityServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;

    public UocPebPreOrderSubmitRspBO submit(UocPebPreOrderSubmitReqBO reqBO) {
        UocPebPreOrderSubmitRspBO rspBO = this.uocPebPreOrderSubmitBsuiService.submit(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.uocPebOrdIdxSync(reqBO);
        }
        return rspBO;
    }

    private void uocPebOrdIdxSync(UocPebPreOrderSubmitReqBO rspBO) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(rspBO.getSaleVoucherId());
        reqBO.setOrderId(rspBO.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
        try {
            UacNoTaskAuditCancelReqBO taskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
            taskAuditCancelReqBO.setCancelOperId(String.valueOf(reqBO.getUserId()));
            taskAuditCancelReqBO.setCancelReason("\u8ba2\u5355\u53d6\u6d88");
            taskAuditCancelReqBO.setObjId(rspBO.getSaleVoucherId().toString());
            taskAuditCancelReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            taskAuditCancelReqBO.setSaveLog(Boolean.valueOf(false));
            if (reqBO.getUsername() == null) {
                taskAuditCancelReqBO.setOperName("\u7cfb\u7edf");
            } else {
                taskAuditCancelReqBO.setOperName(reqBO.getUsername());
            }
            this.uacNoTaskAuditCancelAbilityService.auditCancel(taskAuditCancelReqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

