/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.ability.impl.inspection;

import com.alibaba.fastjson.JSON;
import com.tydic.order.pec.ability.inspection.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.order.pec.bo.inspection.UocInspectionDetailsListBO;
import com.tydic.order.pec.bo.inspection.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.order.pec.bo.inspection.UocInspectionDetailsListPageQueryRspBO;
import com.tydic.order.pec.es.bo.UocEsQryInspectionListReqBO;
import com.tydic.order.pec.es.bo.UocEsQryInspectionListRspBO;
import com.tydic.order.pec.es.service.UocEsQryInspectionListBusiService;
import com.tydic.order.third.intf.ability.umc.PebIntfQryOrgByUserStationAbilityService;
import com.tydic.order.third.intf.bo.umc.EnterpriseOrgBO;
import com.tydic.order.third.intf.bo.umc.QryOrgByUserStationReqBO;
import com.tydic.order.third.intf.bo.umc.QryOrgByUserStationRspBO;
import com.tydic.order.uoc.bo.common.StationWebBO;
import com.tydic.order.uoc.constant.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UOC_GROUP", interfaceClass=UocInspectionDetailsListPageQueryAbilityService.class)
public class UocInspectionDetailsListPageQueryAbilityServiceImpl
implements UocInspectionDetailsListPageQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocInspectionDetailsListPageQueryAbilityServiceImpl.class);
    @Autowired
    private UocEsQryInspectionListBusiService esQryInspectionListBusiService;
    @Autowired
    private PebIntfQryOrgByUserStationAbilityService pebIntfQryOrgByUserStationAbilityService;

    public UocInspectionDetailsListPageQueryRspBO getInspectionDetailsList(UocInspectionDetailsListPageQueryReqBO reqBO) {
        Boolean isPermission = this.controlPermission(reqBO);
        UocEsQryInspectionListRspBO esQryInspectionListRspBO = new UocEsQryInspectionListRspBO();
        if (isPermission.booleanValue()) {
            UocEsQryInspectionListReqBO esQryInspectionListReqBO = this.buildEsQryInspectionListReqBO(reqBO);
            esQryInspectionListRspBO = this.esQryInspectionListBusiService.esQryInspectionList(esQryInspectionListReqBO);
        }
        return this.transEsQryInspectionListRspBO(esQryInspectionListRspBO, isPermission);
    }

    private UocEsQryInspectionListReqBO buildEsQryInspectionListReqBO(UocInspectionDetailsListPageQueryReqBO reqBO) {
        UocEsQryInspectionListReqBO esQryInspectionListReqBO = (UocEsQryInspectionListReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocEsQryInspectionListReqBO.class);
        esQryInspectionListReqBO.setIsAfterSales(true);
        return esQryInspectionListReqBO;
    }

    private UocInspectionDetailsListPageQueryRspBO transEsQryInspectionListRspBO(UocEsQryInspectionListRspBO esQryInspectionListRspBO, Boolean isPermission) {
        UocInspectionDetailsListPageQueryRspBO rspBO = new UocInspectionDetailsListPageQueryRspBO();
        if (isPermission.booleanValue()) {
            rspBO.setPageNo(esQryInspectionListRspBO.getPageNo());
            rspBO.setTotal(esQryInspectionListRspBO.getTotal());
            rspBO.setRecordsTotal(esQryInspectionListRspBO.getRecordsTotal());
            if (CollectionUtils.isNotEmpty((Collection)esQryInspectionListRspBO.getRows())) {
                for (UocInspectionDetailsListBO inspectionDetailsListBO : esQryInspectionListRspBO.getRows()) {
                    inspectionDetailsListBO.getInspectionItemInfo().removeIf(inspectionItemListBO -> inspectionItemListBO.getAvailableAfterServCount().compareTo(BigDecimal.ZERO) <= 0);
                }
            }
            rspBO.setRows(esQryInspectionListRspBO.getRows());
        } else {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList(0));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Boolean controlPermission(UocInspectionDetailsListPageQueryReqBO reqBO) {
        if (null != reqBO.getIsControlData() && reqBO.getIsControlData().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
                throw new BusinessException("0001", "\u5165\u53c2\u5c97\u4f4d\u4fe1\u606f[umcStationsListWebExt]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<String> orderSourceList = new ArrayList<String>();
            for (StationWebBO stationWebBO : reqBO.getUmcStationsListWebExt()) {
                if ("cs:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("2");
                } else if ("zq:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("1");
                }
                if (orderSourceList.size() != 2) continue;
                break;
            }
            if (orderSourceList.size() == 0) {
                return false;
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderSourceList())) {
                reqBO.getOrderSourceList().removeIf(orderSource -> !orderSourceList.contains(orderSource));
            } else if (orderSourceList.size() < 2) {
                reqBO.setOrderSourceList(orderSourceList);
            }
        }
        if (null != reqBO.getIsControlPermission() && reqBO.getIsControlPermission().booleanValue() && StringUtils.isBlank((CharSequence)reqBO.getCreateOperId())) {
            QryOrgByUserStationReqBO qryOrgReqBO = new QryOrgByUserStationReqBO();
            if (null == reqBO.getMemIdExt() || 0L == reqBO.getMemIdExt()) {
                throw new BusinessException("0001", "\u5165\u53c2\u4f1a\u5458ID[memIdExt]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            qryOrgReqBO.setMemIdExt(reqBO.getMemIdExt());
            qryOrgReqBO.setStationType("ORDER_QRY_ORG_AUTH");
            QryOrgByUserStationRspBO qryOrgRspBO = this.pebIntfQryOrgByUserStationAbilityService.qryOrgByUserStation(qryOrgReqBO);
            log.debug("\u9a8c\u6536\u5355\u5217\u8868\u67e5\u8be2\u5f53\u524d\u767b\u9646\u4eba\u673a\u6784\u5217\u8868\u7ed3\u679c\u4e3a:" + JSON.toJSONString((Object)qryOrgRspBO));
            if (!"0000".equals(qryOrgRspBO.getRespCode())) {
                throw new BusinessException(qryOrgRspBO.getRespCode(), qryOrgRspBO.getRespDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPurNo())) {
                if (null == reqBO.getPurNoList()) {
                    reqBO.setPurNoList(new ArrayList());
                }
                reqBO.getPurNoList().add(reqBO.getPurNo());
                reqBO.setPurNoList(reqBO.getPurNoList().stream().distinct().collect(Collectors.toList()));
                reqBO.setPurNo(null);
            }
            if (!qryOrgRspBO.getViewAllFlag().booleanValue() && qryOrgRspBO.getRows().isEmpty()) {
                if (null == reqBO.getOrgId() || 0L == reqBO.getOrgId()) {
                    throw new BusinessException("0001", "\u5165\u53c2\u673a\u6784ID[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String purNo2 = reqBO.getOrgId() + "";
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurNoList()) && !reqBO.getPurNoList().contains(purNo2)) {
                    return false;
                }
                reqBO.setPurNoList(Collections.singletonList(purNo2));
            } else if (!qryOrgRspBO.getViewAllFlag().booleanValue() && !qryOrgRspBO.getRows().isEmpty()) {
                ArrayList<String> purNoList = new ArrayList<String>();
                for (EnterpriseOrgBO enterpriseOrgBO : qryOrgRspBO.getRows()) {
                    purNoList.add(enterpriseOrgBO.getOrgId() + "");
                }
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurNoList())) {
                    reqBO.getPurNoList().removeIf(purNo -> !purNoList.contains(purNo));
                } else {
                    reqBO.setPurNoList(purNoList);
                }
            }
        }
        return true;
    }
}

