/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.ability.impl.order;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.ability.order.PebOrderAdjustPriceAbilityService;
import com.tydic.order.pec.bo.order.PebOrderAdjustPriceReqBO;
import com.tydic.order.pec.bo.order.PebOrderAdjustPriceRspBO;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.pec.busi.order.PebOrderAdjustPriceBusiService;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocConstant;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UOC_GROUP", interfaceClass=PebOrderAdjustPriceAbilityService.class)
public class PebOrderAdjustPriceAbilityServiceImpl
implements PebOrderAdjustPriceAbilityService {
    @Autowired
    private PebOrderAdjustPriceBusiService pebOrderAdjustPriceBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocCreateOrderMsgProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;

    public PebOrderAdjustPriceRspBO dealPebOrderAdjustPrice(PebOrderAdjustPriceReqBO reqBO) {
        this.val(reqBO);
        this.idxSync(reqBO);
        PebOrderAdjustPriceRspBO rspBO = this.pebOrderAdjustPriceBusiService.dealPebOrderAdjustPrice(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.idxSync(reqBO);
        }
        return rspBO;
    }

    private void idxSync(PebOrderAdjustPriceReqBO reqBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void val(PebOrderAdjustPriceReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderItemAdjustList())) {
            throw new BusinessException("0001", "\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new BusinessException("0001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new BusinessException("0001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

