/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.atom.impl.el.order;

import com.tydic.order.pec.atom.el.order.UocPebSettlementDeductionsAtomService;
import com.tydic.order.pec.atom.el.order.bo.UocPebSettlementDeductionsAtomReqBO;
import com.tydic.order.pec.atom.el.order.bo.UocPebSettlementDeductionsAtomRspBO;
import com.tydic.order.pec.atom.es.others.GenerateOrderPaySeqAtomService;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.third.intf.ability.fsc.PebIntfOrderPayAbilityService;
import com.tydic.order.third.intf.bo.fsc.OrderPayReqBO;
import com.tydic.order.third.intf.bo.fsc.OrderPayRspBO;
import com.tydic.order.uoc.atom.core.UocCoreCreatePayOrderAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.order.uoc.bo.order.UocOrderPayItemBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.ConfPayScaleMapper;
import com.tydic.order.uoc.dao.OrdInspectionItemMapper;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdPayItemMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.po.ConfPayScalePO;
import com.tydic.order.uoc.dao.po.OrdInspectionItemPO;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdPayItemPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocPebSettlementDeductionsAtomServiceImpl
implements UocPebSettlementDeductionsAtomService {
    private static final Integer DEFAULT_PAY_TYPE = 3;
    private static final Integer INSPECTION_ITEM_PAY_OBJ_TYPE = 3;
    @Autowired
    private PebIntfOrderPayAbilityService pebIntfOrderPayAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private ConfPayScaleMapper confPayScaleMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private GenerateOrderPaySeqAtomService generateOrderPaySeqAtomService;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;

    public UocPebSettlementDeductionsAtomRspBO dealPebSettlementDeductions(UocPebSettlementDeductionsAtomReqBO reqBO) {
        OrdSalePO ordSalePO;
        if (reqBO.getInspectionId() == null) {
            if (reqBO.getPayVoucherId() != null && reqBO.getPayTotalFee() != null) {
                ordSalePO = this.qryOrdSale(reqBO);
                this.doPay(reqBO, ordSalePO);
            } else {
                ordSalePO = this.qryOrdSale(reqBO);
                this.doCountFeeByScale(reqBO, ordSalePO);
                this.doPay(reqBO, ordSalePO);
            }
        } else {
            ordSalePO = this.qryOrdSale(reqBO);
            this.doBuildPayInfoReqForAccept(reqBO, ordSalePO);
            this.doPay(reqBO, ordSalePO);
        }
        UocPebSettlementDeductionsAtomRspBO rspBO = new UocPebSettlementDeductionsAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6263\u6b3e\u6210\u529f\uff01");
        return rspBO;
    }

    private void doCountFeeByScale(UocPebSettlementDeductionsAtomReqBO reqBO, OrdSalePO ordSalePO) {
        Long payTotalFee = ordSalePO.getSaleFee();
        ConfPayScalePO confPayScalePO = new ConfPayScalePO();
        try {
            confPayScalePO = this.confPayScaleMapper.getCurrentPayScaleByPayAmount(confPayScalePO, payTotalFee);
        }
        catch (TooManyResultsException e) {
            throw new BusinessException("0100", "\u4ed8\u6b3e\u6bd4\u4f8b\u914d\u7f6e\u8868\u540c\u4e00\u7ea7\u522b\u5b58\u5728\u591a\u6761\u914d\u7f6e\u6570\u636e");
        }
        payTotalFee = confPayScalePO.getScale().divide(new BigDecimal("100")).longValue() * payTotalFee + confPayScalePO.getQuickCalculationIncrease();
        reqBO.setPayTotalFee(new BigDecimal(payTotalFee));
        this.doBuildPayInfoReqForOrder(reqBO, payTotalFee, ordSalePO.getSaleFee());
    }

    private OrdSalePO qryOrdSale(UocPebSettlementDeductionsAtomReqBO reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (ordSalePO == null) {
            throw new BusinessException("0100", "\u67e5\u8be2\u65e0\u9500\u552e\u5355");
        }
        return ordSalePO;
    }

    private void doBuildPayInfoReqForOrder(UocPebSettlementDeductionsAtomReqBO reqBO, Long payTotalFee, Long totalFee) {
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = new UocCoreCreatePayOrderReqBO();
        uocCoreCreatePayOrderReqBO.setPayVoucherNo(this.generateOrderPaySeqAtomService.generateOrderPaySeq().getPayOrderId());
        uocCoreCreatePayOrderReqBO.setPayState(PecConstant.PAY_STAT_WAIT);
        uocCoreCreatePayOrderReqBO.setCreateOperId(reqBO.getUserId() + "");
        uocCoreCreatePayOrderReqBO.setOrderId(reqBO.getOrderId());
        uocCoreCreatePayOrderReqBO.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        uocCoreCreatePayOrderReqBO.setObjId(reqBO.getSaleVoucherId());
        uocCoreCreatePayOrderReqBO.setInterType(PecConstant.PAY_FLAG);
        uocCoreCreatePayOrderReqBO.setPayType(DEFAULT_PAY_TYPE);
        uocCoreCreatePayOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        uocCoreCreatePayOrderReqBO.setTotalFee(totalFee);
        uocCoreCreatePayOrderReqBO.setPayFee(payTotalFee);
        uocCoreCreatePayOrderReqBO.setPreFee(payTotalFee);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        ordItemPO.setSaleVoucherId(reqBO.getSaleVoucherId());
        List ordItemList = this.ordItemMapper.getList(ordItemPO);
        if (CollectionUtils.isEmpty((Collection)ordItemList)) {
            throw new BusinessException("0100", "\u67e5\u8be2\u65e0\u9500\u552e\u660e\u7ec6");
        }
        ArrayList<UocOrderPayItemBO> uocOrderPayItemBOList = new ArrayList<UocOrderPayItemBO>(ordItemList.size());
        uocCoreCreatePayOrderReqBO.setUocOrderPayItemList(uocOrderPayItemBOList);
        for (OrdItemPO itemPO : ordItemList) {
            UocOrderPayItemBO uocOrderPayItemBO = new UocOrderPayItemBO();
            uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
            uocOrderPayItemBO.setOrdItemId(itemPO.getOrdItemId());
            uocOrderPayItemBO.setPayObjId(itemPO.getOrdItemId());
            uocOrderPayItemBO.setUnitName(itemPO.getUnitName());
            uocOrderPayItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
            uocOrderPayItemBO.setSalePrice(itemPO.getSalePrice());
            uocOrderPayItemBO.setPurchasePrice(itemPO.getPurchasePrice());
            uocOrderPayItemBO.setCurrencyType(itemPO.getCurrencyType());
            uocOrderPayItemBO.setPayCount(itemPO.getPurchaseCount());
            BigDecimal itemTotalFee = new BigDecimal(itemPO.getTotalSaleFee()).multiply(new BigDecimal(payTotalFee)).divide(new BigDecimal(totalFee), 6, 4);
            uocOrderPayItemBO.setTotalFee(itemPO.getTotalSaleFee());
            uocOrderPayItemBO.setPayFee(Long.valueOf(itemTotalFee.longValue()));
            uocOrderPayItemBO.setPreFee(Long.valueOf(itemTotalFee.longValue()));
            uocOrderPayItemBOList.add(uocOrderPayItemBO);
        }
        this.doCreatePayInfo(uocCoreCreatePayOrderReqBO, reqBO);
    }

    private void doBuildPayInfoReqForAccept(UocPebSettlementDeductionsAtomReqBO reqBO, OrdSalePO ordSalePO) {
        BigDecimal totalOrderFee = new BigDecimal(ordSalePO.getSaleFee());
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = new UocCoreCreatePayOrderReqBO();
        uocCoreCreatePayOrderReqBO.setPayVoucherNo(this.generateOrderPaySeqAtomService.generateOrderPaySeq().getPayOrderId());
        uocCoreCreatePayOrderReqBO.setPayState(PecConstant.PAY_STAT_WAIT);
        uocCoreCreatePayOrderReqBO.setCreateOperId(reqBO.getUserId() + "");
        uocCoreCreatePayOrderReqBO.setOrderId(reqBO.getOrderId());
        uocCoreCreatePayOrderReqBO.setObjType(PecConstant.OBJECT_TYPE_ORDER_INSPECTION);
        uocCoreCreatePayOrderReqBO.setObjId(reqBO.getInspectionId());
        uocCoreCreatePayOrderReqBO.setInterType(PecConstant.PAY_FLAG);
        uocCoreCreatePayOrderReqBO.setPayType(DEFAULT_PAY_TYPE);
        uocCoreCreatePayOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        BigDecimal payTotalFee = BigDecimal.ZERO;
        ArrayList<UocOrderPayItemBO> uocOrderPayItemBOList = new ArrayList<UocOrderPayItemBO>();
        uocCoreCreatePayOrderReqBO.setUocOrderPayItemList(uocOrderPayItemBOList);
        OrdInspectionItemPO ordInspectionItemPO = new OrdInspectionItemPO();
        ordInspectionItemPO.setOrderId(reqBO.getOrderId());
        ordInspectionItemPO.setInspectionVoucherId(reqBO.getInspectionId());
        List itemList = this.ordInspectionItemMapper.getList(ordInspectionItemPO);
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            throw new BusinessException("0100", "\u9a8c\u6536\u5355\u3010" + reqBO.getInspectionId() + "\u3011\u5bf9\u5e94\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        OrdPayPO ordPayPO = this.qryPrePay(reqBO);
        for (OrdInspectionItemPO item : itemList) {
            UocOrderPayItemBO uocOrderPayItemBO = new UocOrderPayItemBO();
            uocOrderPayItemBO.setPayObjType(INSPECTION_ITEM_PAY_OBJ_TYPE);
            uocOrderPayItemBO.setOrdItemId(item.getOrdItemId());
            uocOrderPayItemBO.setPayObjId(item.getInspectionItemId());
            uocOrderPayItemBO.setUnitName(item.getUnitName());
            uocOrderPayItemBO.setPayCount(item.getInspectionCount());
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderId(reqBO.getOrderId());
            ordItemPO.setOrdItemId(item.getOrdItemId());
            ordItemPO = this.ordItemMapper.getModelBy(ordItemPO);
            uocOrderPayItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
            uocOrderPayItemBO.setSalePrice(ordItemPO.getSalePrice());
            uocOrderPayItemBO.setPurchasePrice(ordItemPO.getPurchasePrice());
            uocOrderPayItemBO.setCurrencyType(ordItemPO.getCurrencyType());
            BigDecimal itemTotalFee = item.getInspectionCount().multiply(new BigDecimal(ordItemPO.getSalePrice())).multiply(totalOrderFee.subtract(new BigDecimal(ordPayPO.getTotalFee()))).divide(totalOrderFee, 6, 4);
            uocOrderPayItemBO.setTotalFee(ordItemPO.getTotalSaleFee());
            uocOrderPayItemBO.setPayFee(Long.valueOf(itemTotalFee.longValue()));
            uocOrderPayItemBOList.add(uocOrderPayItemBO);
            payTotalFee = payTotalFee.add(itemTotalFee);
        }
        uocCoreCreatePayOrderReqBO.setTotalFee(ordSalePO.getSaleFee());
        uocCoreCreatePayOrderReqBO.setPayFee(Long.valueOf(payTotalFee.longValue()));
        reqBO.setPayTotalFee(payTotalFee);
        this.doCreatePayInfo(uocCoreCreatePayOrderReqBO, reqBO);
        this.doModifyPayInfoForCreateOrder(uocOrderPayItemBOList, ordPayPO, uocCoreCreatePayOrderReqBO.getTotalFee());
    }

    private OrdPayPO qryPrePay(UocPebSettlementDeductionsAtomReqBO reqBO) {
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(reqBO.getOrderId());
        ordPayPO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        ordPayPO.setObjId(reqBO.getSaleVoucherId());
        ordPayPO.setInterType(PecConstant.PAY_FLAG);
        ordPayPO = this.ordPayMapper.getModelBy(ordPayPO);
        if (ordPayPO == null) {
            throw new BusinessException("0100", "\u672c\u8ba2\u5355\u6ca1\u6709\u652f\u4ed8\u9884\u4ed8\u6b3e\uff01");
        }
        return ordPayPO;
    }

    private void doModifyPayInfoForCreateOrder(List<UocOrderPayItemBO> uocOrderPayItemBOList, OrdPayPO ordPayPO, Long currentPayTotalFee) {
        OrdPayPO updatePayPO = new OrdPayPO();
        updatePayPO.setPayVoucherId(ordPayPO.getPayVoucherId());
        updatePayPO.setPayFee(Long.valueOf(ordPayPO.getPayFee() + currentPayTotalFee));
        int result = this.ordPayMapper.updateById(ordPayPO);
        if (result <= 0) {
            throw new BusinessException("0100", "\u66f4\u65b0\u652f\u4ed8\u5355\u603b\u91d1\u989d\u5931\u8d25");
        }
        HashMap<Long, Long> itemFeeMap = new HashMap<Long, Long>();
        for (UocOrderPayItemBO itemBO : uocOrderPayItemBOList) {
            if (itemFeeMap.containsKey(itemBO.getOrdItemId())) {
                Long totalFee = (Long)itemFeeMap.get(itemBO.getOrdItemId());
                itemFeeMap.put(itemBO.getOrdItemId(), itemBO.getTotalFee() + totalFee);
                continue;
            }
            itemFeeMap.put(itemBO.getOrdItemId(), itemBO.getTotalFee());
        }
        OrdPayItemPO ordPayItemPO = new OrdPayItemPO();
        ordPayItemPO.setPayVoucherId(ordPayPO.getPayVoucherId());
        ordPayItemPO.setOrderId(ordPayPO.getOrderId());
        List payItemList = this.ordPayItemMapper.getList(ordPayItemPO);
        for (OrdPayItemPO itemPO : payItemList) {
            if (itemFeeMap.get(itemPO.getOrdItemId()) == null) continue;
            itemPO.setPayFee(Long.valueOf(itemPO.getPayFee() + (Long)itemFeeMap.get(itemPO.getOrdItemId())));
            result = this.ordPayItemMapper.updateById(itemPO);
            if (result > 0) continue;
            throw new BusinessException("0100", "\u66f4\u65b0\u652f\u4ed8\u660e\u7ec6\u603b\u91d1\u989d\u5931\u8d25");
        }
    }

    private void doCreatePayInfo(UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO, UocPebSettlementDeductionsAtomReqBO reqBO) {
        UocCoreCreatePayOrderRspBO createPayOrderRsp = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(uocCoreCreatePayOrderReqBO);
        if (!"0000".equals(createPayOrderRsp.getRespCode())) {
            throw new BusinessException("0100", "\u652f\u4ed8\u5355\u521b\u5efa\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + createPayOrderRsp.getRespDesc());
        }
        reqBO.setPayVoucherId(createPayOrderRsp.getPayVoucherID());
    }

    private void doPay(UocPebSettlementDeductionsAtomReqBO reqBO, OrdSalePO ordSalePO) {
        OrderPayReqBO orderPayReqBO = new OrderPayReqBO();
        orderPayReqBO.setSaleOrderCode(ordSalePO.getSaleVoucherNo());
        orderPayReqBO.setOrderNo(String.valueOf(reqBO.getSaleVoucherId()));
        if (reqBO.getPayTotalFee().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        orderPayReqBO.setOrderAmt(reqBO.getPayTotalFee().divide(new BigDecimal("10000")));
        orderPayReqBO.setSource(ordSalePO.getOrderSource());
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        orderPayReqBO.setSupplierNo(ordStakeholderPO.getSupNo());
        orderPayReqBO.setOperatingUnitNo(Long.valueOf(ordStakeholderPO.getProNo()));
        orderPayReqBO.setPurchaseUnitNo(Long.valueOf(ordStakeholderPO.getPurAccountOwnId()));
        orderPayReqBO.setPurchaseBookNo(Long.valueOf(ordStakeholderPO.getPurAccount()));
        orderPayReqBO.setBusinessType(PecConstant.BUSINESS_TYPE_PAY);
        orderPayReqBO.setAnyPayFlag(Integer.valueOf(1));
        OrderPayRspBO orderPayRspBO = this.pebIntfOrderPayAbilityService.makingOrderPay(orderPayReqBO);
        if (!"0000".equals(orderPayRspBO.getRespCode()) || !orderPayRspBO.getIsSuccess().booleanValue()) {
            throw new BusinessException("0100", "\u8c03\u7ed3\u7b97\u6263\u6b3e\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + orderPayRspBO.getRespDesc());
        }
        OrdPayPO updatePO = new OrdPayPO();
        updatePO.setOrderId(reqBO.getOrderId());
        updatePO.setOutPayOrderNo(orderPayRspBO.getTxnNo());
        updatePO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
        updatePO.setPayVoucherId(reqBO.getPayVoucherId());
        updatePO.setPayTime(new Date());
        int result = this.ordPayMapper.updateById(updatePO);
        if (result <= 0) {
            throw new BusinessException("0100", "\u66f4\u65b0\u652f\u4ed8\u5916\u90e8\u6d41\u6c34\u5931\u8d25");
        }
    }
}

