/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.es.order;

import com.tydic.order.pec.busi.es.order.UocShipBusiService;
import com.tydic.order.pec.busi.es.order.bo.OrdItemBO;
import com.tydic.order.pec.busi.es.order.bo.UocShipBusiReqBO;
import com.tydic.order.pec.busi.es.order.bo.UocShipBusiRespBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.atom.core.UocCoreGetOrderIdAtomService;
import com.tydic.order.uoc.atom.core.UocCoreStartProcessAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreGetOrderIdRspBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreStartProcessReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreStartProcessRspBO;
import com.tydic.order.uoc.atom.process.UocStartProcessAtomService;
import com.tydic.order.uoc.bo.process.UocProcessStartReqBO;
import com.tydic.order.uoc.bo.process.UocProcessStartRspBO;
import com.tydic.order.uoc.bo.task.TaskBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdAccessoryMapper;
import com.tydic.order.uoc.dao.OrdCruxMapMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdGoodsAttrMapper;
import com.tydic.order.uoc.dao.OrdGoodsGiftMapper;
import com.tydic.order.uoc.dao.OrdGoodsMapper;
import com.tydic.order.uoc.dao.OrdInvoiceMapper;
import com.tydic.order.uoc.dao.OrdItemEwMapper;
import com.tydic.order.uoc.dao.OrdItemMapMapper;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.order.uoc.dao.OrdPromotionMapper;
import com.tydic.order.uoc.dao.OrdPurchaseItemMapper;
import com.tydic.order.uoc.dao.OrdPurchaseMapper;
import com.tydic.order.uoc.dao.OrdQueryIndexMapper;
import com.tydic.order.uoc.dao.OrdSaleCouponMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrdSkuImeiMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrdTaskCandidateMapper;
import com.tydic.order.uoc.dao.OrdTaskMapper;
import com.tydic.order.uoc.dao.OrdTaskRecordMapper;
import com.tydic.order.uoc.dao.OrdVoucherProcMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdAccessoryPO;
import com.tydic.order.uoc.dao.po.OrdCruxMapPO;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdGoodsAttrPO;
import com.tydic.order.uoc.dao.po.OrdGoodsGiftPO;
import com.tydic.order.uoc.dao.po.OrdGoodsPO;
import com.tydic.order.uoc.dao.po.OrdInvoicePO;
import com.tydic.order.uoc.dao.po.OrdItemEwPO;
import com.tydic.order.uoc.dao.po.OrdItemMapPO;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdLogisticsRelaPO;
import com.tydic.order.uoc.dao.po.OrdPromotionPO;
import com.tydic.order.uoc.dao.po.OrdPurchaseItemPO;
import com.tydic.order.uoc.dao.po.OrdPurchasePO;
import com.tydic.order.uoc.dao.po.OrdQueryIndexPO;
import com.tydic.order.uoc.dao.po.OrdSaleCouponPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrdSkuImeiPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrdTaskCandidatePO;
import com.tydic.order.uoc.dao.po.OrdTaskPO;
import com.tydic.order.uoc.dao.po.OrdTaskRecordPO;
import com.tydic.order.uoc.dao.po.OrdVoucherProcPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocShipBusiServiceImpl
implements UocShipBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(UocShipBusiServiceImpl.class);
    private static final Boolean IS_DEBUG_ENABLE = LOG.isDebugEnabled();
    @Autowired
    private UocCoreGetOrderIdAtomService uocCoreGetOrderIdAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    OrdSaleCouponMapper ordSaleCouponMapper;
    @Autowired
    OrdSaleMapper ordSaleMapper;
    @Autowired
    OrdTaskMapper ordTaskMapper;
    @Autowired
    OrdTaskCandidateMapper ordTaskCandidateMapper;
    @Autowired
    OrdVoucherProcMapper ordVoucherProcMapper;
    @Autowired
    OrdItemMapper ordItemMapper;
    @Autowired
    OrdGoodsGiftMapper ordGoodsGiftMapper;
    @Autowired
    OrdPromotionMapper ordPromotionMapper;
    @Autowired
    OrdItemMapMapper ordItemMapMapper;
    @Autowired
    OrdItemEwMapper ordItemEwMapper;
    @Autowired
    OrdGoodsMapper ordGoodsMapper;
    @Autowired
    OrdGoodsAttrMapper ordGoodsAttrMapper;
    @Autowired
    private UocCoreStartProcessAtomService uocCoreStartProcessAtomService;
    @Autowired
    private OrdTaskRecordMapper ordTaskRecordMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdSkuImeiMapper ordSkuImeiMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private OrdPurchaseItemMapper ordPurchaseItemMapper;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;

    public UocShipBusiRespBO createShipOrder(UocShipBusiReqBO reqBO) {
        this.validateParam(reqBO);
        UocCoreGetOrderIdRspBO uocCoreGetOrderIdRspBO = this.uocCoreGetOrderIdAtomService.queryCoreGetOrderId();
        if (!"0000".equals(uocCoreGetOrderIdRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u83b7\u53d6\u8ba2\u5355ID\u5931\u8d25!" + uocCoreGetOrderIdRspBO.getRespDesc());
        }
        Long orderId = uocCoreGetOrderIdRspBO.getOrderId();
        this.byOrderId(reqBO.getOrderId(), orderId, reqBO.getOrdItems());
        UocShipBusiRespBO respBO = new UocShipBusiRespBO();
        respBO.setRespCode("0000");
        reqBO.setOrderId(orderId);
        respBO.setRespDesc("\u8ba2\u5355\u62c6\u5355\u6210\u529f");
        return respBO;
    }

    private void byOrderId(Long pOrderId, Long orderId, List<OrdItemBO> itemBOS) {
        OrdSalePO ordsalePO;
        OrderPO orderPO = this.orderMapper.getModelById(pOrderId.longValue());
        if (orderPO == null) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u672a\u627e\u5230\u7236\u8ba2\u5355\u4fe1\u606f");
        }
        Long ordSaleId = this.sequence.nextId();
        Long purchaseId = this.sequence.nextId();
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(pOrderId);
        OrdPurchasePO purchasePO = new OrdPurchasePO();
        purchasePO.setOrderId(pOrderId);
        try {
            purchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
            purchasePO.setOrderId(orderId);
            purchasePO.setSaleVoucherId(ordSaleId);
            purchasePO.setPurchaseVoucherId(purchaseId);
            this.ordPurchaseMapper.insert(purchasePO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u9519\u8bef");
        }
        try {
            ordsalePO = this.ordSaleMapper.getModelBy(salePO);
            if (ordsalePO == null) {
                throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            ordsalePO.setOrderId(orderId);
            ordsalePO.setSaleVoucherId(ordSaleId);
            ordsalePO.setPurchaseVoucherId(purchaseId);
            this.ordSaleMapper.insert(ordsalePO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u9519\u8bef");
        }
        this.cruxMap(pOrderId, orderId);
        this.extMap(pOrderId, orderId);
        this.queryIndex(pOrderId, orderId);
        this.accessory(pOrderId, orderId);
        this.logisticsRela(pOrderId, orderId);
        this.invoice(pOrderId, orderId);
        this.stakeholder(pOrderId, orderId);
        this.coupon(pOrderId, orderId, ordsalePO);
        this.bySaleId(pOrderId, orderId, ordsalePO.getSaleVoucherId(), itemBOS, orderPO, purchaseId);
        this.task(pOrderId, orderId, ordsalePO, purchaseId);
    }

    private void bySaleId(Long pOrderId, Long orderId, Long saleId, List<OrdItemBO> itemBOS, OrderPO orderPO, Long purchaseId) {
        Long saleFee = 0L;
        Long purchaseFee = 0L;
        Long usedIntegral = 0L;
        Long integralFee = 0L;
        Long actShareFee = 0L;
        for (OrdItemBO bo : itemBOS) {
            Long itemId = this.sequence.nextId();
            Long purchaseItemId = this.sequence.nextId();
            OrdItemPO itemPO = new OrdItemPO();
            BeanUtils.copyProperties((Object)bo, (Object)itemPO);
            itemPO.setOrderId(orderId);
            itemPO.setSaleVoucherId(saleId);
            itemPO.setOrdItemId(itemId);
            itemPO.setPurchaseVoucherId(purchaseId);
            OrdPurchaseItemPO purchaseItemPO = new OrdPurchaseItemPO();
            BeanUtils.copyProperties((Object)itemPO, (Object)purchaseItemPO);
            purchaseItemPO.setPurchaseItemId(purchaseItemId);
            try {
                this.ordPurchaseItemMapper.insert(purchaseItemPO);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u91c7\u8d2d\u5355\u660e\u7ec6\u8868\u6570\u636e\u51fa\u9519");
            }
            try {
                this.ordItemMapper.insert(itemPO);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u8ba2\u5355\u660e\u7ec6\u4f18\u60e0\u8bb0\u5f55\u8868\u6570\u636e\u51fa\u9519");
            }
            this.promotion(pOrderId, orderId, bo.getOrdItemId(), itemPO.getOrdItemId());
            this.goodsGif(pOrderId, orderId, bo.getOrdItemId(), itemPO.getOrdItemId(), purchaseItemId);
            this.shipItem(pOrderId, orderId, bo.getOrdItemId(), itemPO.getOrdItemId());
            this.itemMap(pOrderId, orderId, bo.getOrdItemId(), itemPO.getOrdItemId(), purchaseItemId);
            this.itemEw(pOrderId, orderId, bo.getOrdItemId(), itemPO.getOrdItemId(), purchaseItemId);
            this.goods(pOrderId, orderId, bo.getOrdItemId(), itemPO.getOrdItemId(), purchaseItemId);
            saleFee = saleFee + bo.getTotalSaleFee();
            purchaseFee = purchaseFee + bo.getTotalPurchaseFee();
            usedIntegral = usedIntegral + bo.getUsedIntegral();
            integralFee = integralFee + bo.getIntegralFee();
            actShareFee = actShareFee + bo.getActShareFee();
        }
        this.updateSalePo(saleFee, purchaseFee, usedIntegral, integralFee, actShareFee, saleId);
        this.updateOrder(orderPO);
        this.addOrder(saleFee, purchaseFee, orderId, pOrderId, orderPO);
        this.addIndex(orderId);
    }

    private void addIndex(Long orderId) {
    }

    private void updateSalePo(Long saleFee, Long purchaseFee, Long usedIntegral, Long integralFee, Long actShareFee, Long saleId) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleVoucherId(saleId);
        salePO.setSaleFee(saleFee);
        salePO.setPurchaseFee(purchaseFee);
        salePO.setTotalUsedIntegral(usedIntegral);
        salePO.setTotalIntegralFee(integralFee);
        salePO.setTotalActShareFee(actShareFee);
        try {
            this.ordSaleMapper.updateById(salePO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6 \u4fee\u6539\u9500\u552e\u8ba2\u5355\u91d1\u989d\u65b9\u9762\u6570\u636e\u51fa\u9519");
        }
    }

    private void updateOrder(OrderPO orderPO) {
        OrderPO po = new OrderPO();
        BeanUtils.copyProperties((Object)orderPO, (Object)po);
        this.orderMapper.updateById(po);
    }

    private void addOrder(Long saleFee, Long purchaseFee, Long orderId, Long pOrderId, OrderPO orderPO) {
        orderPO.setUpperOrderId(pOrderId);
        orderPO.setOrderId(orderId);
        orderPO.setTotalSaleFee(saleFee);
        orderPO.setTotalPurchaseFee(purchaseFee);
        try {
            this.orderMapper.insert(orderPO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u751f\u6210\u5b50\u8ba2\u5355\u6570\u636e\u51fa\u9519");
        }
    }

    private void promotion(Long pOrderId, Long orderId, Long oldItemId, Long itemId) {
        OrdPromotionPO promotionPO = new OrdPromotionPO();
        promotionPO.setOrderId(pOrderId);
        promotionPO.setOrdItemId(oldItemId);
        try {
            List pos = this.ordPromotionMapper.getList(promotionPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdPromotionPO> saveDate = new ArrayList<OrdPromotionPO>();
                for (OrdPromotionPO po : pos) {
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    saveDate.add(po);
                }
                this.ordPromotionMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6 \u8ba2\u5355\u4f18\u60e0\u6d3b\u52a8\u8bb0\u5f55\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void goodsGif(Long pOrderId, Long orderId, Long oldItemId, Long itemId, Long purchaseItemId) {
        OrdGoodsGiftPO goodsGiftPO = new OrdGoodsGiftPO();
        goodsGiftPO.setOrderId(pOrderId);
        goodsGiftPO.setOrdItemId(oldItemId);
        try {
            List pos = this.ordGoodsGiftMapper.getList(goodsGiftPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdGoodsGiftPO> saveDate = new ArrayList<OrdGoodsGiftPO>();
                for (OrdGoodsGiftPO po : pos) {
                    po.setGiftId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    po.setPurchaseItemId(purchaseItemId);
                    saveDate.add(po);
                }
                this.ordGoodsGiftMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u8d60\u54c1\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void itemMap(Long pOrderId, Long orderId, Long oldItemId, Long itemId, Long purchaseItemId) {
        OrdItemMapPO itemMapPO = new OrdItemMapPO();
        itemMapPO.setOrderId(pOrderId);
        itemMapPO.setOrderItemId(oldItemId);
        try {
            List pos = this.ordItemMapMapper.getList(itemMapPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdItemMapPO> saveDate = new ArrayList<OrdItemMapPO>();
                for (OrdItemMapPO po : pos) {
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    po.setOrderItemId(itemId);
                    po.setOrderId(orderId);
                    po.setPurchaseItemId(purchaseItemId);
                    saveDate.add(po);
                }
                this.ordItemMapMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u8ba2\u5355\u9500\u552e\u660e\u7ec6\u6269\u5c55\u5c5e\u6027\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void itemEw(Long pOrderId, Long orderId, Long oldItemId, Long itemId, Long purchaseItemId) {
        OrdItemEwPO ordItemEwPO = new OrdItemEwPO();
        ordItemEwPO.setOrderId(pOrderId);
        ordItemEwPO.setOrdItemId(oldItemId);
        try {
            List pos = this.ordItemEwMapper.getList(ordItemEwPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdItemEwPO> saveDate = new ArrayList<OrdItemEwPO>();
                for (OrdItemEwPO po : pos) {
                    po.setEwVoucherId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    po.setPurchaseItemId(purchaseItemId);
                    saveDate.add(po);
                }
                this.ordItemEwMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u660e\u7ec6\u5ef6\u4fdd\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void shipItem(Long pOrderId, Long orderId, Long oldItemId, Long itemId) {
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(pOrderId);
        ordShipItemPO.setOrdItemId(oldItemId);
        try {
            List pos = this.ordShipItemMapper.getList(ordShipItemPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                for (OrdShipItemPO po : pos) {
                    Long id = po.getShipItemId();
                    po.setShipItemId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    this.ordShipItemMapper.insert(po);
                    this.skuImei(pOrderId, orderId, itemId, oldItemId, id, po.getShipItemId());
                }
            } else {
                this.skuImei(pOrderId, orderId, itemId, oldItemId, null, null);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u53d1\u8d27\u660e\u7ec6\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void skuImei(Long pOrderId, Long orderId, Long oldItemId, Long itemId, Long shipId, Long oldShipId) {
        OrdSkuImeiPO ordSkuImeiPO = new OrdSkuImeiPO();
        ordSkuImeiPO.setOrderId(pOrderId);
        ordSkuImeiPO.setOrdItemId(oldItemId);
        ordSkuImeiPO.setShipItemId(oldShipId);
        try {
            List pos = this.ordSkuImeiMapper.getList(ordSkuImeiPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdSkuImeiPO> saveDate = new ArrayList<OrdSkuImeiPO>();
                for (OrdSkuImeiPO po : pos) {
                    po.setShipItemId(shipId);
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    saveDate.add(po);
                }
                this.ordSkuImeiMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u53d1\u8d27\u660e\u7ec6\u5546\u54c1\u4e32\u7801\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void goods(Long pOrderId, Long orderId, Long oldItemId, Long itemId, Long purchaseItemId) {
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderId(pOrderId);
        ordGoodsPO.setOrdItemId(oldItemId);
        try {
            List pos = this.ordGoodsMapper.getList(ordGoodsPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                for (OrdGoodsPO po : pos) {
                    Long id = po.getGoodsItemId();
                    po.setGoodsItemId(Long.valueOf(this.sequence.nextId()));
                    po.setOrdItemId(itemId);
                    po.setOrderId(orderId);
                    po.setPurchaseItemId(purchaseItemId);
                    this.ordGoodsMapper.insert(po);
                    this.goodsAttr(pOrderId, orderId, id, po.getGoodsItemId());
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u660e\u7ec6\u5ef6\u4fdd\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void goodsAttr(Long pOrderId, Long orderId, Long oldGoodsId, Long goodsId) {
        OrdGoodsAttrPO attrPOdsPO = new OrdGoodsAttrPO();
        attrPOdsPO.setOrderId(pOrderId);
        attrPOdsPO.setGoodsItemId(oldGoodsId);
        try {
            List pos = this.ordGoodsAttrMapper.getList(attrPOdsPO);
            if (!CollectionUtils.isEmpty((Collection)pos)) {
                ArrayList<OrdGoodsAttrPO> saveDate = new ArrayList<OrdGoodsAttrPO>();
                for (OrdGoodsAttrPO po : pos) {
                    po.setItemAttrId(Long.valueOf(this.sequence.nextId()));
                    po.setGoodsItemId(goodsId);
                    po.setOrderId(orderId);
                    saveDate.add(po);
                }
                this.ordGoodsAttrMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u9500\u552e\u660e\u7ec6\u5ef6\u4fdd\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void cruxMap(Long pOrderId, Long orderId) {
        OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
        cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        cruxMapPO.setOrderId(pOrderId);
        try {
            cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
            if (cruxMapPO != null) {
                cruxMapPO.setOrderId(orderId);
                cruxMapPO.setId(Long.valueOf(this.sequence.nextId()));
                this.ordCruxMapMapper.insert(cruxMapPO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u8ba2\u5355\u5355\u636e\u5173\u952e\u5c5e\u6027\u6269\u5c55\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void extMap(Long pOrderId, Long orderId) {
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(pOrderId);
        ordExtMapCondition.setObjType(UocConstant.OBJ_TYPE.ORDER);
        try {
            List extMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
            if (!CollectionUtils.isEmpty((Collection)extMapList)) {
                ArrayList<OrdExtMapPO> poList = new ArrayList<OrdExtMapPO>();
                for (OrdExtMapPO po : extMapList) {
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    po.setOrderId(orderId);
                    poList.add(po);
                }
                this.ordExtMapMapper.insertBatch(poList);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u8ba2\u5355\u5355\u636e\u6269\u5c55\u5c5e\u6027\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void queryIndex(Long pOrderId, Long orderId) {
        OrdQueryIndexPO ordQueryIndexPO = new OrdQueryIndexPO();
        ordQueryIndexPO.setOrderId(pOrderId);
        ordQueryIndexPO.setObjType(PecConstant.OBJECT_TYPE_ORDER);
        try {
            List list = this.ordQueryIndexMapper.getList(ordQueryIndexPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                ArrayList<OrdQueryIndexPO> ordQueryIndexPOS = new ArrayList<OrdQueryIndexPO>();
                for (OrdQueryIndexPO indexPO : list) {
                    indexPO.setOrderId(orderId);
                    indexPO.setId(Long.valueOf(this.sequence.nextId()));
                    ordQueryIndexPOS.add(indexPO);
                }
                this.ordQueryIndexMapper.insertBatch(ordQueryIndexPOS);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void accessory(Long pOrderId, Long orderId) {
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setOrderId(pOrderId);
        try {
            List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
            if (!CollectionUtils.isEmpty((Collection)ordAccessoryPOList)) {
                ArrayList<OrdAccessoryPO> accessoryPOS = new ArrayList<OrdAccessoryPO>();
                for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
                    accessoryPO.setOrderId(orderId);
                    accessoryPO.setId(Long.valueOf(this.sequence.nextId()));
                    accessoryPO.setCreateTime(new Date());
                    accessoryPOS.add(accessoryPO);
                }
                this.ordAccessoryMapper.insertBatch(accessoryPOS);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u65f6\u9644\u4ef6\u4fe1\u606f\u6570\u636e\u51fa\u9519");
        }
    }

    private void logisticsRela(Long pOrderId, Long orderId) {
        OrdLogisticsRelaPO logisticsRela = new OrdLogisticsRelaPO();
        logisticsRela.setOrderId(pOrderId);
        try {
            OrdLogisticsRelaPO logisticsRelaPO = this.ordLogisticsRelaMapper.getModelBy(logisticsRela);
            if (logisticsRelaPO != null) {
                logisticsRela.setContactId(Long.valueOf(this.sequence.nextId()));
                logisticsRela.setOrderId(orderId);
                this.ordLogisticsRelaMapper.insert(logisticsRelaPO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u7269\u6d41\u8054\u7cfb\u4eba\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void invoice(Long pOrderId, Long orderId) {
        OrdInvoicePO invoicePO = new OrdInvoicePO();
        invoicePO.setOrderId(pOrderId);
        try {
            OrdInvoicePO ordInvoicePO = this.ordInvoiceMapper.getModelByPO(invoicePO);
            if (ordInvoicePO != null) {
                ordInvoicePO.setId(Long.valueOf(this.sequence.nextId()));
                ordInvoicePO.setOrderId(orderId);
                this.ordInvoiceMapper.insert(ordInvoicePO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void stakeholder(Long pOrderId, Long orderId) {
        try {
            OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(pOrderId.longValue());
            if (ordStakeholderPO != null) {
                ordStakeholderPO.setOrderId(orderId);
                this.ordStakeholderMapper.insert(ordStakeholderPO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void coupon(Long pOrderId, Long orderId, OrdSalePO salePO) {
        try {
            OrdSaleCouponPO couponPO = new OrdSaleCouponPO();
            couponPO.setOrderId(pOrderId);
            List couponPOS = this.ordSaleCouponMapper.getList(couponPO);
            if (!CollectionUtils.isEmpty((Collection)couponPOS)) {
                ArrayList<OrdSaleCouponPO> saveDate = new ArrayList<OrdSaleCouponPO>();
                for (OrdSaleCouponPO po : couponPOS) {
                    po.setOrderId(orderId);
                    po.setSaleVoucherId(salePO.getSaleVoucherId());
                    po.setId(Long.valueOf(this.sequence.nextId()));
                    saveDate.add(po);
                }
                this.ordSaleCouponMapper.insertBatch(saveDate);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u4f18\u60e0\u52b5\u8868\u6570\u636e\u51fa\u9519");
        }
    }

    private void task(Long pOrderId, Long orderId, OrdSalePO salePO, Long purchaseId) {
        this.startProcess(orderId, UocConstant.OBJ_TYPE.SALE, salePO.getSaleVoucherId(), "UOC", "sales_order_master_order_status:2:313035147457331200");
        this.startProcess(orderId, UocConstant.OBJ_TYPE.PURCHASE, purchaseId, "UOC", "sales_order_master_order_status:2:313035147457331200");
        this.startProcess(orderId, UocConstant.OBJ_TYPE.ORDER, orderId, "UOC", "sales_order_master_order_status:2:313035147457331200");
        this.startProcess(orderId, UocConstant.OBJ_TYPE.ORDER, pOrderId, "UOC", "sales_order_master_order_status:2:313035147457331200");
    }

    private UocProcessStartRspBO startProcess(Long orderId, Integer objType, Long objId, String sysCode, String procId) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        processStartReqBO.setProcDefId(procId);
        processStartReqBO.setSysCode(sysCode);
        processStartReqBO.setOrderId(orderId);
        processStartReqBO.setObjId(objId);
        processStartReqBO.setObjType(objType);
        HashMap map = new HashMap();
        processStartReqBO.setVariables(map);
        UocProcessStartRspBO uocProcessStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(uocProcessStartRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u6279\u91cf\u8ba2\u5355\u521b\u5efa\u670d\u52a1\u5931\u8d25!" + uocProcessStartRspBO.getRespDesc());
        }
        return uocProcessStartRspBO;
    }

    private void payTask(Long orderId, Long saleId) {
        List taskList;
        UocCoreStartProcessRspBO uocCoreStartProcessRspBO;
        UocCoreStartProcessReqBO uocCoreStartProcessReqBO = this.assembleStartProcessParm(orderId, saleId);
        if (IS_DEBUG_ENABLE.booleanValue()) {
            LOG.debug("\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u6d41\u7a0b\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5165\u53c2:" + uocCoreStartProcessReqBO.toString());
        }
        if (!"0000".equals((uocCoreStartProcessRspBO = this.uocCoreStartProcessAtomService.dealCoreStartProcess(uocCoreStartProcessReqBO)).getRespCode())) {
            throw new BusinessException("8888", "\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\uff1a\u542f\u52a8\u6d41\u7a0b\u5931\u8d25" + uocCoreStartProcessRspBO.getRespDesc());
        }
        if (IS_DEBUG_ENABLE.booleanValue()) {
            LOG.debug("\u652f\u4ed8\u6210\u529f\u4e1a\u52a1\u670d\u52a1\u6d41\u7a0b\u542f\u52a8\u539f\u5b50\u670d\u52a1\u51fa\u53c2:" + uocCoreStartProcessRspBO.toString());
        }
        if (!CollectionUtils.isEmpty((Collection)(taskList = uocCoreStartProcessRspBO.getTaskList()))) {
            ArrayList<OrdTaskPO> taskPOList = new ArrayList<OrdTaskPO>();
            ArrayList<OrdTaskCandidatePO> candidatePOS = new ArrayList<OrdTaskCandidatePO>();
            ArrayList<OrdTaskRecordPO> recordPOS = new ArrayList<OrdTaskRecordPO>();
            ArrayList<OrdVoucherProcPO> processPOS = new ArrayList<OrdVoucherProcPO>();
            for (TaskBO taskBO : taskList) {
                OrdTaskPO ordTaskPO = new OrdTaskPO();
                BeanUtils.copyProperties((Object)taskBO, (Object)ordTaskPO);
                ordTaskPO.setOwnOperId(taskBO.getTaskAssignee());
                taskPOList.add(ordTaskPO);
                List candidateIds = taskBO.getCandidateIds();
                OrdTaskRecordPO recordPO = new OrdTaskRecordPO();
                recordPO.setCreateTime(new Date());
                recordPO.setDealCode(taskBO.getTaskAssignee());
                recordPO.setDealDesc(taskBO.getTaskDesc());
                recordPO.setDealCode(taskBO.getBusiCode());
                recordPO.setTaskId(taskBO.getTaskId());
                recordPOS.add(recordPO);
                OrdVoucherProcPO processPO = new OrdVoucherProcPO();
                processPO.setCreateTime(new Date());
                processPO.setObjId(saleId + "");
                processPO.setOrderId(orderId);
                processPO.setProcInstId(taskBO.getTaskId());
                processPOS.add(processPO);
                if (CollectionUtils.isEmpty((Collection)candidateIds)) continue;
                for (String id : candidateIds) {
                    OrdTaskCandidatePO candidatePO = new OrdTaskCandidatePO();
                    candidatePO.setTaskId(taskBO.getTaskId());
                    candidatePO.setOperId(id);
                    candidatePO.setOrderId(orderId);
                    candidatePOS.add(candidatePO);
                }
            }
            try {
                this.ordTaskMapper.insertBatch(taskPOList);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u4efb\u52a1\u5b9e\u4f8b\u8868\u6570\u636e\u51fa\u9519");
            }
            try {
                this.ordTaskCandidateMapper.insertBatch(candidatePOS);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u4efb\u52a1\u5019\u9009\u4eba\u8868\u6570\u636e\u51fa\u9519");
            }
            try {
                this.ordTaskRecordMapper.insertBatch(recordPOS);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u4efb\u52a1\u64cd\u4f5c\u8bb0\u5f55\u8868\u6570\u636e\u51fa\u9519");
            }
            try {
                this.ordVoucherProcMapper.insertBatch(processPOS);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u8ba2\u5355\u62c6\u5206\u8ba2\u5355\u5355\u636e\u6d41\u7a0b\u5b9e\u4f8b\u8868\u6570\u636e\u51fa\u9519");
            }
        }
    }

    private UocCoreStartProcessReqBO assembleStartProcessParm(Long orderId, Long saleVoucherId) {
        OrdSalePO orderSalePo = new OrdSalePO();
        orderSalePo.setOrderId(orderId);
        orderSalePo.setSaleVoucherId(saleVoucherId);
        try {
            orderSalePo = this.ordSaleMapper.getModelBy(orderSalePo);
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
        }
        if (orderSalePo == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230orderId=" + orderId + "\u7684\u9500\u552e\u8ba2\u5355");
        }
        UocCoreStartProcessReqBO uocCoreStartProcessReqBO = new UocCoreStartProcessReqBO();
        uocCoreStartProcessReqBO.setOrderId(orderId);
        switch (Integer.parseInt(orderSalePo.getOrderSource())) {
            case 1: {
                uocCoreStartProcessReqBO.setBusiCode("E-Special-Area");
                break;
            }
            case 2: {
                uocCoreStartProcessReqBO.setBusiCode("Electronic-Supermarket");
                break;
            }
            case 3: {
                uocCoreStartProcessReqBO.setBusiCode("Framework-Agreement");
                break;
            }
            case 4: {
                uocCoreStartProcessReqBO.setBusiCode("A-Single-Mining");
                break;
            }
            default: {
                throw new BusinessException("8888", "\u672a\u77e5\u7684\u8ba2\u5355\u7c7b\u578b!");
            }
        }
        uocCoreStartProcessReqBO.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        uocCoreStartProcessReqBO.setObjId(saleVoucherId);
        return uocCoreStartProcessReqBO;
    }

    private void validateParam(UocShipBusiReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8888", "\u62c6\u5355\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new BusinessException("8888", "\u62c6\u5355\u670d\u52a1\u5165\u53c2orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrdItems()) {
            throw new BusinessException("8888", "\u62c6\u5355\u670d\u52a1\u5165\u53c2ordItems\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

