/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.comb.es.timetask;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.bo.es.ship.UocPebSaleOrderConfirmReqBO;
import com.tydic.order.pec.bo.es.ship.UocPebSaleOrderConfirmRspBO;
import com.tydic.order.pec.busi.es.inspection.UocPebSaleOrderAllConfirmBusiService;
import com.tydic.order.pec.comb.es.order.UocPebOrdIdxSyncCombService;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.pec.comb.es.timetask.UocPebSaleOrderConfirmCombService;
import com.tydic.order.pec.comb.es.timetask.bo.UocPebSaleOrdConfirmReqBO;
import com.tydic.order.pec.comb.es.timetask.bo.UocPebSaleOrdConfirmRspBO;
import com.tydic.order.uoc.atom.order.UocCoreQryOrderListAtomService;
import com.tydic.order.uoc.bo.order.OrderListRspBO;
import com.tydic.order.uoc.bo.order.UocCoreQryOrderListReqBO;
import com.tydic.order.uoc.bo.order.UocCoreQryOrderListRspBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebSaleOrderConfirmCombService")
public class UocPebSaleOrderConfirmCombServiceImpl
implements UocPebSaleOrderConfirmCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebSaleOrderConfirmCombServiceImpl.class);
    private UocPebSaleOrderAllConfirmBusiService uocPebSaleOrderAllConfirmBusiService;
    private UocCoreQryOrderListAtomService uocCoreQryOrderListAtomService;
    private OrdShipMapper ordShipMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${executeDay}")
    private Integer executeDay;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    private static final String ERP = "1";

    @Autowired
    public UocPebSaleOrderConfirmCombServiceImpl(OrdShipMapper ordShipMapper, UocPebSaleOrderAllConfirmBusiService uocPebSaleOrderAllConfirmBusiService, UocCoreQryOrderListAtomService uocCoreQryOrderListAtomService, UocPebOrdIdxSyncCombService uocPebOrdIdxSyncCombService) {
        this.ordShipMapper = ordShipMapper;
        this.uocPebSaleOrderAllConfirmBusiService = uocPebSaleOrderAllConfirmBusiService;
        this.uocCoreQryOrderListAtomService = uocCoreQryOrderListAtomService;
    }

    public UocPebSaleOrdConfirmRspBO dealSaleOrderConfirm(UocPebSaleOrdConfirmReqBO reqBO) {
        this.validateArg(reqBO);
        UocPebSaleOrdConfirmRspBO rspBO = new UocPebSaleOrdConfirmRspBO();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -this.executeDay.intValue());
        Date before7days = calendar.getTime();
        UocCoreQryOrderListReqBO qryOrderReqBO = new UocCoreQryOrderListReqBO();
        qryOrderReqBO.setSupNo(reqBO.getSupId() + "");
        qryOrderReqBO.setSaleState(UocConstant.SALE_ORDER_STATUS.ARRIVED);
        qryOrderReqBO.setOrderSource(UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT + "");
        UocCoreQryOrderListRspBO qryOrderListRspBO = this.uocCoreQryOrderListAtomService.qryCoreQryOrderList(qryOrderReqBO);
        if (!"0000".equals(qryOrderListRspBO.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u4e03\u5929\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:" + qryOrderListRspBO.getRespDesc());
            }
            throw new BusinessException("8888", "\u4e03\u5929\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:" + qryOrderListRspBO.getRespDesc());
        }
        List orderList = qryOrderListRspBO.getRows();
        if (orderList != null && !orderList.isEmpty()) {
            for (OrderListRspBO orderBO : orderList) {
                List ordShipPOS;
                OrdExtMapPO fieldValueBO = new OrdExtMapPO();
                fieldValueBO.setObjType(UocCoreConstant.OBJ_TYPE.CONDITION);
                fieldValueBO.setObjId(orderBO.getOrderId());
                fieldValueBO.setFieldCode("erpOrder");
                fieldValueBO.setOrderId(orderBO.getOrderId());
                List extMapPOS = this.ordExtMapMapper.getList(fieldValueBO);
                boolean flag = false;
                if (CollectionUtils.isNotEmpty((Collection)extMapPOS)) {
                    for (OrdExtMapPO extMapPO : extMapPOS) {
                        if (!ERP.equals(extMapPO.getFieldValue())) continue;
                        flag = true;
                    }
                }
                if (flag) continue;
                OrdShipPO ordShipPO = new OrdShipPO();
                ordShipPO.setOrderId(orderBO.getOrderId());
                try {
                    ordShipPOS = this.ordShipMapper.getList(ordShipPO);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u8ba2\u5355\u4e03\u5929\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1,\u67e5\u8be2\u53d1\u8d27\u5355\u5f02\u5e38" + e.getMessage());
                    }
                    throw new BusinessException("8888", "\u8ba2\u5355\u4e03\u5929\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1,\u67e5\u8be2\u53d1\u8d27\u5355\u5f02\u5e38");
                }
                boolean isAllArrived = true;
                if (ordShipPOS != null && !ordShipPOS.isEmpty()) {
                    for (OrdShipPO shipPO : ordShipPOS) {
                        if ("1203".equals(shipPO.getShipStatus()) || "1205".equals(shipPO.getShipStatus())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("\u9500\u552e\u8ba2\u5355\u53f7\uff1a" + orderBO.getSaleVoucherId() + "\u6240\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u53f7\uff1a" + shipPO.getShipVoucherId() + "\u7684\u72b6\u6001\u4e0d\u4e3a\u5df2\u5230\u8d27\u6216\u5df2\u62d2\u6536\uff0c\u4e0d\u4e88\u8fdb\u884c\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u670d\u52a1");
                        }
                        isAllArrived = false;
                        break;
                    }
                }
                if (!isAllArrived) continue;
                if (orderBO.getSaleExtraMap() == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("\u8ba2\u5355\u8d85\u65f6\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u9500\u552e\u5355\u53f7\uff1a" + orderBO.getSaleVoucherId() + "\u8ba2\u5355\u53f7\uff1a" + orderBO.getOrderId() + "\u5f02\u5e38\u63cf\u8ff0\uff1a\u672a\u8fd4\u56de\u8ba2\u5355\u6269\u5c55\u5c5e\u6027\u96c6\u5408!");
                    continue;
                }
                if (null == orderBO.getSaleExtraMap().get("delieveredTime")) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("\u8ba2\u5355\u8d85\u65f6\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u9500\u552e\u5355\u53f7\uff1a" + orderBO.getSaleVoucherId() + "\u8ba2\u5355\u53f7\uff1a" + orderBO.getOrderId() + "\u5f02\u5e38\u63cf\u8ff0\uff1a\u8fd4\u56de\u8ba2\u5355\u6269\u5c55\u5c5e\u6027\u96c6\u5408\u4e2d\u672a\u5305\u542b\u8ba2\u5355\u59a5\u6295\u65f6\u95f4\u5b57\u6bb5!");
                    continue;
                }
                String delieveredTimeStr = (String)orderBO.getSaleExtraMap().get("delieveredTime");
                Date delieveredTime = DateUtils.strToDateLong((String)delieveredTimeStr);
                if (!before7days.after(delieveredTime)) continue;
                UocPebSaleOrderConfirmReqBO uocPebSaleOrderConfirmReqBO = new UocPebSaleOrderConfirmReqBO();
                uocPebSaleOrderConfirmReqBO.setOrderId(orderBO.getOrderId());
                uocPebSaleOrderConfirmReqBO.setOperId("99999999999");
                UocPebSaleOrderConfirmRspBO confirmRspBO = this.uocPebSaleOrderAllConfirmBusiService.dealUocPebSaleOrderConfirm(uocPebSaleOrderConfirmReqBO);
                if (!"0000".equals(confirmRspBO.getRespCode())) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("\u8ba2\u5355\u8d85\u65f6\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u9500\u552e\u5355\u53f7\uff1a" + orderBO.getSaleVoucherId() + "\u8ba2\u5355\u53f7\uff1a" + orderBO.getOrderId() + "\u5f02\u5e38\u63cf\u8ff0\uff1a" + confirmRspBO.getRespDesc());
                    continue;
                }
                this.syncSaleIndex(orderBO.getOrderId(), orderBO.getSaleVoucherId());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncSaleIndex(Long orderId, Long saleId) {
        UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        uocPebOrdIdxSyncReqBO.setOrderId(orderId);
        uocPebOrdIdxSyncReqBO.setObjId(saleId);
        uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        log.debug("\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u8c03\u7528\u8ba2\u5355\u7d22\u5f15\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + uocPebOrdIdxSyncReqBO.toString());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
    }

    private void validateArg(UocPebSaleOrdConfirmReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("7777", "\u8ba2\u5355\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupId() == null) {
            throw new BusinessException("7777", "\u8ba2\u5355\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010supId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

