/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.order.pec.atom.el.order.bo.QrySaleReqBO;
import com.tydic.order.pec.atom.es.order.UocQrySaleOrderAtomService;
import com.tydic.order.pec.busi.es.order.UocPebOrderCancelBusiService;
import com.tydic.order.pec.busi.es.order.bo.UocPebOrderCancelReqBO;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.order.OrdSaleRspBO;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.utils.ElUtils;
import com.tydic.uac.bo.common.ApprovalObjInfoMQBO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class UocAuditResultDealConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocAuditResultDealConsumer.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocQrySaleOrderAtomService qrySaleOrderAtomService;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u5ba1\u6279\u7ed3\u679c\u5904\u7406\u6d88\u8d39\u8005\u5f00\u59cb\u6267\u884c");
        }
        if (StringUtils.isBlank((CharSequence)proxyMessage.getContent())) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        LOGGER.debug("\u5ba1\u6279\u6d88\u8d39\u5185\u5bb9:" + JSONObject.toJSONString((Object)proxyMessage));
        ApprovalObjInfoMQBO approvalObjInfoMQBO = (ApprovalObjInfoMQBO)JSON.parseObject((String)proxyMessage.getContent(), ApprovalObjInfoMQBO.class);
        List ids = approvalObjInfoMQBO.getObjIdList();
        LOGGER.debug("\u5ba1\u6279\u6d88\u8d39\u5185\u5bb9:" + JSONObject.toJSONString((Object)approvalObjInfoMQBO));
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        for (String id : ids) {
            QrySaleReqBO saleReqBO = new QrySaleReqBO();
            saleReqBO.setOrderId(ElUtils.string2Long((String)id));
            OrdSaleRspBO saleRspBO = this.qrySaleOrderAtomService.qry(saleReqBO);
            if (approvalObjInfoMQBO.getAuditResult().equals("0")) {
                this.run(saleRspBO, approvalObjInfoMQBO);
            } else {
                UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
                cancelReqBO.setOrderId(saleRspBO.getOrderId());
                cancelReqBO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
                cancelReqBO.setPurchaseVoucherId(saleRspBO.getPurchaseVoucherId());
                cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("approvalResult", "0");
                cancelReqBO.setVariables(map);
                this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
            }
            this.uocPebOrdIdxSync(saleRspBO);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void run(OrdSaleRspBO saleRspBO, ApprovalObjInfoMQBO approvalObjInfoMQBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(saleRspBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(saleRspBO.getOrderId());
        processRunReqBO.setOperId(approvalObjInfoMQBO.getOperId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("approvalResult", "1");
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if ("0000".equals(uocProcessRunRspBO.getRespCode())) {
            // empty if block
        }
    }

    private void uocPebOrdIdxSync(OrdSaleRspBO rspBO) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(rspBO.getSaleVoucherId());
        reqBO.setOrderId(rspBO.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }
}

