/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.ability.impl.order;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.ability.order.PebAfterSalesServiceApprovalAbilityService;
import com.tydic.order.pec.bo.order.PebAfterSalesServiceApprovalReqBO;
import com.tydic.order.pec.bo.order.PebAfterSalesServiceApprovalRspBO;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.pec.busi.order.PebAfterSalesServiceApprovalBusiService;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UOC_GROUP", interfaceClass=PebAfterSalesServiceApprovalAbilityService.class)
public class PebAfterSalesServiceApprovalAbilityServiceImpl
implements PebAfterSalesServiceApprovalAbilityService {
    @Autowired
    PebAfterSalesServiceApprovalBusiService pebAfterSalesServiceApprovalBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    public PebAfterSalesServiceApprovalRspBO dealPebAfterSalesServiceApproval(PebAfterSalesServiceApprovalReqBO reqBO) {
        PebAfterSalesServiceApprovalRspBO rspBO;
        this.validateParams(reqBO);
        if (StringUtils.isBlank((CharSequence)reqBO.getActionCode())) {
            reqBO.setActionCode("ACTPEB015");
        }
        if ("0000".equals((rspBO = this.pebAfterSalesServiceApprovalBusiService.dealPebAfterSalesServiceApproval(reqBO)).getRespCode())) {
            this.idxSync(reqBO);
            this.dealEsOrderList(rspBO);
            this.dealEsInspectionList(rspBO);
        }
        return rspBO;
    }

    private void idxSync(PebAfterSalesServiceApprovalReqBO reqBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getAfterServId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void dealEsOrderList(PebAfterSalesServiceApprovalRspBO rspBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(rspBO.getOrderId());
        uocOrdIdxSyncReqBO.setObjId(rspBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void dealEsInspectionList(PebAfterSalesServiceApprovalRspBO rspBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(rspBO.getOrderId());
        uocOrdIdxSyncReqBO.setObjId(rspBO.getInspectionVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void validateParams(PebAfterSalesServiceApprovalReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279API\u5165\u53c2\u3010bo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAuditResult() == null) {
            throw new BusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.PASS) && !reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.NO_PASS)) {
            throw new BusinessException("0002", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u7c7b\u578b\u9519\u8bef");
        }
        if (reqBO.getAfterServId() == null) {
            throw new BusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u552e\u540e\u5355id\u3010afterServId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new BusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u8ba2\u5355id\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

