/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.ability.impl.order;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.ability.order.PebOrderAllocationAbilityService;
import com.tydic.order.pec.bo.el.common.UocGeneralCirculationReqBO;
import com.tydic.order.pec.bo.order.PebOrderAllocationReqBO;
import com.tydic.order.pec.bo.order.PebOrderAllocationRspBO;
import com.tydic.order.pec.bo.order.UocPebDealOrderBO;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.pec.busi.order.PebOrderAllocationBusiService;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocConstant;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UOC_GROUP", interfaceClass=PebOrderAllocationAbilityService.class)
public class PebOrderAllocationAbilityServiceImpl
implements PebOrderAllocationAbilityService {
    @Autowired
    private PebOrderAllocationBusiService pebOrderAllocationBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Resource(name="dealZoneDealAutomaticTaskMsgProvider")
    private ProxyMessageProducer dealZoneDealAutomaticTaskMsgProvider;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TOPIC}")
    private String taskTopic;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TAG}")
    private String taskTag;

    public PebOrderAllocationRspBO dealPebOrderAllocation(PebOrderAllocationReqBO reqBO) {
        this.val(reqBO);
        PebOrderAllocationRspBO rspBO = this.pebOrderAllocationBusiService.dealPebOrderAllocation(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            for (UocPebDealOrderBO pebDealOrderBO : rspBO.getOrderAssignList()) {
                this.syncIndex(pebDealOrderBO);
                this.sendAutoMsg(pebDealOrderBO);
            }
        }
        return rspBO;
    }

    private void syncIndex(UocPebDealOrderBO pebDealOrderBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdIdxSyncReqBO.setOrderId(pebDealOrderBO.getOrderId());
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void sendAutoMsg(UocPebDealOrderBO pebDealOrderBO) {
        if (pebDealOrderBO.getAuto().booleanValue()) {
            UocGeneralCirculationReqBO circulationReqBO = new UocGeneralCirculationReqBO();
            circulationReqBO.setActionCode("ACTPEB020");
            circulationReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
            circulationReqBO.setOrderId(pebDealOrderBO.getOrderId());
            circulationReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.dealZoneDealAutomaticTaskMsgProvider.send(new ProxyMessage(this.taskTopic, this.taskTag, JSONObject.toJSONString((Object)circulationReqBO)));
        }
    }

    private void val(PebOrderAllocationReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderAssignList())) {
            throw new BusinessException("0001", "\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDeliveryId() == null) {
            throw new BusinessException("0001", "deliveryId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

