/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.atom;

import com.alibaba.fastjson.JSON;
import com.tydic.order.pec.atom.PebTheOrderRemindAtomService;
import com.tydic.order.pec.atom.bo.PebTheOrderRemindAtomReqBO;
import com.tydic.order.pec.atom.bo.PebTheOrderRemindAtomRspBO;
import com.tydic.order.third.intf.ability.notify.PebIntfSmsAbilityService;
import com.tydic.order.third.intf.ability.notify.PebTheOrderRemindAbilityService;
import com.tydic.order.third.intf.bo.notify.HaiLiangBO;
import com.tydic.order.third.intf.bo.notify.PebIntfSmsReqBO;
import com.tydic.order.third.intf.bo.notify.PebIntfSmsRspBO;
import com.tydic.order.third.intf.bo.notify.PebTheOrderRemindReqBO;
import com.tydic.order.third.intf.bo.notify.PebTheOrderRemindRspBO;
import com.tydic.order.third.intf.bo.notify.RongLianYTXBO;
import com.tydic.order.third.intf.constant.CommonConstant;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.dao.OrdRemindLogMapper;
import com.tydic.order.uoc.dao.po.OrdRemindLogPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="pebTheOrderRemindAtomService")
public class PebTheOrderRemindAtomServiceImpl
implements PebTheOrderRemindAtomService {
    @Autowired
    PebTheOrderRemindAbilityService pebTheOrderRemindAbilityService;
    @Autowired
    private PebIntfSmsAbilityService pebIntfSmsAbilityService;
    @Autowired
    OrdRemindLogMapper ordRemindLogMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Value(value="${IS_ENABLE_SMS:false}")
    private Boolean isEnableSMS;
    @Value(value="${sms.type:1}")
    private String smsType;

    public PebTheOrderRemindAtomRspBO dealPebTheOrderRemind(PebTheOrderRemindAtomReqBO reqBO) {
        this.validateParams(reqBO);
        PebTheOrderRemindAtomRspBO rspBO = new PebTheOrderRemindAtomRspBO();
        Integer sendType = reqBO.getSendType();
        return this.sendRemind(reqBO);
    }

    private void validateParams(PebTheOrderRemindAtomReqBO reqBO) {
        Integer sendType = reqBO.getSendType();
        String templateId = reqBO.getTemplateId();
        Map templateParam = reqBO.getTemplateParam();
        if (null == reqBO.getOrderId()) {
            throw new BusinessException("7777", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Boolean insertRemindLog(PebTheOrderRemindAtomReqBO reqBO, boolean isSendSuccess, PebTheOrderRemindAtomRspBO rspBO) {
        boolean isRecordSuccess = true;
        OrdRemindLogPO ordRemindLogPO = new OrdRemindLogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)ordRemindLogPO);
        ordRemindLogPO.setCreateTime(new Date());
        ordRemindLogPO.setMsgParam(JSON.toJSONString((Object)reqBO.getTemplateParam()));
        ordRemindLogPO.setTemplateId(reqBO.getTemplateId());
        ordRemindLogPO.setMemId(String.valueOf(reqBO.getUserId()));
        ordRemindLogPO.setId(Long.valueOf(this.sequence.nextId()));
        if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_EMIL)) {
            ordRemindLogPO.setReceiveRole(reqBO.getEmail());
        }
        if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_MOBILE)) {
            ordRemindLogPO.setReceiveRole(reqBO.getMobile());
        }
        if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_MESSAGE)) {
            ordRemindLogPO.setReceiveRole(reqBO.getReceiveId().toString());
        }
        if (isSendSuccess) {
            ordRemindLogPO.setStatus("1");
            try {
                this.ordRemindLogMapper.insert(ordRemindLogPO);
            }
            catch (Exception e) {
                rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u6210\u529f,\u63d2\u5165\u65e5\u5fd7\u5931\u8d25");
                rspBO.setRespCode("8888");
                isRecordSuccess = false;
            }
        } else {
            ordRemindLogPO.setStatus("0");
            try {
                this.ordRemindLogMapper.insert(ordRemindLogPO);
            }
            catch (Exception e) {
                rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u5931\u8d25,\u63d2\u5165\u65e5\u5fd7\u5931\u8d25");
                rspBO.setRespCode("8888");
                isRecordSuccess = false;
            }
        }
        return isRecordSuccess;
    }

    private PebTheOrderRemindAtomRspBO sendSMS(PebTheOrderRemindAtomReqBO reqBO) {
        PebTheOrderRemindAtomRspBO rspBO = new PebTheOrderRemindAtomRspBO();
        PebIntfSmsReqBO pebIntfSmsReqBO = new PebIntfSmsReqBO();
        pebIntfSmsReqBO.setMobile(reqBO.getMobile());
        pebIntfSmsReqBO.setContent(reqBO.getContent());
        PebIntfSmsRspBO pebIntfSmsRspBO = this.pebIntfSmsAbilityService.sendMsg(pebIntfSmsReqBO);
        if (pebIntfSmsRspBO.getRespCode().equals("0000")) {
            Boolean isRecordSuccess = this.insertRemindLog(reqBO, true, rspBO);
            if (!isRecordSuccess.booleanValue()) {
                return rspBO;
            }
            rspBO.setRespDesc(pebIntfSmsRspBO.getRespDesc());
            rspBO.setRespCode(pebIntfSmsRspBO.getRespCode());
        } else {
            Boolean isRecordSuccess = this.insertRemindLog(reqBO, false, rspBO);
            if (!isRecordSuccess.booleanValue()) {
                return rspBO;
            }
            rspBO.setRespDesc(pebIntfSmsRspBO.getRespDesc());
            rspBO.setRespCode(pebIntfSmsRspBO.getRespCode());
        }
        return rspBO;
    }

    private PebTheOrderRemindAtomRspBO sendRemind(PebTheOrderRemindAtomReqBO reqBO) {
        Boolean isRecordSuccess;
        PebTheOrderRemindAtomRspBO rspBO = new PebTheOrderRemindAtomRspBO();
        PebTheOrderRemindReqBO pebTheOrderRemindReqBO = new PebTheOrderRemindReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)pebTheOrderRemindReqBO);
        if ("1".equals(this.smsType) && reqBO.getSendType().equals(CommonConstant.ORDER_SEND_MOBILE)) {
            RongLianYTXBO lianYTXBO = new RongLianYTXBO();
            if (reqBO.getTemplateParam() != null) {
                String[] data = new String[reqBO.getTemplateParam().size()];
                int i = 0;
                for (String key : reqBO.getTemplateParam().keySet()) {
                    data[i] = String.valueOf(reqBO.getTemplateParam().get(key));
                    ++i;
                }
                lianYTXBO.setDatas(data);
            }
            lianYTXBO.setMobiles(reqBO.getMobile());
            lianYTXBO.setTemplateId(reqBO.getTemplateId());
            pebTheOrderRemindReqBO.setRongLianYTXBO(lianYTXBO);
        } else if ("2".equals(this.smsType) && reqBO.getSendType().equals(CommonConstant.ORDER_SEND_MOBILE)) {
            HaiLiangBO haiLiangBO = new HaiLiangBO();
            haiLiangBO.setMobile(reqBO.getMobile());
            haiLiangBO.setContent(reqBO.getContent());
            pebTheOrderRemindReqBO.setHaiLiangBO(haiLiangBO);
        }
        pebTheOrderRemindReqBO.setSubject(reqBO.getSubject());
        pebTheOrderRemindReqBO.setText(reqBO.getContent());
        pebTheOrderRemindReqBO.setEmail(reqBO.getEmail());
        PebTheOrderRemindRspBO pebTheOrderRemindRspBO = this.pebTheOrderRemindAbilityService.dealPebTheOrderRemind(pebTheOrderRemindReqBO);
        if (pebTheOrderRemindRspBO.getRespCode().equals("0000")) {
            isRecordSuccess = this.insertRemindLog(reqBO, true, rspBO);
            if (!isRecordSuccess.booleanValue()) {
                return rspBO;
            }
            rspBO.setRespDesc(pebTheOrderRemindRspBO.getRespDesc());
            rspBO.setRespCode(pebTheOrderRemindRspBO.getRespCode());
        } else {
            isRecordSuccess = this.insertRemindLog(reqBO, false, rspBO);
            if (!isRecordSuccess.booleanValue()) {
                return rspBO;
            }
            rspBO.setRespDesc(pebTheOrderRemindRspBO.getRespDesc());
            rspBO.setRespCode(pebTheOrderRemindRspBO.getRespCode());
        }
        return rspBO;
    }
}

