/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.el.order;

import com.tydic.order.pec.atom.el.authority.PebOperationPermissionsCheckingAtomService;
import com.tydic.order.pec.atom.el.authority.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.order.pec.atom.el.authority.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.order.pec.bo.el.common.UocPebOrderRegistReqBO;
import com.tydic.order.pec.bo.el.common.UocPebOrderRegistRspBO;
import com.tydic.order.pec.bo.el.order.UocPebAccessoryBO;
import com.tydic.order.pec.busi.el.order.UocPebOrderRegistBusiService;
import com.tydic.order.pec.busi.el.order.bo.UocPebArrRegisterShipIReqBO;
import com.tydic.order.pec.busi.el.order.bo.UocPebArrRegisterShipItemReqBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.pec.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.pec.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.pec.dic.bo.SelectSingleDictRspBO;
import com.tydic.order.uoc.atom.afterservice.UocCoreArriveRegistAtomService;
import com.tydic.order.uoc.atom.core.UocCoreBusiOperRecordAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreBusiOperRecordReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreBusiOperRecordRspBO;
import com.tydic.order.uoc.atom.order.UocCoreStateCheckAtomService;
import com.tydic.order.uoc.atom.other.UocCoreCreateAccessoryAtomService;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.afterservice.ArriveInfoBO;
import com.tydic.order.uoc.bo.afterservice.UocCoreArriveRegistReqBO;
import com.tydic.order.uoc.bo.afterservice.UocCoreArriveRegistRspBO;
import com.tydic.order.uoc.bo.order.UocCoreStateCheckAtomReqBO;
import com.tydic.order.uoc.bo.order.UocCoreStateCheckAtomRspBO;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryReqBO;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryRspBO;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocPebOrderRegistBusiServiceImpl
implements UocPebOrderRegistBusiService {
    private static final Integer ALL_ARRIVAL = 1;
    private static final Integer PART_ARRIVAL = 0;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private UocCoreArriveRegistAtomService uocCoreArriveRegistAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;

    public UocPebOrderRegistRspBO dealPebOrderRegist(UocPebOrderRegistReqBO reqBO) {
        if (reqBO.getEntireFlag() == null) {
            reqBO.setEntireFlag(PART_ARRIVAL);
        }
        this.doStateCheck(reqBO);
        this.checkAuthority(reqBO);
        this.registArrivals(reqBO);
        this.doBusiOperRecord(reqBO);
        UocPebOrderRegistRspBO rspBO = new UocPebOrderRegistRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5230\u8d27\u767b\u8bb0\u6210\u529f");
        return rspBO;
    }

    private void checkAuthority(UocPebOrderRegistReqBO reqBO) {
        if (!PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO permissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)permissionsCheckingAtomReqBO);
            PebOperationPermissionsCheckingAtomRspBO permissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(permissionsCheckingAtomReqBO);
            if (!"0000".equals(permissionsCheckingAtomRspBO.getRespCode())) {
                throw new BusinessException("0100", permissionsCheckingAtomRspBO.getRespDesc());
            }
        }
    }

    private void registArrivals(UocPebOrderRegistReqBO reqBO) {
        if (ALL_ARRIVAL.equals(reqBO.getEntireFlag())) {
            this.doBuildArrivalReqInfo(reqBO);
            HashMap map = new HashMap(1);
            map.put("arriveFlag", "2");
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, reqBO.getSaleVourcherId(), map);
        } else {
            for (UocPebArrRegisterShipIReqBO shipIReqBO : reqBO.getArrRegisterItemList()) {
                ArrayList<ArriveInfoBO> arriveInfoList = new ArrayList<ArriveInfoBO>();
                for (UocPebArrRegisterShipItemReqBO shipItemReqBO : shipIReqBO.getUocPebArrRegisterShipItemReqBOList()) {
                    if (!ALL_ARRIVAL.equals(reqBO.getEntireFlag())) {
                        BigDecimal alreadyArriveCount;
                        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
                        ordShipItemPO.setShipItemId(shipItemReqBO.getShipItemId());
                        ordShipItemPO = this.ordShipItemMapper.getModelBy(ordShipItemPO);
                        if (ordShipItemPO == null) {
                            throw new BusinessException("0100", "\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u660e\u7ec6\u4fe1\u606f\u3010" + shipItemReqBO.getShipItemId() + "\u3011");
                        }
                        BigDecimal sendCount = ordShipItemPO.getSendCount();
                        if (sendCount.compareTo(alreadyArriveCount = ordShipItemPO.getArriveCount().add(ordShipItemPO.getRefuseCount())) < 0) {
                            throw new BusinessException("0100", "\u5f53\u524d\u5230\u8d27\u767b\u8bb0\u603b\u6570\u91cf\u5df2\u8d85\u51fa\u603b\u53d1\u8d27\u6570\u91cf");
                        }
                    }
                    ArriveInfoBO arriveInfoBO = new ArriveInfoBO();
                    BeanUtils.copyProperties((Object)shipItemReqBO, (Object)arriveInfoBO);
                    arriveInfoBO.setArriveCount(shipItemReqBO.getArriveCount());
                    arriveInfoList.add(arriveInfoBO);
                }
                this.doCallCoreArrivalAtom(reqBO, shipIReqBO.getShipVoucherId(), arriveInfoList);
                this.doUpdateShipArriveTime(reqBO.getOrderId(), shipIReqBO.getShipVoucherId());
                this.doCreateAccessory(reqBO, shipIReqBO.getShipVoucherId());
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                map.put("arriveFlag", "1");
                this.run(reqBO, UocConstant.OBJ_TYPE.SHIP, shipIReqBO.getShipVoucherId(), map);
            }
        }
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setOrderId(reqBO.getOrderId());
        ordShipPO.setSaleVoucherId(reqBO.getSaleVourcherId());
        List ordShipPOList = this.ordShipMapper.getList(ordShipPO);
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(itemPO);
        boolean isAllShip = true;
        for (OrdItemPO po : itemPOS) {
            if (po.getSendCount().compareTo(po.getPurchaseCount()) >= 0) continue;
            isAllShip = false;
            break;
        }
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        for (OrdShipPO shipPO : ordShipPOList) {
            if (!"2202".equals(shipPO.getShipStatus())) continue;
            map.put("arriveFlag", "0");
            if (UocConstant.SALE_ORDER_STATUS.ZONE_ARRIVED_PART.equals(ordSalePO.getSaleState())) continue;
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, reqBO.getSaleVourcherId(), map);
            return;
        }
        if (!isAllShip) {
            map.put("arriveFlag", "0");
            if (UocConstant.SALE_ORDER_STATUS.ZONE_ARRIVED_PART.equals(ordSalePO.getSaleState())) {
                return;
            }
        } else {
            map.put("arriveFlag", "2");
        }
        this.run(reqBO, UocConstant.OBJ_TYPE.SALE, reqBO.getSaleVourcherId(), map);
    }

    private void doBuildArrivalReqInfo(UocPebOrderRegistReqBO reqBO) {
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setOrderId(reqBO.getOrderId());
        ordShipPO.setSaleVoucherId(reqBO.getSaleVourcherId());
        List ordShipPOList = this.ordShipMapper.getList(ordShipPO);
        if (CollectionUtils.isEmpty((Collection)ordShipPOList)) {
            throw new BusinessException("8888", "\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u8be5\u8ba2\u5355\u4e0b\u65e0\u53d1\u8d27\u5355");
        }
        ArrayList<UocPebArrRegisterShipIReqBO> arrRegisterItemList = new ArrayList<UocPebArrRegisterShipIReqBO>(ordShipPOList.size());
        reqBO.setArrRegisterItemList(arrRegisterItemList);
        for (OrdShipPO shipPO : ordShipPOList) {
            UocPebArrRegisterShipIReqBO uocPebArrRegisterShipIReqBO = new UocPebArrRegisterShipIReqBO();
            arrRegisterItemList.add(uocPebArrRegisterShipIReqBO);
            uocPebArrRegisterShipIReqBO.setShipVoucherId(shipPO.getShipVoucherId());
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setOrderId(reqBO.getOrderId());
            ordShipItemPO.setShipVoucherId(shipPO.getShipVoucherId());
            List ordShipItemPOList = this.ordShipItemMapper.getList(ordShipItemPO);
            if (!CollectionUtils.isEmpty((Collection)ordShipItemPOList)) {
                ArrayList<UocPebArrRegisterShipItemReqBO> uocPebArrRegisterShipItemReqBOList = new ArrayList<UocPebArrRegisterShipItemReqBO>(ordShipItemPOList.size());
                uocPebArrRegisterShipIReqBO.setUocPebArrRegisterShipItemReqBOList(uocPebArrRegisterShipItemReqBOList);
                for (OrdShipItemPO shipItemPO : ordShipItemPOList) {
                    UocPebArrRegisterShipItemReqBO uocPebArrRegisterShipItemReqBO = new UocPebArrRegisterShipItemReqBO();
                    uocPebArrRegisterShipItemReqBO.setShipItemId(shipItemPO.getShipItemId());
                    uocPebArrRegisterShipItemReqBO.setArriveCount(shipItemPO.getSendCount());
                    uocPebArrRegisterShipItemReqBOList.add(uocPebArrRegisterShipItemReqBO);
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("arriveFlag", "1");
            this.run(reqBO, UocConstant.OBJ_TYPE.SHIP, shipPO.getShipVoucherId(), map);
        }
    }

    private void doCallCoreArrivalAtom(UocPebOrderRegistReqBO reqBO, Long shipVoucherId, List<ArriveInfoBO> arriveInfoList) {
        UocCoreArriveRegistReqBO registAtomReqBO = new UocCoreArriveRegistReqBO();
        registAtomReqBO.setOrderId(reqBO.getOrderId());
        registAtomReqBO.setShipVoucherId(shipVoucherId);
        registAtomReqBO.setCreateOperId(reqBO.getUserId() + "");
        registAtomReqBO.setArriveInfoList(arriveInfoList);
        registAtomReqBO.setCheckFlag(Integer.valueOf(1));
        UocCoreArriveRegistRspBO arriveRegistRspBO = this.uocCoreArriveRegistAtomService.dealCoreArriveRegist(registAtomReqBO);
        if (!"0000".equals(arriveRegistRspBO.getRespCode())) {
            throw new BusinessException("0100", "\u8c03\u7528\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + arriveRegistRspBO.getRespDesc());
        }
    }

    private void doUpdateShipArriveTime(Long orderId, Long shipVoucherId) {
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setArriveTime(new Date());
        ordShipModel.setShipVoucherId(shipVoucherId);
        ordShipModel.setOrderId(orderId);
        int updateArriveTimeResult = this.ordShipMapper.updateById(ordShipModel);
        if (updateArriveTimeResult != 1) {
            throw new BusinessException("0100", "\u66f4\u65b0\u5230\u8d27\u65f6\u95f4\u5931\u8d25!");
        }
    }

    private void doCreateAccessory(UocPebOrderRegistReqBO reqBO, Long shipVoucherId) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            for (UocPebAccessoryBO accessoryBO : reqBO.getAccessoryList()) {
                UocCoreCreateAccessoryReqBO createAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                createAccessoryReqBO.setAccessoryId(accessoryBO.getAccessoryId());
                createAccessoryReqBO.setAccessoryName(accessoryBO.getAccessoryName());
                createAccessoryReqBO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
                createAccessoryReqBO.setAttachmentType(accessoryBO.getAttachmentType());
                createAccessoryReqBO.setOrderId(reqBO.getOrderId());
                createAccessoryReqBO.setObjectId(shipVoucherId);
                createAccessoryReqBO.setObjectType(UocCoreConstant.OBJ_TYPE.SHIP);
                createAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO createAccessoryRspBO = this.uocCoreCreateAccessoryAtomService.createAccessory(createAccessoryReqBO);
                if ("0000".equals(createAccessoryRspBO.getRespCode())) continue;
                throw new BusinessException("0100", createAccessoryRspBO.getRespDesc());
            }
        }
    }

    private void doBusiOperRecord(UocPebOrderRegistReqBO reqBO) {
        UocCoreBusiOperRecordRspBO busiOperRecordRspBO;
        UocCoreBusiOperRecordReqBO operRecordReqBO = new UocCoreBusiOperRecordReqBO();
        operRecordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
        operRecordReqBO.setOrderId(reqBO.getOrderId());
        operRecordReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        operRecordReqBO.setObjId(reqBO.getSaleVourcherId());
        operRecordReqBO.setDealCode(StringUtils.isEmpty((Object)reqBO.getActionCode()) ? "ACTPEB004" : reqBO.getActionCode());
        operRecordReqBO.setDealReason("\u5230\u8d27\u767b\u8bb0");
        operRecordReqBO.setDealOperId(String.valueOf(reqBO.getUserId()));
        operRecordReqBO.setDealOperName(reqBO.getUsername());
        operRecordReqBO.setCreateTime(new Date());
        operRecordReqBO.setDealDeptId(String.valueOf(reqBO.getOrgId()));
        operRecordReqBO.setDealDeptName(reqBO.getOrgName());
        operRecordReqBO.setDealPostId(String.valueOf(reqBO.getOrgId()));
        operRecordReqBO.setDealPostName(reqBO.getOrgName());
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(operRecordReqBO.getDealCode());
        dictReqBO.setPcode("ACTION_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (dictRspBO != null && dictRspBO.getDicDictionarys() != null) {
            String describe = dictRspBO.getDicDictionarys().getDescrip();
            operRecordReqBO.setDealName(describe);
            operRecordReqBO.setDealTypeName(describe);
            operRecordReqBO.setDealDesc(describe);
        }
        if (!"0000".equals((busiOperRecordRspBO = this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(operRecordReqBO)).getRespCode())) {
            throw new BusinessException("0100", "\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + busiOperRecordRspBO.getRespDesc());
        }
    }

    private void doStateCheck(UocPebOrderRegistReqBO reqBO) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getSaleVourcherId());
        uocCoreStateCheckAtomReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new BusinessException("0100", "\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u8c03\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreStateCheck.getRespDesc());
        }
    }

    private void run(UocPebOrderRegistReqBO reqBO, Integer objType, Long objId, Map<String, Object> map) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }
}

