/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.other;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.order.pec.bo.other.UocGeneralReasonQueryReqBO;
import com.tydic.order.pec.bo.other.UocGeneralReasonQueryRspBO;
import com.tydic.order.pec.bo.other.UocOrdAccessoryRspBO;
import com.tydic.order.pec.busi.other.UocGeneralReasonQueryBusiService;
import com.tydic.order.pec.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.pec.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.pec.dic.bo.SelectSingleDictRspBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdAccessoryMapper;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdAccessoryPO;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocGeneralReasonQueryBusiService")
public class UocGeneralReasonQueryBusiServiceImpl
implements UocGeneralReasonQueryBusiService {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;

    public UocGeneralReasonQueryRspBO getUocGeneralReasonQuery(UocGeneralReasonQueryReqBO reqBO) {
        UocGeneralReasonQueryRspBO rspBO = new UocGeneralReasonQueryRspBO();
        this.validateParams(reqBO);
        if (UocCoreConstant.OBJ_TYPE.ORDER.equals(reqBO.getObjType()) || UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
            rspBO = this.qryOrderOrSale(reqBO);
        } else if (UocCoreConstant.OBJ_TYPE.AFTER_SERVICE.equals(reqBO.getObjType())) {
            rspBO = this.qryAfterService(reqBO);
        } else if (UocCoreConstant.OBJ_TYPE.PURCHASE.equals(reqBO.getObjType())) {
            reqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            rspBO = this.qryOrderOrSale(reqBO);
        }
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setObjectType(reqBO.getObjType());
        ordAccessoryPO.setOrderId(reqBO.getOrderId());
        ordAccessoryPO.setObjectId(reqBO.getObjId());
        ordAccessoryPO.setRemark(reqBO.getActionCode());
        ArrayList<UocOrdAccessoryRspBO> orderAccessoryList = new ArrayList<UocOrdAccessoryRspBO>();
        List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
        if (CollectionUtils.isNotEmpty((Collection)ordAccessoryPOList)) {
            for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
                UocOrdAccessoryRspBO ordAccessoryRspBO = new UocOrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)accessoryPO, (Object)ordAccessoryRspBO);
                orderAccessoryList.add(ordAccessoryRspBO);
            }
        }
        rspBO.setOrderAccessoryList(orderAccessoryList);
        return rspBO;
    }

    private void validateParams(UocGeneralReasonQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("0001", "\u901a\u7528\u539f\u56e0\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new BusinessException("0001", "\u901a\u7528\u539f\u56e0\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new BusinessException("0002", "\u901a\u7528\u539f\u56e0\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getOrderId()) {
            throw new BusinessException("0001", "\u901a\u7528\u539f\u56e0\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getObjId()) {
            throw new BusinessException("0002", "\u901a\u7528\u539f\u56e0\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getObjType()) {
            throw new BusinessException("0001", "\u901a\u7528\u539f\u56e0\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u7c7b\u578b\u3010objType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getQueryType()) {
            throw new BusinessException("0001", "\u901a\u7528\u539f\u56e0\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u67e5\u8be2\u7c7b\u578b\u3010queryType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocGeneralReasonQueryRspBO qryOrderOrSale(UocGeneralReasonQueryReqBO reqBO) {
        SelectSingleDictRspBO dictRspBO;
        SelectSingleDictReqBO dictReqBO;
        UocGeneralReasonQueryRspBO rspBO = new UocGeneralReasonQueryRspBO();
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (null == orderPO) {
            rspBO.setRespCode("0200");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u53d6\u6d88\u539f\u56e0\uff1a" + reqBO.getOrderId());
            return rspBO;
        }
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setOrderId(reqBO.getOrderId());
        ordExtMapPO.setFieldCode("del_type");
        List extMapPOList = this.ordExtMapMapper.getList(ordExtMapPO);
        if (CollectionUtils.isNotEmpty((Collection)extMapPOList)) {
            dictReqBO = new SelectSingleDictReqBO();
            dictReqBO.setCode(((OrdExtMapPO)extMapPOList.get(extMapPOList.size() - 1)).getFieldValue() + "");
            dictReqBO.setPcode("ORDER_CANCLE_TYPE");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                rspBO.setOrderCancleType(dictRspBO.getDicDictionarys().getDescrip());
            }
        }
        if (UocCoreConstant.QUERY_TYPE.CANCEL.equals(reqBO.getQueryType())) {
            rspBO.setQueryCauseTime(DateUtils.dateToStrLong((Date)orderPO.getCancelTime()));
            rspBO.setQueryCauseOperId(orderPO.getCancelOperId());
            rspBO.setQueryCauseOperator(orderPO.getCancelOperId());
            rspBO.setQueryCauseTypeStr("\u53d6\u6d88");
            rspBO.setQueryCauseResult(orderPO.getCancelReason());
            rspBO.setQueryCauseDesc(orderPO.getCancelDesc());
        } else if (UocCoreConstant.QUERY_TYPE.REFUSE.equals(reqBO.getQueryType())) {
            rspBO.setQueryCauseTime(DateUtils.dateToStrLong((Date)orderPO.getCancelTime()));
            rspBO.setQueryCauseOperId(orderPO.getCancelOperId());
            rspBO.setQueryCauseOperator(orderPO.getCancelOperId());
            rspBO.setQueryCauseTypeStr("\u62d2\u7edd");
            rspBO.setQueryCauseResult(orderPO.getCancelReason());
            dictReqBO = new SelectSingleDictReqBO();
            dictReqBO.setCode(orderPO.getCancelDesc() + "");
            dictReqBO.setPcode("ORDER_CANCLE_TYPE");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                rspBO.setQueryCauseDesc(dictRspBO.getDicDictionarys().getDescrip());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UocGeneralReasonQueryRspBO qryAfterService(UocGeneralReasonQueryReqBO reqBO) {
        UocGeneralReasonQueryRspBO rspBO = new UocGeneralReasonQueryRspBO();
        OrdAfterServicePO afterServicePO = new OrdAfterServicePO();
        afterServicePO.setOrderId(reqBO.getOrderId());
        afterServicePO.setAfterServId(reqBO.getObjId());
        OrdAfterServicePO ordAfterServicePO = this.ordAfterServiceMapper.getModelBy(afterServicePO);
        if (null == ordAfterServicePO) {
            rspBO.setRespCode("0200");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u552e\u540e\u5355\u539f\u56e0\uff1a" + reqBO.getOrderId());
            return rspBO;
        }
        if (UocCoreConstant.QUERY_TYPE.CANCEL.equals(reqBO.getQueryType())) {
            rspBO.setQueryCauseTime(DateUtils.dateToStrLong((Date)ordAfterServicePO.getCancelTime()));
            rspBO.setQueryCauseOperId(ordAfterServicePO.getCancelOperId());
            rspBO.setQueryCauseOperator(ordAfterServicePO.getCancelOperName());
            rspBO.setQueryCauseTypeStr("\u53d6\u6d88");
            if (StringUtils.isNotBlank((CharSequence)ordAfterServicePO.getCancelReason())) {
                rspBO.setQueryCauseResult(ordAfterServicePO.getCancelReason());
            } else if (StringUtils.isNotBlank((CharSequence)ordAfterServicePO.getReturnReason())) {
                rspBO.setQueryCauseResult(ordAfterServicePO.getReturnReason());
            }
            rspBO.setQueryCauseDesc(ordAfterServicePO.getQuestionDesc());
        } else if (UocCoreConstant.QUERY_TYPE.REFUSE.equals(reqBO.getQueryType())) {
            rspBO.setQueryCauseTime(DateUtils.dateToStrLong((Date)ordAfterServicePO.getCancelTime()));
            rspBO.setQueryCauseOperId(ordAfterServicePO.getCancelOperId());
            rspBO.setQueryCauseOperator(ordAfterServicePO.getCancelOperName());
            rspBO.setQueryCauseTypeStr("\u62d2\u7edd");
            if (StringUtils.isNotBlank((CharSequence)ordAfterServicePO.getReturnReason())) {
                rspBO.setQueryCauseResult(ordAfterServicePO.getReturnReason());
            } else if (StringUtils.isNotBlank((CharSequence)ordAfterServicePO.getCancelReason())) {
                rspBO.setQueryCauseResult(ordAfterServicePO.getCancelReason());
            }
            rspBO.setQueryCauseDesc(ordAfterServicePO.getQuestionDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

