/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.comb.afterservice;

import com.alibaba.fastjson.JSON;
import com.tydic.order.pec.bo.afterservice.UocAfterSalesDetailsListQueryReqBO;
import com.tydic.order.pec.bo.afterservice.UocAfterSalesDetailsListQueryRspBO;
import com.tydic.order.pec.bo.sale.UocTabsNumberQueryBO;
import com.tydic.order.pec.comb.afterservice.UocAfterSalesDetailsListQueryCombService;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdAsPurIdxDetailRspBO;
import com.tydic.order.pec.es.bo.UocEsQryAfsListReqBO;
import com.tydic.order.pec.es.bo.UocEsQryAfsListRspBO;
import com.tydic.order.pec.es.bo.UocEsQryAfsListSingleBO;
import com.tydic.order.pec.es.service.UocEsQryAfsListBusiService;
import com.tydic.order.third.intf.ability.umc.PebIntfQryOrgByUserStationAbilityService;
import com.tydic.order.third.intf.bo.umc.EnterpriseOrgBO;
import com.tydic.order.third.intf.bo.umc.QryOrgByUserStationReqBO;
import com.tydic.order.third.intf.bo.umc.QryOrgByUserStationRspBO;
import com.tydic.order.uoc.bo.common.StationWebBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.dao.ConfTabOrdStateMapper;
import com.tydic.order.uoc.dao.po.ConfTabOrdStatePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocAfterSalesDetailsListQueryCombService")
public class UocAfterSalesDetailsListQueryCombServiceImpl
implements UocAfterSalesDetailsListQueryCombService {
    private static final Logger log = LoggerFactory.getLogger(UocAfterSalesDetailsListQueryCombServiceImpl.class);
    @Autowired
    private UocEsQryAfsListBusiService esQryAfsListBusiService;
    @Autowired
    private ConfTabOrdStateMapper confTabOrdStateMapper;
    @Autowired
    private PebIntfQryOrgByUserStationAbilityService pebIntfQryOrgByUserStationAbilityService;

    public UocAfterSalesDetailsListQueryRspBO getAfterSalesDetailsListQuery(UocAfterSalesDetailsListQueryReqBO reqBO) {
        UocAfterSalesDetailsListQueryRspBO rspBO = new UocAfterSalesDetailsListQueryRspBO();
        Boolean isPermission = this.controlPermission(reqBO);
        UocEsQryAfsListReqBO esQryAfsListReqBO = this.buildUocEsQryAfsListReqBO(reqBO);
        UocEsQryAfsListRspBO esQryAfsListRspBO = new UocEsQryAfsListRspBO();
        if (null != reqBO.getTabId()) {
            if (isPermission.booleanValue()) {
                esQryAfsListRspBO = this.esQryAfsListBusiService.qryAfsList(esQryAfsListReqBO);
            }
            if (!"0000".equals(esQryAfsListRspBO.getRespCode())) {
                throw new BusinessException(esQryAfsListRspBO.getRespCode(), esQryAfsListRspBO.getRespDesc());
            }
            this.transEsQryAfsListRspBO(esQryAfsListRspBO, rspBO, isPermission);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getTabIdList())) {
            esQryAfsListReqBO.setIsQueryTab(true);
            Map<Integer, ConfTabOrdStatePO> tabInfoMap = this.getStatueList(reqBO.getTabIdList());
            esQryAfsListReqBO.setServStateList(tabInfoMap.get(0).getStatueList());
            if (isPermission.booleanValue()) {
                esQryAfsListRspBO = this.esQryAfsListBusiService.qryAfsList(esQryAfsListReqBO);
            }
            this.transOrderTabInfo(esQryAfsListRspBO, rspBO, tabInfoMap, isPermission);
        }
        return rspBO;
    }

    private UocEsQryAfsListReqBO buildUocEsQryAfsListReqBO(UocAfterSalesDetailsListQueryReqBO reqBO) {
        return (UocEsQryAfsListReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocEsQryAfsListReqBO.class);
    }

    private Map<Integer, ConfTabOrdStatePO> getStatueList(List<Integer> tabIds) {
        ConfTabOrdStatePO tabOrdStatePO = new ConfTabOrdStatePO();
        HashMap<Integer, ConfTabOrdStatePO> tabInfoMap = new HashMap<Integer, ConfTabOrdStatePO>();
        ArrayList<Integer> statueList = new ArrayList<Integer>();
        tabOrdStatePO.setTabIdList(tabIds);
        List confTabOrdStatePOList = this.confTabOrdStateMapper.getList(tabOrdStatePO);
        if (CollectionUtils.isNotEmpty((Collection)confTabOrdStatePOList)) {
            for (ConfTabOrdStatePO confTabOrdStatePO : confTabOrdStatePOList) {
                ArrayList<Integer> statueItemList = new ArrayList<Integer>();
                String statueStr = confTabOrdStatePO.getOrderStatusCode();
                if (!StringUtils.isEmpty((CharSequence)statueStr)) {
                    String[] statue = statueStr.contains(",") ? statueStr.split(",") : new String[]{statueStr};
                    for (String state : statue) {
                        statueItemList.add(Integer.valueOf(state));
                        statueList.add(Integer.valueOf(state));
                    }
                }
                confTabOrdStatePO.setStatueList(statueItemList);
                tabInfoMap.put(confTabOrdStatePO.getTabId(), confTabOrdStatePO);
            }
            ConfTabOrdStatePO confTabOrdStatePO = new ConfTabOrdStatePO();
            confTabOrdStatePO.setStatueList(statueList.stream().distinct().collect(Collectors.toList()));
            tabInfoMap.put(0, confTabOrdStatePO);
        }
        return tabInfoMap;
    }

    private void transEsQryAfsListRspBO(UocEsQryAfsListRspBO esQryAfsListRspBO, UocAfterSalesDetailsListQueryRspBO rspBO, Boolean isPermission) {
        if (isPermission.booleanValue()) {
            rspBO.setPageNo(esQryAfsListRspBO.getPageNo());
            rspBO.setRecordsTotal(esQryAfsListRspBO.getRecordsTotal());
            rspBO.setTotal(esQryAfsListRspBO.getTotal());
            ArrayList<UocPebOrdAsPurIdxDetailRspBO> rows = new ArrayList<UocPebOrdAsPurIdxDetailRspBO>();
            if (CollectionUtils.isNotEmpty((Collection)esQryAfsListRspBO.getRows())) {
                for (UocEsQryAfsListSingleBO esQryAfsListSingleBO : esQryAfsListRspBO.getRows()) {
                    if (null != esQryAfsListSingleBO) {
                        rows.add(esQryAfsListSingleBO.getPebOrdAsPurIdxDetailRspBO());
                        continue;
                    }
                    rspBO.setRecordsTotal(rspBO.getRecordsTotal() - 1);
                }
                rspBO.setRows(rows);
            }
        } else {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList(0));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
    }

    private void transOrderTabInfo(UocEsQryAfsListRspBO esQryOrderListRspBO, UocAfterSalesDetailsListQueryRspBO rspBO, Map<Integer, ConfTabOrdStatePO> tabInfoMap, Boolean isPermission) {
        ArrayList<UocTabsNumberQueryBO> afterTabCountList = new ArrayList<UocTabsNumberQueryBO>();
        Map<Integer, Integer> tabCountsMap = esQryOrderListRspBO.getTabCountsMap();
        for (Map.Entry<Integer, ConfTabOrdStatePO> m : tabInfoMap.entrySet()) {
            if (m.getKey().equals(0)) continue;
            ConfTabOrdStatePO tabOrdStatePO = m.getValue();
            UocTabsNumberQueryBO tabsNumberQueryBO = new UocTabsNumberQueryBO();
            tabsNumberQueryBO.setTabId(tabOrdStatePO.getTabId() + "");
            tabsNumberQueryBO.setTabName(tabOrdStatePO.getTabName());
            int tabsCount = 0;
            if (isPermission.booleanValue()) {
                for (Integer statue : tabOrdStatePO.getStatueList()) {
                    Integer tabMapCounts = tabCountsMap.get(statue);
                    if (tabMapCounts == null) continue;
                    tabsCount += tabMapCounts.intValue();
                }
            }
            tabsNumberQueryBO.setTabsCount(Integer.valueOf(tabsCount));
            afterTabCountList.add(tabsNumberQueryBO);
        }
        rspBO.setAfterTabCountList(afterTabCountList);
    }

    private Boolean controlPermission(UocAfterSalesDetailsListQueryReqBO reqBO) {
        if (null != reqBO.getIsControlData() && reqBO.getIsControlData().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
                throw new BusinessException("0001", "\u5165\u53c2\u5c97\u4f4d\u4fe1\u606f[umcStationsListWebExt]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<String> orderSourceList = new ArrayList<String>();
            for (StationWebBO stationWebBO : reqBO.getUmcStationsListWebExt()) {
                if ("cs:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("2");
                } else if ("zq:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("1");
                }
                if (orderSourceList.size() != 2) continue;
                break;
            }
            if (orderSourceList.size() == 0) {
                return false;
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderSourceList())) {
                reqBO.getOrderSourceList().removeIf(orderSource -> !orderSourceList.contains(orderSource));
            } else if (orderSourceList.size() < 2) {
                reqBO.setOrderSourceList(orderSourceList);
            }
        }
        if (null != reqBO.getIsControlPermission() && reqBO.getIsControlPermission().booleanValue() && StringUtils.isBlank((CharSequence)reqBO.getCreateOperId())) {
            QryOrgByUserStationReqBO qryOrgReqBO = new QryOrgByUserStationReqBO();
            if (null == reqBO.getMemIdExt() || 0L == reqBO.getMemIdExt()) {
                throw new BusinessException("0001", "\u5165\u53c2\u4f1a\u5458ID[memIdExt]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            qryOrgReqBO.setMemIdExt(reqBO.getMemIdExt());
            qryOrgReqBO.setStationType("ORDER_QRY_ORG_AUTH");
            QryOrgByUserStationRspBO qryOrgRspBO = this.pebIntfQryOrgByUserStationAbilityService.qryOrgByUserStation(qryOrgReqBO);
            log.debug("\u552e\u540e\u5217\u8868\u67e5\u8be2\u5f53\u524d\u767b\u9646\u4eba\u673a\u6784\u5217\u8868\u7ed3\u679c\u4e3a:" + JSON.toJSONString((Object)qryOrgRspBO));
            if (!"0000".equals(qryOrgRspBO.getRespCode())) {
                throw new BusinessException(qryOrgRspBO.getRespCode(), qryOrgRspBO.getRespDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPurNo())) {
                if (null == reqBO.getPurNoList()) {
                    reqBO.setPurNoList(new ArrayList());
                }
                reqBO.getPurNoList().add(reqBO.getPurNo());
                reqBO.setPurNoList(reqBO.getPurNoList().stream().distinct().collect(Collectors.toList()));
                reqBO.setPurNo(null);
            }
            if (!qryOrgRspBO.getViewAllFlag().booleanValue() && qryOrgRspBO.getRows().isEmpty()) {
                if (null == reqBO.getOrgId() || 0L == reqBO.getOrgId()) {
                    throw new BusinessException("0001", "\u5165\u53c2\u673a\u6784ID[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String purNo2 = reqBO.getOrgId() + "";
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurNoList()) && !reqBO.getPurNoList().contains(purNo2)) {
                    return false;
                }
                reqBO.setPurNoList(Collections.singletonList(purNo2));
            } else if (!qryOrgRspBO.getViewAllFlag().booleanValue() && !qryOrgRspBO.getRows().isEmpty()) {
                ArrayList<String> purNoList = new ArrayList<String>();
                for (EnterpriseOrgBO enterpriseOrgBO : qryOrgRspBO.getRows()) {
                    purNoList.add(enterpriseOrgBO.getOrgId() + "");
                }
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurNoList())) {
                    reqBO.getPurNoList().removeIf(purNo -> !purNoList.contains(purNo));
                } else {
                    reqBO.setPurNoList(purNoList);
                }
            }
        }
        return true;
    }
}

