/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.es.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.order.pec.bo.inspection.UocInspectionDetailsListBO;
import com.tydic.order.pec.es.bo.UocEsQryInspectionListReqBO;
import com.tydic.order.pec.es.bo.UocEsQryInspectionListRspBO;
import com.tydic.order.pec.es.config.UocEsConfig;
import com.tydic.order.pec.es.service.UocEsQryInspectionListBusiService;
import com.tydic.order.pec.es.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.order.pec.es.utils.UocElasticsearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocEsQryInspectionListBusiService")
public class UocEsQryInspectionListBusiServiceImpl
implements UocEsQryInspectionListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocEsQryInspectionListBusiServiceImpl.class);
    private UocEsConfig uocEsConfig;
    private UocElasticsearchUtil uocElasticsearchUtil;
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public UocEsQryInspectionListBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsQryInspectionListRspBO esQryInspectionList(UocEsQryInspectionListReqBO reqBO) {
        UocEsQryInspectionListRspBO rspBO = new UocEsQryInspectionListRspBO();
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryInspectionEsSql(reqBO);
        LOGGER.debug("ES\u67e5\u8be2\u9a8c\u6536\u5355\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.uocEsConfig.getInspectionIndexName() + "/" + this.uocEsConfig.getInspectionIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            System.out.println("ES\u67e5\u8be2\u9a8c\u6536\u5355result---->" + result);
            rspBO = this.resovelRetrunData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        }
        catch (IOException e) {
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u9a8c\u6536\u5355\u5217\u8868\u4fe1\u606f\u9a8c\u6536!");
        }
        return rspBO;
    }

    private UocEsQryInspectionListRspBO resovelRetrunData(String result, UocEsQryInspectionListRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u9a8c\u6536\u5355\u4fe1\u606f!");
            return rspBO;
        }
        ArrayList<UocInspectionDetailsListBO> rows = new ArrayList<UocInspectionDetailsListBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            UocInspectionDetailsListBO esQryInspectionListSingleBO = (UocInspectionDetailsListBO)JSON.toJavaObject((JSON)objJson, UocInspectionDetailsListBO.class);
            rows.add(esQryInspectionListSingleBO);
        }
        Integer totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u9a8c\u6536\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
        return rspBO;
    }
}

