/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.es.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.order.pec.es.bo.UocEsCountStateNumReqBO;
import com.tydic.order.pec.es.bo.UocEsQryAbnormalListReqBO;
import com.tydic.order.pec.es.bo.UocEsQryAbnormalTabNumberReqBO;
import com.tydic.order.pec.es.bo.UocEsQryAfsListReqBO;
import com.tydic.order.pec.es.bo.UocEsQryAfsTabNumberReqBO;
import com.tydic.order.pec.es.bo.UocEsQryInspectionListReqBO;
import com.tydic.order.pec.es.bo.UocEsQryOrderListReqBO;
import com.tydic.order.pec.es.bo.UocEsQryOrderTabNumberReqBO;
import com.tydic.order.pec.es.bo.UocEsQryPurchaseListReqBO;
import com.tydic.order.pec.es.bo.UocSearchEsSQLRspBO;
import com.tydic.order.uoc.bo.order.UocExpansionConditionsMapBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UocBuildEsQrySqlConditionUtil {
    private static Integer maxPageSize;

    @Value(value="${es.max.page.size:10000}")
    public void setMaxPageSize(Integer maxPageSize) {
        UocBuildEsQrySqlConditionUtil.maxPageSize = maxPageSize;
    }

    /*
     * WARNING - void declaration
     */
    public String buildQryOrderEsSql(UocEsQryOrderListReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getExpansionConditionsMap() != null && !reqBO.getExpansionConditionsMap().isEmpty()) {
            for (Map.Entry<String, UocExpansionConditionsMapBO> entry : reqBO.getExpansionConditionsMap().entrySet()) {
                String mapKey = entry.getKey();
                UocExpansionConditionsMapBO mapValue = entry.getValue();
                if (mapValue.getIsExpansionConditions().booleanValue()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
            }
        }
        if (reqBO.getSaleStateList() != null && !reqBO.getSaleStateList().isEmpty()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
        } else if (reqBO.getSaleState() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleState", (Object)reqBO.getSaleState()));
        }
        if (reqBO.getServStateList() != null && !reqBO.getServStateList().isEmpty()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
        } else if (reqBO.getServState() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)reqBO.getServState()));
        }
        if (reqBO.getOrderId() != null && reqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", (String)reqBO.getOrderSource()));
        }
        if (reqBO.getServType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderDesc())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderDesc.keyword", (String)("*" + reqBO.getOrderDesc() + "*")));
        }
        if (null != reqBO.getSaleVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"objId.keyword", (String)("*" + reqBO.getSaleVoucherId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAggregationCondition())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"aggregationCondition.keyword", (String)("*" + reqBO.getAggregationCondition() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (String)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outSkuId.keyword", (String)("*" + reqBO.getOutSkuId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getReceiver())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"receiver", (Object)reqBO.getReceiver()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTbOrderId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"tbOrderId", (Object)reqBO.getTbOrderId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getConsignee())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consignee.keyword", (String)("*" + reqBO.getConsignee() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getConsigneePhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consigneePhone.keyword", (String)("*" + reqBO.getConsigneePhone() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayVourcherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"payVourcherNo", (Object)reqBO.getPayVourcherNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateOperName() + "*")));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateUserName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateUserName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperPhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperPhone.keyword", (String)("*" + reqBO.getCreateOperPhone() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purAccount", reqBO.getPurAccountList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccount())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", (String)reqBO.getPurAccount()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (null != reqBO.getRefundFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"refundFlag", (Object)reqBO.getRefundFlag()));
        } else if (null != reqBO.getReturnFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"refundFlag", (Object)reqBO.getReturnFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEvaluationState())) {
            if ("0".equals(reqBO.getEvaluationState())) {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"evaluateState", (String)"1"));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"evaluateState", (String)reqBO.getEvaluationState()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlaAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"plaAgreementCode", (String)reqBO.getPlaAgreementCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orderName", (Object)reqBO.getOrderName()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"protocolName", (Object)reqBO.getProtocolName()));
        }
        if (null != reqBO.getVendorDepartmentId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendorDepartmentId", (Object)reqBO.getVendorDepartmentId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDistributionDept())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"distributionDept", (Object)reqBO.getDistributionDept()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supAgreementCode", (String)reqBO.getSupAgreementCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupAgreementName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"supAgreementName", (Object)reqBO.getSupAgreementName()));
        }
        if (null != reqBO.getPurchaseVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaseVoucherId", (Object)reqBO.getPurchaseVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaseVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaseVoucherNo.keyword", (String)("*" + reqBO.getPurchaseVoucherNo() + "*")));
        }
        if (null != reqBO.getPurchaseState()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaseState", (Object)reqBO.getPurchaseState()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"protocolId", (String)reqBO.getProtocolId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSalePostIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String salePostIdList : reqBO.getSalePostIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"salePostIdList", (String)salePostIdList));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proAccount", reqBO.getProAccountList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNo", reqBO.getSupNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"taskOperIdList", (String)taskOperId));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getExcessApproverList())) {
                for (String excessApprover : reqBO.getExcessApproverList()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"excessApproverList", (String[])new String[]{excessApprover}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getExcessApproverList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String excessApprover : reqBO.getExcessApproverList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"excessApproverList", (String[])new String[]{excessApprover}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList()) && CollectionUtils.isNotEmpty(reqBO.getOnceProDeliveryIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"onceProDeliveryId", reqBO.getOnceProDeliveryIdList()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList()) && CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getOnceProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"onceProDeliveryId", reqBO.getOnceProDeliveryIdList()));
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPriceTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getPriceTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"priceTaskOperIdList", (String)taskOperId));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getPriceApproverList())) {
                for (String priceApprover : reqBO.getPriceApproverList()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceApproverList", (String[])new String[]{priceApprover}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPriceTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceTaskUserIdList", (String[])new String[]{reqBO.getPriceTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getPriceApproverList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String priceApprover : reqBO.getPriceApproverList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceApproverList", (String[])new String[]{priceApprover}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPriceTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"priceTaskUserIdList", (String[])new String[]{reqBO.getPriceTaskUserId()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurRelaName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purRelaName.keyword", (String)("*" + reqBO.getPurRelaName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getVendorOrderType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendorOrderType", (String)reqBO.getVendorOrderType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long l = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)l);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long l = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)l);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsAfterSales() && reqBO.getIsAfterSales().booleanValue()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"availableAfterOrderCount");
            rangeQueryBuilder.gt((Object)0);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getUpdateTime() != null && reqBO.getUpdateTime() != 0L) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"updateTime");
            Long l = reqBO.getUpdateTime();
            rangeQueryBuilder.lte((Object)l);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        SortOrder order = SortOrder.DESC;
        if (reqBO.getNotShipTime() != null) {
            RangeQueryBuilder rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"payTime");
            Long createTimeEff2 = reqBO.getNotShipTime().getTime();
            rangeQueryBuilder2.lte((Object)createTimeEff2);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
            order = SortOrder.ASC;
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            void var4_27;
            Object var4_25 = null;
            if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
                TermsAggregationBuilder termsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != var4_27) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)var4_27.toString()));
            }
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != var4_27) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)var4_27.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> arrayList = new ArrayList<FieldSortBuilder>();
        if (reqBO.getOrderBy() != null) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        arrayList.add(sortQueryFirst);
        uocSearchEsSQLRspBO.setSortQuery(arrayList);
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String countOrderTabNumber(UocEsQryOrderTabNumberReqBO reqBO) {
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getExpansionConditionsMap() != null && !reqBO.getExpansionConditionsMap().isEmpty()) {
            for (Map.Entry<String, UocExpansionConditionsMapBO> entry : reqBO.getExpansionConditionsMap().entrySet()) {
                String mapKey = entry.getKey();
                UocExpansionConditionsMapBO mapValue = entry.getValue();
                if (mapValue.getIsExpansionConditions().booleanValue()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
            }
        }
        if (reqBO.getOrderId() != null && reqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", (String)reqBO.getOrderSource()));
        }
        if (reqBO.getServType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderDesc())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderDesc.keyword", (String)("*" + reqBO.getOrderDesc() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAggregationCondition())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"aggregationCondition.keyword", (String)("*" + reqBO.getAggregationCondition() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (String)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outSkuId.keyword", (String)("*" + reqBO.getOutSkuId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTbOrderId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"tbOrderId", (Object)reqBO.getTbOrderId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getConsignee())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consignee.keyword", (String)("*" + reqBO.getConsignee() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getConsigneePhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consigneePhone.keyword", (String)("*" + reqBO.getConsigneePhone() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayVourcherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"payVourcherNo", (Object)reqBO.getPayVourcherNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperPhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperPhone.keyword", (String)("*" + reqBO.getCreateOperPhone() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", reqBO.getPurAccountList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccount())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", (String)reqBO.getPurAccount()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (null != reqBO.getRefundFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"refundFlag", (Object)reqBO.getRefundFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlaAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"plaAgreementCode", (String)reqBO.getPlaAgreementCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orderName", (Object)reqBO.getOrderName()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"protocolName", (Object)reqBO.getProtocolName()));
        }
        if (null != reqBO.getVendorDepartmentId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendorDepartmentId", (Object)reqBO.getVendorDepartmentId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDistributionDept())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"distributionDept", (Object)reqBO.getDistributionDept()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supAgreementCode", (String)reqBO.getSupAgreementCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupAgreementName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"supAgreementName", (Object)reqBO.getSupAgreementName()));
        }
        if (null != reqBO.getPurchaseVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaseVoucherId", (Object)reqBO.getPurchaseVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaseVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaseVoucherNo.keyword", (String)("*" + reqBO.getPurchaseVoucherNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"protocolId", (String)reqBO.getProtocolId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proAccount", reqBO.getProAccountList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNo", reqBO.getSupNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"taskOperIdList", (String)taskOperId));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getExcessApproverList())) {
                for (String excessApprover : reqBO.getExcessApproverList()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"excessApproverList", (String[])new String[]{excessApprover}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getExcessApproverList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String excessApprover : reqBO.getExcessApproverList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"excessApproverList", (String[])new String[]{excessApprover}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList()) && CollectionUtils.isNotEmpty(reqBO.getOnceProDeliveryIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"onceProDeliveryId", reqBO.getOnceProDeliveryIdList()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList()) && CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getOnceProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"onceProDeliveryId", reqBO.getOnceProDeliveryIdList()));
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSalePostIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String salePostIdList : reqBO.getSalePostIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"salePostIdList", (String)salePostIdList));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPriceTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getPriceTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"priceTaskOperIdList", (String)taskOperId));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getPriceApproverList())) {
                for (String priceApprover : reqBO.getPriceApproverList()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceApproverList", (String[])new String[]{priceApprover}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPriceTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceTaskUserIdList", (String[])new String[]{reqBO.getPriceTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getPriceApproverList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String priceApprover : reqBO.getPriceApproverList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceApproverList", (String[])new String[]{priceApprover}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPriceTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"priceTaskUserIdList", (String[])new String[]{reqBO.getPriceTaskUserId()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurRelaName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purRelaName.keyword", (String)("*" + reqBO.getPurRelaName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long l = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)l);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long l = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)l);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getUpdateTime() != null && reqBO.getUpdateTime() != 0L) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"updateTime");
            Long l = reqBO.getUpdateTime();
            rangeQueryBuilder.lte((Object)l);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getNotShipTime() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"payTime");
            Long l = reqBO.getNotShipTime().getTime();
            rangeQueryBuilder.lte((Object)l);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        TermsAggregationBuilder agg = null;
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurchaseStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaseState", reqBO.getPurchaseStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("purchaseState");
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("size", (Object)0);
        jSONObject.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        if (null != agg) {
            jSONObject.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
        }
        return jSONObject.toJSONString();
    }

    public String buildQryAfsEsSql(UocEsQryAfsListReqBO reqBO) {
        Integer servState;
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getOrderId() != null && reqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (reqBO.getObjId() != null && reqBO.getObjId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"objId", (Object)reqBO.getObjId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purNo", (String)reqBO.getPurNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAfsServiceId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"afsServiceId.keyword", (String)("*" + reqBO.getAfsServiceId() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getStatusPostIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String statusPostIdList : reqBO.getStatusPostIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"statusPostIdList", (String)statusPostIdList));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", (String[])new String[]{reqBO.getOrderSource()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && StringUtils.isNotBlank((CharSequence)reqBO.getAcceptorId())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"acceptorId", (String)reqBO.getAcceptorId()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderName.keyword", (String)("*" + reqBO.getOrderName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaserVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaserVoucherNo.keyword", (String)("*" + reqBO.getPurchaserVoucherNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (String)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outSkuId.keyword", (String)("*" + reqBO.getOutSkuId() + "*")));
        }
        if (null != reqBO.getServType() && null != reqBO.getDealResult() && CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
            servState = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(2, 6));
            if (reqBO.getServStateList().contains(servState)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)servState));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
            }
        } else if (null != reqBO.getServType() && null != reqBO.getDealResult()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
            servState = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(2, 6));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)servState));
        } else if (null != reqBO.getDealResult() && CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            servState = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(2, 6));
            if (reqBO.getServStateList().contains(servState)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)servState));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
            }
        } else if (null != reqBO.getServType() && CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
        } else if (null != reqBO.getDealResult()) {
            Integer servType = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(0, 2));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)servType));
            Integer servState2 = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(2, 6));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)servState2));
        } else if (null != reqBO.getServType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
        } else if (CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
        } else if (null != reqBO.getServState()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)reqBO.getServState()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAfterServiceNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"afterServiceNo.keyword", (String)("*" + reqBO.getAfterServiceNo() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purName.keyword", (String)("*" + reqBO.getPurName() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purAccount", reqBO.getPurAccountList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccountName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purAccountName.keyword", (String)("*" + reqBO.getPurAccountName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getJdShippingInfoStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"jdShippingInfoStatus", (String)reqBO.getJdShippingInfoStatus()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("servState");
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(SortOrder.DESC)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String countAfsTabNumber(UocEsQryAfsTabNumberReqBO reqBO) {
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getOrderId() != null && reqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (reqBO.getObjId() != null && reqBO.getObjId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"objId", (Object)reqBO.getObjId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"supNo", (Object)reqBO.getOrgId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAfsServiceId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"afsServiceId.keyword", (String)("*" + reqBO.getAfsServiceId() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getStatusPostIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String statusPostIdList : reqBO.getStatusPostIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"statusPostIdList", (String)statusPostIdList));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", (String[])new String[]{reqBO.getOrderSource()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && StringUtils.isNotBlank((CharSequence)reqBO.getAcceptorId())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"acceptorId", (String)reqBO.getAcceptorId()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaserVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaserVoucherNo.keyword", (String)("*" + reqBO.getPurchaserVoucherNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (String)reqBO.getSkuId()));
        }
        if (null != reqBO.getServType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAfterServiceNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"afterServiceNo.keyword", (String)("*" + reqBO.getAfterServiceNo() + "*")));
        }
        if (null != reqBO.getDealResult()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"dealResult", (Object)reqBO.getDealResult()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purName.keyword", (String)("*" + reqBO.getPurName() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purAccount", reqBO.getPurAccountList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccountName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purAccountName.keyword", (String)("*" + reqBO.getPurAccountName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getJdShippingInfoStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"jdShippingInfoStatus", (String)reqBO.getJdShippingInfoStatus()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        TermsAggregationBuilder agg = null;
        if (CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("servState");
        }
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)0);
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        if (null != agg) {
            queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
        }
        return queryJson.toJSONString();
    }

    private String getQueryString(UocSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        if (maxPageSize < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)maxPageSize);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        String queryString = uocSearchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String sortString = uocSearchEsSQLRspBO.getSortQuery().toString();
        queryJson.put("sort", (Object)JSON.parseArray((String)sortString));
        return queryJson.toJSONString();
    }

    public String countStateNum(UocEsCountStateNumReqBO uocEsCountStateNumReqBO) {
        Long createTimeEff;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (uocEsCountStateNumReqBO.getOrderId() != null && uocEsCountStateNumReqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)uocEsCountStateNumReqBO.getOrderId()));
        }
        if (uocEsCountStateNumReqBO.getServType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)uocEsCountStateNumReqBO.getServType()));
        }
        if (CollectionUtils.isNotEmpty(uocEsCountStateNumReqBO.getOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNo", uocEsCountStateNumReqBO.getOrgIds()));
        } else if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)uocEsCountStateNumReqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getOrderDesc())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderDesc.keyword", (String)("*" + uocEsCountStateNumReqBO.getOrderDesc() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getAggregationCondition())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"aggregationCondition.keyword", (String)("*" + uocEsCountStateNumReqBO.getAggregationCondition() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"skuName", (Object)uocEsCountStateNumReqBO.getSkuName()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getTbOrderId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"tbOrderId", (Object)uocEsCountStateNumReqBO.getTbOrderId()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getConsignee())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consignee.keyword", (String)("*" + uocEsCountStateNumReqBO.getConsignee() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getConsigneePhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consigneePhone.keyword", (String)("*" + uocEsCountStateNumReqBO.getConsigneePhone() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getOutOrderNo())) {
            BoolQueryBuilder shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + uocEsCountStateNumReqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + uocEsCountStateNumReqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getPayVourcherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"payVourcherNo", (Object)uocEsCountStateNumReqBO.getPayVourcherNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + uocEsCountStateNumReqBO.getCreateOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateOperPhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperPhone.keyword", (String)("*" + uocEsCountStateNumReqBO.getCreateOperPhone() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", (String)uocEsCountStateNumReqBO.getOrderSource()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)uocEsCountStateNumReqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)uocEsCountStateNumReqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (uocEsCountStateNumReqBO.getUpdateTime() != null && uocEsCountStateNumReqBO.getUpdateTime() != 0L) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"updateTime");
            createTimeEff = uocEsCountStateNumReqBO.getUpdateTime();
            rangeQueryBuilder.lte((Object)createTimeEff);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (uocEsCountStateNumReqBO.getNotShipTime() != null) {
            Long createTimeEff2 = uocEsCountStateNumReqBO.getNotShipTime().getTime();
            RangeQueryBuilder rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"payTime");
            rangeQueryBuilder2.lte((Object)createTimeEff2);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        TermsAggregationBuilder agg = null;
        if (CollectionUtils.isNotEmpty(uocEsCountStateNumReqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", uocEsCountStateNumReqBO.getServStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("servState");
        }
        if (CollectionUtils.isNotEmpty(uocEsCountStateNumReqBO.getStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", uocEsCountStateNumReqBO.getStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
        }
        if (uocEsCountStateNumReqBO.getServState() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)uocEsCountStateNumReqBO.getServState()));
        }
        if (uocEsCountStateNumReqBO.getSaleState() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleState", (Object)uocEsCountStateNumReqBO.getSaleState()));
        }
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)0);
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        if (null != agg) {
            queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
        }
        return queryJson.toJSONString();
    }

    public String buildQryAbnormalEsSql(UocEsQryAbnormalListReqBO reqBO) {
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty(reqBO.getTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"taskOperIdList", (String)taskOperId));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOwnOperId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"ownOperIdList", (String)reqBO.getOwnOperId()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOwnOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ownOperIdList", (String)reqBO.getOwnOperId()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPurNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purNo", (String)reqBO.getPurNo()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (reqBO.getChangeType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"changeType", (Object)reqBO.getChangeType()));
        }
        if (reqBO.getAbnormalVoucherNo() != null && 0L != reqBO.getAbnormalVoucherNo()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"abnormalVoucherNo", (Object)reqBO.getAbnormalVoucherNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccount())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", (String)reqBO.getPurAccount()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String countAbnormalTabNumber(UocEsQryAbnormalTabNumberReqBO reqBO) {
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty(reqBO.getTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"taskOperIdList", (String)taskOperId));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOwnOperId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"ownOperIdList", (String)reqBO.getOwnOperId()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOwnOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ownOperId", (String)reqBO.getOwnOperId()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (reqBO.getChangeType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"changeType", (Object)reqBO.getChangeType()));
        }
        if (reqBO.getAbnormalVoucherNo() != null && 0L != reqBO.getAbnormalVoucherNo()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"abnormalVoucherNo", (Object)reqBO.getAbnormalVoucherNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccount())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", (String)reqBO.getPurAccount()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        TermsAggregationBuilder agg = null;
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
        }
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)0);
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        if (null != agg) {
            queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
        }
        return queryJson.toJSONString();
    }

    public String buildQryPurchaseEsSql(UocEsQryPurchaseListReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getPurchaseVoucherId() != null && reqBO.getPurchaseVoucherId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaseVoucherId.keyword", (String)("*" + reqBO.getPurchaseVoucherId() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurchaseStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaseState", reqBO.getPurchaseStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"protocolNo.keyword", (String)("*" + reqBO.getProtocolNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String buildQryInspectionEsSql(UocEsQryInspectionListReqBO reqBO) {
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (null != reqBO.getInspectionVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"objId", (Object)reqBO.getInspectionVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionVoucherCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"inspectionVoucherCode.keyword", (String)("*" + reqBO.getInspectionVoucherCode() + "*")));
        }
        if (null != reqBO.getOrderId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderName.keyword", (String)("*" + reqBO.getOrderName() + "*")));
        }
        if (null != reqBO.getSaleVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleVoucherId", (Object)reqBO.getSaleVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPurNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purNo", (String)reqBO.getPurNo()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && StringUtils.isNotBlank((CharSequence)reqBO.getAcceptorId())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"acceptorId", (String)reqBO.getAcceptorId()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getOrderCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"orderCreateTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderCreateTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getOrderCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getOrderCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsAfterSales() && reqBO.getIsAfterSales().booleanValue()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"availableOrderAfterCount");
            rangeQueryBuilder.gt((Object)0);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }
}

